/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.modelling.regression;

import jdplus.toolkit.base.api.processing.ProcessingLog;
import jdplus.toolkit.base.api.timeseries.TimeSeriesDomain;
import jdplus.toolkit.base.api.timeseries.TimeSeriesInterval;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsDomain;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.api.timeseries.regression.TsVariables;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.modelling.regression.RegressionVariableFactory;

class TsVariablesFactory
implements RegressionVariableFactory<TsVariables> {
    static final String NOTFOUND = ": data not found";
    static final String TOOSHORT = ": series too short. Zeroes added";
    static TsVariablesFactory FACTORY = new TsVariablesFactory();

    private TsVariablesFactory() {
    }

    @Override
    public boolean fill(TsVariables var, TsPeriod start, FastMatrix buffer, ProcessingLog log) {
        int nvars = var.dim();
        int n = buffer.getRowsCount();
        for (int i = 0; i < nvars; ++i) {
            TsData v = var.getData(i);
            if (v == null) {
                if (log == null) continue;
                log.warning(var.getId(i) + NOTFOUND);
                continue;
            }
            TsDomain curdom = v.getDomain();
            int istart = curdom.getStartPeriod().until(start);
            int m = curdom.getLength();
            int iend = istart + n;
            int jstart = 0;
            int jend = n;
            boolean ok = true;
            if (istart < 0) {
                ok = false;
                jstart = -istart;
                istart = 0;
            }
            if (iend > m) {
                jend -= iend - m;
                iend = m;
                ok = false;
            }
            if (!ok && log != null) {
                log.warning(var.getId(i) + TOOSHORT);
            }
            if (jstart >= jend) continue;
            buffer.column(i).range(jstart, jend).copy(v.getValues().range(istart, iend));
        }
        return true;
    }

    @Override
    public <P extends TimeSeriesInterval<?>, D extends TimeSeriesDomain<P>> boolean fill(TsVariables var, D domain, FastMatrix buffer, ProcessingLog log) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

