/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.regarima.estimation;

import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.arima.IArimaModel;
import jdplus.toolkit.base.core.math.functions.IFunction;
import jdplus.toolkit.base.core.math.functions.IParametersDomain;
import jdplus.toolkit.base.core.math.functions.IParametricMapping;
import jdplus.toolkit.base.core.math.functions.ssq.ISsqFunction;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.regarima.estimation.ArmaEvaluation;
import jdplus.toolkit.base.core.regarima.estimation.ConcentratedLikelihoodComputer;
import jdplus.toolkit.base.core.stats.likelihood.DefaultLikelihoodEvaluation;
import jdplus.toolkit.base.core.stats.likelihood.Likelihood;

public class ArmaFunction<S extends IArimaModel>
implements ISsqFunction,
IFunction {
    final DoubleSeq dy;
    final FastMatrix x;
    final int nmissing;
    final IParametricMapping<S> mapping;
    final ConcentratedLikelihoodComputer cll;
    final ToDoubleFunction<Likelihood> ll;
    final ToDoubleFunction<Likelihood> ssqll;
    final Function<Likelihood, DoubleSeq> errors;
    final boolean mt;

    public static <S extends IArimaModel> Builder<S> builder(DoubleSeq dy) {
        return new Builder(dy);
    }

    private ArmaFunction(DoubleSeq dy, FastMatrix x, int nm, IParametricMapping<S> mapping, ConcentratedLikelihoodComputer cll, ToDoubleFunction<Likelihood> ll, ToDoubleFunction<Likelihood> ssqll, Function<Likelihood, DoubleSeq> errors, boolean mt) {
        this.dy = dy;
        this.x = x;
        this.nmissing = nm;
        this.mapping = mapping;
        this.cll = cll;
        this.ll = ll;
        this.ssqll = ssqll;
        this.errors = errors;
        this.mt = mt;
    }

    @Override
    public ArmaEvaluation<S> evaluate(DoubleSeq parameters) {
        return new ArmaEvaluation(this, parameters);
    }

    @Override
    public IParametersDomain getDomain() {
        return this.mapping;
    }

    @Override
    public ArmaEvaluation<S> ssqEvaluate(DoubleSeq parameters) {
        return new ArmaEvaluation(this, parameters);
    }

    public static class Builder<S extends IArimaModel> {
        public static final ToDoubleFunction<Likelihood> LL = DefaultLikelihoodEvaluation.ml();
        public static final Function<Likelihood, DoubleSeq> ERRORS = DefaultLikelihoodEvaluation.v();
        public static final ToDoubleFunction<Likelihood> SSQLL = DefaultLikelihoodEvaluation.deviance();
        private ToDoubleFunction<Likelihood> ll = LL;
        private ToDoubleFunction<Likelihood> ssqll = SSQLL;
        private Function<Likelihood, DoubleSeq> errors = ERRORS;
        private ConcentratedLikelihoodComputer cll = ConcentratedLikelihoodComputer.DEFAULT_FULL_COMPUTER;
        private boolean mt = false;
        private final DoubleSeq dy;
        private FastMatrix x;
        private int nmissing;
        private IParametricMapping<S> mapping;

        private Builder(DoubleSeq dy) {
            this.dy = dy;
        }

        public Builder variables(FastMatrix x) {
            this.x = x;
            return this;
        }

        public Builder nmissing(int nm) {
            this.nmissing = nm;
            return this;
        }

        public Builder parallelProcessing(boolean parallel) {
            this.mt = parallel;
            return this;
        }

        public Builder evaluation(ToDoubleFunction<Likelihood> ll) {
            this.ll = ll;
            return this;
        }

        public Builder ssqEvaluation(ToDoubleFunction<Likelihood> ssqll) {
            this.ssqll = ssqll;
            return this;
        }

        public Builder evaluation(Function<Likelihood, DoubleSeq> errors) {
            this.errors = errors;
            return this;
        }

        public Builder computer(ConcentratedLikelihoodComputer computer) {
            this.cll = computer;
            return this;
        }

        public ArmaFunction<S> build() {
            return new ArmaFunction<S>(this.dy, this.x, this.nmissing, this.mapping, this.cll, this.ll, this.ssqll, this.errors, this.mt);
        }
    }
}

