/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.QuadraticForm;
import jdplus.toolkit.base.core.ssf.DataBlockResults;
import jdplus.toolkit.base.core.ssf.IStateResults;
import jdplus.toolkit.base.core.ssf.MatrixResults;
import jdplus.toolkit.base.core.ssf.State;
import jdplus.toolkit.base.core.ssf.StateInfo;

public class StateStorage
implements IStateResults {
    private final DataBlockResults A = new DataBlockResults();
    private final MatrixResults P;
    private final StateInfo info;

    protected StateStorage(StateInfo info, boolean cov) {
        this.P = cov ? new MatrixResults() : null;
        this.info = info;
    }

    public static StateStorage full(StateInfo info) {
        return new StateStorage(info, true);
    }

    public static StateStorage light(StateInfo info) {
        return new StateStorage(info, false);
    }

    public boolean hasVariances() {
        return this.P != null;
    }

    public int size() {
        return this.A.getCurrentSize();
    }

    @Override
    public void save(int t, State state, StateInfo info) {
        if (info != this.info) {
            return;
        }
        this.A.save(t, state.a());
        if (this.P != null) {
            this.P.save(t, state.P());
        }
    }

    public void save(int t, DataBlock a, FastMatrix p) {
        if (this.info != this.info) {
            return;
        }
        this.A.save(t, a);
        if (this.P != null) {
            this.P.save(t, p);
        }
    }

    public DoubleSeq getComponent(int pos) {
        return this.A.item(pos);
    }

    public DoubleSeq zcomponent(DoubleSeq z) {
        double[] a = new double[this.size()];
        for (int i = 0; i < a.length; ++i) {
            a[i] = this.A.datablock(i).dot(z);
        }
        return DoubleSeq.of((double[])a);
    }

    public DoubleSeq zvariance(DoubleSeq z) {
        DataBlock b = DataBlock.of(z);
        double[] a = new double[this.size()];
        for (int i = 0; i < a.length; ++i) {
            a[i] = QuadraticForm.apply(this.P.matrix(i), b);
        }
        return DoubleSeq.of((double[])a);
    }

    public DoubleSeq getComponentVariance(int pos) {
        return this.P.item(pos, pos);
    }

    public DataBlock a(int pos) {
        return this.A.datablock(pos);
    }

    public FastMatrix P(int pos) {
        return this.P == null ? null : this.P.matrix(pos);
    }

    public DataBlock item(int i) {
        return this.A.item(i);
    }

    public DataBlock var(int i) {
        return this.P == null ? DataBlock.EMPTY : this.P.item(i, i);
    }

    public DataBlock covar(int i, int j) {
        return this.P == null ? DataBlock.EMPTY : this.P.item(i, j);
    }

    public int getStart() {
        return this.A.getStartSaving();
    }

    public void prepare(int dim, int start, int end) {
        this.A.prepare(dim, start, end);
        if (this.P != null) {
            this.P.prepare(dim, start, end);
        }
    }

    public void rescaleVariances(double factor) {
        if (this.P != null) {
            this.P.rescale(factor);
        }
    }

    public void clear() {
        this.A.clear();
        if (this.P != null) {
            this.P.clear();
        }
    }
}

