## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
collapse = TRUE,
comment = "#>",
fig.width = 7,
fig.height = 4
)

## -----------------------------------------------------------------------------
library(ECDFniche)

## -----------------------------------------------------------------------------
set.seed(3)
res1 <- ecdf_niche(n = 2)
res1

## -----------------------------------------------------------------------------
res1$corplot

## -----------------------------------------------------------------------------
set.seed(3)
full_res <- run_ecdf_mahal_analysis(dims = 1:5)

## -----------------------------------------------------------------------------
full_res$figure1 |> plot()

## -----------------------------------------------------------------------------
full_res$figure2 |> plot()

## -----------------------------------------------------------------------------
full_res$figure3 |> plot()

## -----------------------------------------------------------------------------
res_custom <- ecdf_niche(
n = 3,
n_population = 20000,
sample_sizes = seq(50, 1000, 50),
seed = 123
)

res_custom$corplot

