## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup, include = FALSE---------------------------------------------------
library(epitraxr)

## ----sample-data--------------------------------------------------------------
data_file <- "vignette-data/epitrax_data.csv"
head(read.csv(data_file))

## ----read_epitrax_data--------------------------------------------------------
epitrax_data <- read_epitrax_data(data_file)
head(epitrax_data)

## ----get-ilist----------------------------------------------------------------
internal_disease_list <- "vignette-data/ireport_diseases.csv"
internal_diseases <- get_report_diseases_internal(internal_disease_list)
head(internal_diseases)

## ----get-plist----------------------------------------------------------------
public_disease_list <- "vignette-data/preport_diseases.csv"
public_diseases <- get_report_diseases_public(public_disease_list)
head(public_diseases)

## ----annual-report-1----------------------------------------------------------
report <- create_report_annual_counts(
  data = epitrax_data,
  diseases = internal_diseases$EpiTrax_name
)

head(report)

## ----annual-report------------------------------------------------------------
report <- create_report_annual_counts(
  data = epitrax_data,
  diseases = public_diseases$EpiTrax_name
)

head(report)

## ----annual-counts-piping-----------------------------------------------------
# Data and configuration files
data_file <- "vignette-data/epitrax_data.csv"
config_file <- "vignette-data/config.yaml"
disease_lists <- list(
  internal = "vignette-data/ireport_diseases.csv",
  public = "vignette-data/preport_diseases.csv"
)

# Run pipe
epitrax <- create_epitrax_from_file(data_file) |>
  epitrax_set_config_from_file(config_file) |>
  epitrax_set_report_diseases(disease_lists) |>
  epitrax_ireport_annual_counts()

# View report
head(epitrax$internal_reports$annual_counts)

## ----many-reports-piping------------------------------------------------------
epitrax <- create_epitrax_from_file(data_file) |>
  epitrax_set_config_from_file(config_file) |>
  epitrax_set_report_diseases(disease_lists) |>
  epitrax_ireport_annual_counts() |>
  epitrax_ireport_monthly_avgs() |>
  epitrax_ireport_ytd_counts_for_month()

list(epitrax$internal_reports)

