/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.stats.likelihood;

import jdplus.toolkit.base.api.DemetraException;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.LowerTriangularMatrix;
import jdplus.toolkit.base.core.math.matrices.SymmetricMatrix;
import jdplus.toolkit.base.core.stats.likelihood.DeterminantalTerm;
import jdplus.toolkit.base.core.stats.likelihood.Likelihood;

public class ResidualsCumulator {
    private static final double ZERO = 1.0E-9;
    DeterminantalTerm m_det = new DeterminantalTerm();
    double m_ssqerr;
    int m_n;

    public void add(DataBlock e, FastMatrix var) {
        if (e.length() == 1) {
            this.add(e.get(0), var.get(0, 0));
        } else {
            FastMatrix l = var.deepClone();
            SymmetricMatrix.lcholesky(l);
            DataBlock el = DataBlock.of((DoubleSeq)e);
            LowerTriangularMatrix.solveLx(l, el);
            DataBlock diag = l.diagonal();
            for (int i = 0; i < el.length(); ++i) {
                double r = diag.get(i);
                if (r == 0.0) continue;
                this.addStd(el.get(i), r);
            }
        }
    }

    public void add(double e, double var) {
        if (Math.abs(var) < 1.0E-9) {
            if (Math.abs(e) < 1.0E-9) {
                return;
            }
            throw new DemetraException();
        }
        this.m_det.add(var);
        this.m_ssqerr += e * e / var;
        ++this.m_n;
    }

    public void addStd(double e, double stde) {
        if (Math.abs(stde) < 1.0E-9 && Math.abs(e) < 1.0E-9) {
            return;
        }
        this.m_det.add(stde * stde);
        this.m_ssqerr += e * e;
        ++this.m_n;
    }

    public void clear() {
        this.m_ssqerr = 0.0;
        this.m_det.clear();
        this.m_n = 0;
    }

    public double getLogDeterminant() {
        return this.m_det.getLogDeterminant();
    }

    public int getObsCount() {
        return this.m_n;
    }

    public double getSsqErr() {
        return this.m_ssqerr;
    }

    public Likelihood evaluate() {
        return Likelihood.builder(this.m_n).logDeterminant(this.m_det.getLogDeterminant()).ssqErr(this.m_ssqerr).build();
    }
}

