/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.timeseries;

import java.util.function.ObjDoubleConsumer;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.Seq;
import jdplus.toolkit.base.api.timeseries.TimeSeriesDomain;
import jdplus.toolkit.base.api.timeseries.TimeSeriesInterval;
import jdplus.toolkit.base.api.timeseries.TimeSeriesObs;
import lombok.NonNull;

public interface TimeSeriesData<P extends TimeSeriesInterval<?>, O extends TimeSeriesObs<P>>
extends Seq<O> {
    @NonNull
    public TimeSeriesDomain<P> getDomain();

    @NonNull
    public DoubleSeq getValues();

    @Override
    default public int length() {
        return this.getValues().length();
    }

    @NonNull
    default public P getPeriod(int index) throws IndexOutOfBoundsException {
        return (P)((TimeSeriesInterval)this.getDomain().get(index));
    }

    default public double getValue(int index) throws IndexOutOfBoundsException {
        return this.getValues().get(index);
    }

    @Override
    default public void forEach(@NonNull ObjDoubleConsumer<P> consumer) {
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        for (int i = 0; i < this.length(); ++i) {
            consumer.accept(this.getPeriod(i), this.getValue(i));
        }
    }
}

