## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  eval = FALSE
)

## ----setup--------------------------------------------------------------------
# library(bracketeer)

## ----teams--------------------------------------------------------------------
# teams <- c(
#   "Argentina", "Australia", "Brazil",   "Croatia",
#   "England",   "France",   "Japan",     "Morocco",
#   "Netherlands", "Poland", "Portugal",  "Senegal",
#   "South Korea", "Spain",  "Switzerland", "United States"
# )
# 
# length(teams)

## ----define-------------------------------------------------------------------
# trn <- tournament(teams) |>
#   round_robin("groups", groups = 4) |>
#   single_elim("knockout", take = top_per_group(2))

## ----group-matches------------------------------------------------------------
# stage_status(trn)
# 
# group_ms <- matches(trn, "groups")
# nrow(group_ms)   # 4 groups × 6 matches = 24 matches
# head(group_ms)

## ----enter-results------------------------------------------------------------
# for (i in seq_len(nrow(group_ms))) {
#   trn <- trn |> result("groups", match = group_ms$id[i], score = c(1, 0))
# }

## ----post-advance-------------------------------------------------------------
# stage_status(trn)
# #   stage     status        complete  total  materialized
# #   groups    complete            24     24          TRUE
# #   knockout  active               0      8          TRUE
# 
# matches(trn, "knockout")  # 8 teams: 2 × 4 groups

## ----standings----------------------------------------------------------------
# standings(trn, "groups")

## ----knockout-----------------------------------------------------------------
# knockout_ms <- matches(trn, "knockout")
# 
# for (i in seq_len(nrow(knockout_ms))) {
#   trn <- trn |> result("knockout", match = knockout_ms$id[i], score = c(1, 0))
# }
# 
# winner(trn)
# rankings(trn)

## ----routing-log--------------------------------------------------------------
# routing_log(trn)

