/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.discrete;

import jdplus.toolkit.base.api.stats.ProbabilityType;
import jdplus.toolkit.base.core.discrete.ICumulativeDistributionFunction;
import jdplus.toolkit.base.core.dstats.Normal;

public class Probit
implements ICumulativeDistributionFunction {
    private static final Normal N = new Normal();
    private static final double SQRT2PI = 2.5066282746310007;

    @Override
    public double f(double x) {
        return N.getProbability(x, ProbabilityType.Lower);
    }

    @Override
    public double df(double x) {
        return Math.exp(-0.5 * x * x) / 2.5066282746310007;
    }

    @Override
    public double d2f(double x) {
        return -x / 2.5066282746310007 * Math.exp(-0.5 * x * x);
    }
}

