/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.linearfilters;

import internal.toolkit.base.core.math.linearfilters.SymmetricFilterAlgorithms;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.IntToDoubleFunction;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import jdplus.toolkit.base.api.math.Complex;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.linearfilters.BackFilter;
import jdplus.toolkit.base.core.math.linearfilters.IFiniteFilter;
import jdplus.toolkit.base.core.math.linearfilters.LinearFilterException;
import jdplus.toolkit.base.core.math.matrices.MatrixException;
import jdplus.toolkit.base.core.math.polynomials.Polynomial;
import lombok.NonNull;

public final class SymmetricFilter
implements IFiniteFilter {
    public static final SymmetricFilter ZERO = new SymmetricFilter(Polynomial.ZERO);
    public static final SymmetricFilter ONE = new SymmetricFilter(Polynomial.ONE);
    private final Polynomial polynomial;
    private static final AtomicReference<Decomposer> DEF_DECOMPOSER = new AtomicReference<Decomposer>(SymmetricFilterAlgorithms.decomposer(null));
    private static final AtomicReference<Factorizer> DEF_FACTORIZER = new AtomicReference<Factorizer>(SymmetricFilterAlgorithms.factorizer());

    public static SymmetricFilter add(double d, SymmetricFilter f) {
        return f.plus(d);
    }

    public static SymmetricFilter convolutionOf(IFiniteFilter f) {
        return SymmetricFilter.convolutionOf(f, 1.0);
    }

    public static SymmetricFilter convolutionOf(IFiniteFilter f, double scaling) {
        int i;
        double[] w = f.weightsToArray();
        double[] c = new double[w.length];
        for (i = 0; i < w.length; ++i) {
            for (int j = i; j < w.length; ++j) {
                int n = j - i;
                c[n] = c[n] + w[i] * w[j];
            }
        }
        if (scaling != 1.0) {
            i = 0;
            while (i < w.length) {
                int n = i++;
                c[n] = c[n] * scaling;
            }
        }
        return SymmetricFilter.ofInternal(c);
    }

    public static SymmetricFilter convolutionOf(Polynomial f, double a) {
        int i;
        double[] w = f.toArray();
        double[] c = new double[w.length];
        for (i = 0; i < w.length; ++i) {
            for (int j = i; j < w.length; ++j) {
                int n = j - i;
                c[n] = c[n] + w[i] * w[j];
            }
        }
        if (a != 1.0) {
            i = 0;
            while (i < w.length) {
                int n = i++;
                c[n] = c[n] * a;
            }
        }
        return SymmetricFilter.ofInternal(c);
    }

    public static SymmetricFilter of(DoubleSeq w) {
        int d = w.length() - 1;
        if (d % 2 != 0) {
            throw new LinearFilterException("lf_err_sfilter");
        }
        int n = d / 2;
        double[] wc = new double[n + 1];
        for (int i = 0; i <= n; ++i) {
            double x = w.get(n + i);
            if (Math.abs(x - w.get(n - i)) > Polynomial.getEpsilon()) {
                throw new LinearFilterException("lf_err_sfilter");
            }
            wc[i] = x;
        }
        return SymmetricFilter.ofInternal(wc);
    }

    public static SymmetricFilter multiply(double d, SymmetricFilter f) {
        return f.times(d);
    }

    public static SymmetricFilter subtract(double d, SymmetricFilter f) {
        Polynomial tmp = f.polynomial.negate().plus(d);
        return new SymmetricFilter(tmp);
    }

    public static SymmetricFilter ofInternal(double[] c) {
        if (c.length == 1) {
            if (c[0] == 1.0) {
                return ONE;
            }
            if (c[0] == 0.0) {
                return ZERO;
            }
        }
        return new SymmetricFilter(Polynomial.ofInternal(c));
    }

    public SymmetricFilter(Polynomial p) {
        this.polynomial = p;
    }

    public static void setDefaultDecomposer(@NonNull Decomposer decomposer) {
        if (decomposer == null) {
            throw new NullPointerException("decomposer is marked non-null but is null");
        }
        DEF_DECOMPOSER.set(decomposer);
    }

    public BackFilter decompose(BackFilter Q) throws MatrixException {
        return DEF_DECOMPOSER.get().decompose(this, Q);
    }

    @Override
    public void apply(DataBlock in, DataBlock out) {
        double[] pin = in.getStorage();
        int ub = this.getUpperBound();
        int istart = in.getStartPosition();
        int iinc = in.getIncrement();
        DoubleSeqCursor.OnMutable cursor = out.cursor();
        if (iinc == 1) {
            int imax = in.getEndPosition() - ub;
            for (int i = istart + ub; i < imax; ++i) {
                double s = pin[i] * this.polynomial.get(0);
                for (int k = 1; k <= ub; ++k) {
                    s += this.polynomial.get(k) * (pin[i - k] + pin[i + k]);
                }
                cursor.setAndNext(s);
            }
        } else {
            int imax = in.getEndPosition() - ub * iinc;
            for (int i = istart + ub * iinc; i != imax; i += iinc) {
                double s = pin[i] * this.polynomial.get(0);
                int k = 1;
                int l = iinc;
                while (k <= ub) {
                    s += this.polynomial.get(k) * (pin[i - l] + pin[i + l]);
                    ++k;
                    l += iinc;
                }
                cursor.setAndNext(s);
            }
        }
    }

    @Override
    public Complex frequencyResponse(double freq) {
        return Complex.cart((double)this.realFrequencyResponse(freq));
    }

    public double realFrequencyResponse(double freq) {
        double cos1;
        int idx = 0;
        double r = this.polynomial.get(idx++);
        if (idx >= this.polynomial.degree() + 1) {
            return r;
        }
        double cos0 = 1.0;
        double cos = cos1 = Math.cos(freq);
        while (true) {
            r += 2.0 * cos1 * this.polynomial.get(idx++);
            if (idx >= this.polynomial.degree() + 1) break;
            double tmp = 2.0 * cos * cos1 - cos0;
            cos0 = cos1;
            cos1 = tmp;
        }
        return r;
    }

    public Polynomial coefficientsAsPolynomial() {
        return this.polynomial;
    }

    @Override
    public int getLowerBound() {
        return -this.polynomial.degree();
    }

    @Override
    public int getUpperBound() {
        return this.polynomial.degree();
    }

    @Override
    public IntToDoubleFunction weights() {
        return pos -> pos < 0 ? this.polynomial.get(-pos) : this.polynomial.get(pos);
    }

    @Override
    public SymmetricFilter mirror() {
        return this;
    }

    public boolean isNull() {
        return this.polynomial.isZero();
    }

    public SymmetricFilter minus(double d) {
        return new SymmetricFilter(this.polynomial.minus(d));
    }

    public SymmetricFilter minus(SymmetricFilter r, boolean simplify) {
        return new SymmetricFilter(this.polynomial.minus(r.polynomial, simplify));
    }

    public SymmetricFilter minus(SymmetricFilter r) {
        return new SymmetricFilter(this.polynomial.minus(r.polynomial, this.polynomial.degree() == r.polynomial.degree()));
    }

    public SymmetricFilter normalize() {
        double s = this.polynomial.get(0);
        for (int i = 1; i <= this.polynomial.degree(); ++i) {
            s += 2.0 * this.polynomial.get(i);
        }
        if (s != 0.0 && s != 1.0) {
            return new SymmetricFilter(this.polynomial.times(1.0 / s));
        }
        return this;
    }

    public SymmetricFilter plus(double d) {
        return new SymmetricFilter(this.polynomial.plus(d));
    }

    public SymmetricFilter plus(SymmetricFilter r) {
        return new SymmetricFilter(this.polynomial.plus(r.polynomial));
    }

    public SymmetricFilter times(double d) {
        return new SymmetricFilter(this.polynomial.times(d));
    }

    public SymmetricFilter times(SymmetricFilter r) {
        int u;
        int ll = this.polynomial.degree();
        int lr = r.polynomial.degree();
        double[] o = new double[ll + lr + 1];
        if (r.polynomial.get(0) != 0.0) {
            for (u = 0; u <= ll; ++u) {
                int n = u;
                o[n] = o[n] + this.polynomial.get(u) * r.polynomial.get(0);
            }
        }
        if (this.polynomial.get(0) != 0.0) {
            for (int v = 1; v <= lr; ++v) {
                int n = v;
                o[n] = o[n] + r.polynomial.get(v) * this.polynomial.get(0);
            }
        }
        for (u = 1; u <= ll; ++u) {
            if (this.polynomial.get(u) == 0.0) continue;
            for (int v = 1; v <= lr; ++v) {
                if (r.polynomial.get(v) == 0.0) continue;
                double x = this.polynomial.get(u) * r.polynomial.get(v);
                int n = u + v;
                o[n] = o[n] + x;
                if (u > v) {
                    int n2 = u - v;
                    o[n2] = o[n2] + x;
                    continue;
                }
                if (u < v) {
                    int n3 = v - u;
                    o[n3] = o[n3] + x;
                    continue;
                }
                o[0] = o[0] + 2.0 * x;
            }
        }
        return SymmetricFilter.ofInternal(o);
    }

    public static void setDefaultFactorizer(@NonNull Factorizer factorizer) {
        if (factorizer == null) {
            throw new NullPointerException("factorizer is marked non-null but is null");
        }
        DEF_FACTORIZER.set(factorizer);
    }

    public Factorization factorize() {
        if (this.polynomial.degree() == 0) {
            return new Factorization(BackFilter.ONE, this.polynomial.get(0));
        }
        return DEF_FACTORIZER.get().factorize(this);
    }

    public String toString() {
        return IFiniteFilter.toString(this);
    }

    @FunctionalInterface
    public static interface Decomposer {
        public BackFilter decompose(SymmetricFilter var1, BackFilter var2) throws MatrixException;
    }

    public static class Factorization {
        public final BackFilter factor;
        public final double scaling;

        public Factorization(BackFilter factor, double scaling) {
            this.factor = factor;
            this.scaling = scaling;
        }
    }

    @FunctionalInterface
    public static interface Factorizer {
        public Factorization factorize(SymmetricFilter var1);
    }
}

