/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.matrices.decomposition;

import jdplus.toolkit.base.api.math.Constants;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.LowerTriangularMatrix;
import jdplus.toolkit.base.core.math.matrices.MatrixException;

public class CholeskyWithPivoting {
    private FastMatrix M;
    private int[] piv;
    private int rank;
    private int pvt;
    private double ajj;
    private double tol;

    public boolean decompose(FastMatrix S, double tol) {
        this.initialize(S, tol);
        int n = this.M.getColumnsCount();
        double[] pm = this.M.getStorage();
        double[] v = new double[n];
        double[] w = new double[n];
        for (int j = 0; j < n; ++j) {
            double tmp;
            int k;
            for (int i = j; i < n; ++i) {
                if (j > 0) {
                    double mij = this.M.get(i, j - 1);
                    int n2 = i;
                    v[n2] = v[n2] + mij * mij;
                }
                w[i] = this.M.get(i, i) - v[i];
            }
            if (j > 0) {
                this.ajj = w[j];
                this.pvt = j;
                for (k = j + 1; k < n; ++k) {
                    if (!(w[k] > this.ajj)) continue;
                    this.ajj = w[k];
                    this.pvt = k;
                }
                if (this.ajj < tol) {
                    this.M.set(j, j, this.ajj);
                    this.rank = j;
                    return false;
                }
            }
            if (this.pvt != j) {
                this.M.set(this.pvt, this.pvt, this.M.get(j, j));
                for (k = 0; k < j; ++k) {
                    tmp = this.M.get(j, k);
                    this.M.set(j, k, this.M.get(this.pvt, k));
                    this.M.set(this.pvt, k, tmp);
                }
                for (k = this.pvt + 1; k < n; ++k) {
                    tmp = this.M.get(k, j);
                    this.M.set(k, j, this.M.get(k, this.pvt));
                    this.M.set(k, this.pvt, tmp);
                }
                for (k = j + 1; k < this.pvt; ++k) {
                    tmp = this.M.get(k, j);
                    this.M.set(k, j, this.M.get(this.pvt, k));
                    this.M.set(this.pvt, k, tmp);
                }
                double tmp2 = v[this.pvt];
                v[this.pvt] = v[j];
                v[j] = tmp2;
                int itmp = this.piv[this.pvt];
                this.piv[this.pvt] = this.piv[j];
                this.piv[j] = itmp;
            }
            this.ajj = Math.sqrt(this.ajj);
            this.M.set(j, j, this.ajj);
            for (int k2 = 0; k2 < j; ++k2) {
                tmp = this.M.get(j, k2);
                if (tmp == 0.0) continue;
                for (int l = j + 1; l < n; ++l) {
                    this.M.add(l, j, -tmp * this.M.get(l, k2));
                }
            }
            double scale = 1.0 / this.ajj;
            for (int l = j + 1; l < n; ++l) {
                this.M.mul(l, j, scale);
            }
        }
        this.rank = n;
        return true;
    }

    private boolean initialize(FastMatrix S, double eps) {
        int n = S.getColumnsCount();
        if (S.getRowsCount() != n) {
            throw new MatrixException("m_err_square");
        }
        this.M = S.deepClone();
        this.piv = new int[n];
        double[] pm = this.M.getStorage();
        this.pvt = 0;
        this.ajj = pm[0];
        int i = 1;
        int j = n + 1;
        while (i < n) {
            this.piv[i] = i;
            double d = pm[j];
            if (d > this.ajj) {
                this.pvt = i;
                this.ajj = d;
            }
            ++i;
            j += n + 1;
        }
        if (this.ajj <= 0.0) {
            this.rank = 0;
            return false;
        }
        this.tol = this.tol < 0.0 ? this.ajj * Constants.getEpsilon() * (double)n : eps;
        return true;
    }

    public int[] getPivot() {
        return this.piv;
    }

    public int getRank() {
        return this.rank;
    }

    public FastMatrix getL() {
        LowerTriangularMatrix.toLower(this.M);
        return this.M;
    }
}

