/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.regsarima.ami;

import java.util.ArrayList;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.arima.estimation.IArimaMapping;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.modelling.regression.IOutlierFactory;
import jdplus.toolkit.base.core.regarima.IRegArimaComputer;
import jdplus.toolkit.base.core.regarima.RegArimaEstimation;
import jdplus.toolkit.base.core.regarima.RegArimaModel;
import jdplus.toolkit.base.core.regarima.ami.GenericOutliersDetection;
import jdplus.toolkit.base.core.regarima.outlier.SingleOutlierDetector;
import jdplus.toolkit.base.core.sarima.SarimaModel;

public class ExactOutliersDetector
implements GenericOutliersDetection<SarimaModel> {
    static int DEF_MAXROUND = 100;
    static int DEF_MAXOUTLIERS = 50;
    static final double EPS = 1.0E-5;
    private final int maxRound;
    private final int maxOutliers;
    private RegArimaModel<SarimaModel> regarima;
    private final ArrayList<int[]> outliers = new ArrayList();
    private final SingleOutlierDetector sod;
    private final IRegArimaComputer<SarimaModel> processor;
    private final double cv;
    private double[] tstats;
    private int round;
    private boolean changed;

    public static Builder builder() {
        return new Builder();
    }

    private ExactOutliersDetector(SingleOutlierDetector sod, double cv, IRegArimaComputer<SarimaModel> processor, int maxOutliers, int maxRound) {
        this.sod = sod;
        this.cv = cv;
        this.processor = processor;
        this.maxOutliers = maxOutliers;
        this.maxRound = maxRound;
    }

    @Override
    public boolean process(RegArimaModel<SarimaModel> initialModel, IArimaMapping<SarimaModel> mapping) {
        this.changed = false;
        this.regarima = initialModel;
        this.estimateModel(mapping, true);
        this.execute(mapping);
        return this.changed;
    }

    @Override
    public void prepare(int n) {
        this.sod.prepare(n);
    }

    @Override
    public void setBounds(int start, int end) {
        this.sod.setBounds(start, end);
    }

    @Override
    public void exclude(int pos, int type) {
        this.sod.exclude(pos, type);
    }

    public void exclude(int pos) {
        int n = this.getOutlierFactoriesCount();
        for (int i = 0; i < n; ++i) {
            this.sod.exclude(pos, i);
        }
    }

    @Override
    public int[][] getOutliers() {
        return (int[][])this.outliers.toArray(x$0 -> new int[x$0][]);
    }

    public RegArimaModel<SarimaModel> getRegArima() {
        return this.regarima;
    }

    public IOutlierFactory getFactory(int i) {
        return this.sod.getOutlierFactory(i);
    }

    public String[] outlierTypes() {
        IOutlierFactory[] factories = this.sod.getOutliersFactories();
        String[] types = new String[factories.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = factories[i].getCode();
        }
        return types;
    }

    private void addNewOutlier(int pos, int type) {
        int[] o = new int[]{pos, type};
        this.outliers.add(o);
        double[] xo = new double[this.regarima.getObservationsCount()];
        DataBlock XO = DataBlock.of(xo);
        this.sod.getOutlierFactory(type).fill(pos, XO);
        this.regarima = this.regarima.toBuilder().addX((DoubleSeq)XO).build();
        this.sod.exclude(pos, type);
        this.changed = true;
    }

    public void addOutlier(int pos, int type) {
        int[] o = new int[]{pos, type};
        this.outliers.add(o);
        this.sod.exclude(pos, type);
    }

    public void clear() {
        this.outliers.clear();
        this.regarima = null;
    }

    private void execute(IArimaMapping<SarimaModel> mapping) {
        double max;
        this.round = 0;
        while (this.sod.process(this.regarima) && Math.abs(max = this.sod.getMaxTStat()) > this.cv) {
            ++this.round;
            int type = this.sod.getMaxOutlierType();
            int pos = this.sod.getMaxOutlierPosition();
            this.addNewOutlier(pos, type);
            if (!this.estimateModel(mapping, true)) {
                this.removeOutlier(this.outliers.size() - 1);
                this.estimateModel(mapping, false);
                break;
            }
            if (this.round < this.maxRound && this.outliers.size() < this.maxOutliers) continue;
        }
        while (!this.verifymodel() && this.estimateModel(mapping, false)) {
        }
    }

    public double getCritivalValue() {
        return this.cv;
    }

    public int getMaxIter() {
        return this.maxRound;
    }

    public RegArimaModel<SarimaModel> getModel() {
        return this.regarima;
    }

    public int getOutlierFactoriesCount() {
        return this.sod.getOutlierFactoriesCount();
    }

    public int getOutliersCount() {
        return this.outliers.size();
    }

    private boolean estimateModel(IArimaMapping<SarimaModel> mapping, boolean full) {
        RegArimaEstimation<SarimaModel> estimation;
        RegArimaEstimation<SarimaModel> regArimaEstimation = estimation = full ? this.processor.process(this.regarima, mapping) : this.processor.optimize(this.regarima, mapping);
        if (estimation == null) {
            return false;
        }
        this.regarima = estimation.getModel();
        this.tstats = estimation.getConcentratedLikelihood().tstats(0, false);
        return true;
    }

    public boolean isInitialized() {
        return this.regarima != null;
    }

    private void removeOutlier(int idx) {
        int opos = this.regarima.getXCount() - this.outliers.size() + idx;
        this.regarima = this.regarima.toBuilder().removeX(opos).build();
        this.outliers.remove(idx);
        this.changed = true;
    }

    private boolean verifymodel() {
        if (this.regarima == null) {
            return true;
        }
        if (this.outliers.isEmpty()) {
            return true;
        }
        int nx0 = this.regarima.getVariablesCount() - this.outliers.size();
        int imin = 0;
        for (int i = 1; i < this.outliers.size(); ++i) {
            if (!(Math.abs(this.tstats[i + nx0]) < Math.abs(this.tstats[imin + nx0]))) continue;
            imin = i;
        }
        if (Math.abs(this.tstats[nx0 + imin]) >= this.cv) {
            return true;
        }
        int[] toremove = this.outliers.get(imin);
        this.sod.allow(toremove[0], toremove[1]);
        this.removeOutlier(imin);
        return false;
    }

    public static class Builder {
        private double cv;
        private IRegArimaComputer<SarimaModel> processor;
        private int maxOutliers = DEF_MAXOUTLIERS;
        private int maxRound = DEF_MAXROUND;
        private SingleOutlierDetector<SarimaModel> sod;

        private Builder() {
        }

        public Builder singleOutlierDetector(SingleOutlierDetector<SarimaModel> sod) {
            this.sod = sod;
            return this;
        }

        public Builder criticalValue(double cv) {
            this.cv = cv;
            return this;
        }

        public Builder processor(IRegArimaComputer<SarimaModel> processor) {
            this.processor = processor;
            return this;
        }

        public Builder maxOutliers(int max) {
            this.maxOutliers = max;
            return this;
        }

        public Builder maxRound(int max) {
            this.maxRound = max;
            return this;
        }

        public ExactOutliersDetector build() {
            return new ExactOutliersDetector(this.sod, this.cv, this.processor, this.maxRound, this.maxOutliers);
        }
    }
}

