/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.regsarima.regular;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import jdplus.toolkit.base.api.timeseries.calendars.LengthOfPeriodType;
import jdplus.toolkit.base.api.timeseries.regression.ITsVariable;
import jdplus.toolkit.base.api.timeseries.regression.ModellingUtility;
import jdplus.toolkit.base.api.timeseries.regression.Variable;
import jdplus.toolkit.base.core.regarima.DerivedRegressionTest;
import jdplus.toolkit.base.core.regarima.FRegressionTest;
import jdplus.toolkit.base.core.regsarima.regular.IRegressionTest;
import jdplus.toolkit.base.core.regsarima.regular.ModelDescription;
import jdplus.toolkit.base.core.regsarima.regular.ProcessingResult;
import jdplus.toolkit.base.core.regsarima.regular.RegSarimaModelling;
import jdplus.toolkit.base.core.regsarima.regular.TRegressionTest;
import jdplus.toolkit.base.core.stats.likelihood.ConcentratedLikelihoodWithMissing;

public class RegressionVariablesTest {
    public static final double CVAL = 1.96;
    public static final double F_PROB = 0.05;
    public static final double TSIG = 1.0;
    private final IRegressionTest meanTest;
    private final IRegressionTest tdTest;
    private final IRegressionTest mhTest;
    private final DerivedRegressionTest derivedTest;

    public static Builder builder() {
        return new Builder();
    }

    private RegressionVariablesTest(Builder builder) {
        this.meanTest = builder.tmu > 0.0 ? new TRegressionTest(builder.tmu) : null;
        this.mhTest = builder.tmh > 0.0 ? new TRegressionTest(builder.tmh) : null;
        if (builder.ttd > 0.0) {
            this.tdTest = new TRegressionTest(builder.ttd);
            this.derivedTest = builder.derived ? new DerivedRegressionTest(builder.ttd, true) : null;
        } else {
            this.derivedTest = null;
            this.tdTest = builder.ftd > 0.0 ? new FRegressionTest(builder.ftd) : null;
        }
    }

    public ProcessingResult process(RegSarimaModelling context) {
        int pos;
        ConcentratedLikelihoodWithMissing ll = context.getEstimation().getConcentratedLikelihood();
        ModelDescription desc = context.getDescription();
        boolean changed = false;
        ArrayList<ITsVariable> tdtoremove = new ArrayList<ITsVariable>();
        boolean usetd = false;
        boolean uselp = false;
        if (this.tdTest != null) {
            List ltd = desc.variables().filter(v -> ModellingUtility.isTradingDays((Variable)v)).collect(Collectors.toList());
            for (Variable cur : ltd) {
                int nregs;
                ITsVariable var = cur.getCore();
                int pos2 = desc.findPosition(var);
                if (!(this.tdTest.accept(ll, -1, pos2, nregs = var.dim()) || nregs > 1 && this.derivedTest != null && this.derivedTest.accept(ll, -1, pos2, nregs))) {
                    tdtoremove.add(var);
                    continue;
                }
                usetd = true;
            }
            List llp = desc.variables().filter(v -> ModellingUtility.isLengthOfPeriod((Variable)v)).collect(Collectors.toList());
            for (Variable cur : llp) {
                ITsVariable var = cur.getCore();
                pos = desc.findPosition(var);
                if (!this.tdTest.accept(ll, -1, pos, 1)) {
                    tdtoremove.add(var);
                    continue;
                }
                uselp = true;
            }
        }
        if (this.mhTest != null) {
            ArrayList<ITsVariable> mhtoremove = new ArrayList<ITsVariable>();
            List lmh = desc.variables().filter(v -> ModellingUtility.isMovingHoliday((Variable)v)).collect(Collectors.toList());
            for (Variable cur : lmh) {
                ITsVariable var = cur.getCore();
                pos = desc.findPosition(var);
                if (this.mhTest.accept(ll, -1, pos, 1)) continue;
                mhtoremove.add(var);
                changed = true;
            }
            for (ITsVariable var : mhtoremove) {
                desc.remove(var);
            }
        }
        if (!(tdtoremove.isEmpty() || uselp || usetd)) {
            changed = true;
            for (ITsVariable var : tdtoremove) {
                desc.remove(var);
            }
            if (desc.isAdjusted()) {
                desc.setPreadjustment(LengthOfPeriodType.None);
            }
        }
        if (this.meanTest != null && desc.isMean() && !this.meanTest.accept(ll, -1, 0, 1)) {
            desc.setMean(false);
            changed = true;
        }
        if (changed) {
            context.clearEstimation();
            return ProcessingResult.Changed;
        }
        return ProcessingResult.Unchanged;
    }

    public static class Builder {
        private double ftd = 0.0;
        private double tmu = 0.0;
        private double ttd = 0.0;
        private double tmh = 0.0;
        private boolean derived;

        public Builder meanTest(double t) {
            this.tmu = t;
            return this;
        }

        public Builder movingHolidaysTest(double t) {
            this.tmh = t;
            return this;
        }

        public Builder tdTest(double t, boolean derived) {
            this.ttd = t;
            this.derived = derived;
            this.ftd = 0.0;
            return this;
        }

        public Builder tdJointTest(double fprob) {
            this.ttd = 0.0;
            this.ftd = fprob;
            return this;
        }

        public RegressionVariablesTest build() {
            return new RegressionVariablesTest(this);
        }
    }
}

