/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.regsarima.regular;

import java.util.Arrays;
import jdplus.toolkit.base.api.arima.SarimaOrders;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import jdplus.toolkit.base.api.data.Parameter;
import jdplus.toolkit.base.api.data.ParameterType;
import jdplus.toolkit.base.core.arima.estimation.IArimaMapping;
import jdplus.toolkit.base.core.math.linearfilters.BackFilter;
import jdplus.toolkit.base.core.math.polynomials.UnitRoots;
import jdplus.toolkit.base.core.sarima.SarimaModel;
import jdplus.toolkit.base.core.sarima.estimation.SarimaFixedMapping;
import jdplus.toolkit.base.core.sarima.estimation.SarimaMapping;

public class SarimaComponent {
    private int d;
    private int bd;
    private int period;
    private Parameter[] phi;
    private Parameter[] theta;
    private Parameter[] bphi;
    private Parameter[] btheta;

    public SarimaComponent() {
    }

    public SarimaComponent(int freq) {
        this.period = freq;
    }

    public void copy(SarimaComponent other) {
        this.d = other.d;
        this.bd = other.bd;
        this.period = other.period;
        this.phi = other.phi == null ? null : (Parameter[])other.phi.clone();
        this.bphi = other.bphi == null ? null : (Parameter[])other.bphi.clone();
        this.theta = other.theta == null ? null : (Parameter[])other.theta.clone();
        this.btheta = other.btheta == null ? null : (Parameter[])other.btheta.clone();
    }

    public void setParameterType(ParameterType type) {
        int i;
        if (this.phi != null) {
            for (i = 0; i < this.phi.length; ++i) {
                this.phi[i] = this.phi[i].withType(type);
            }
        }
        if (this.bphi != null) {
            for (i = 0; i < this.bphi.length; ++i) {
                this.bphi[i] = this.bphi[i].withType(type);
            }
        }
        if (this.theta != null) {
            for (i = 0; i < this.theta.length; ++i) {
                this.theta[i] = this.theta[i].withType(type);
            }
        }
        if (this.btheta != null) {
            for (i = 0; i < this.btheta.length; ++i) {
                this.btheta[i] = this.btheta[i].withType(type);
            }
        }
    }

    public void clearParameters() {
        this.setParameterType(ParameterType.Undefined);
    }

    public void clearFreeParameters() {
        int i;
        if (this.phi != null) {
            for (i = 0; i < this.phi.length; ++i) {
                if (this.phi[i] != null && this.phi[i].isFixed()) continue;
                this.phi[i] = Parameter.undefined();
            }
        }
        if (this.bphi != null) {
            for (i = 0; i < this.bphi.length; ++i) {
                if (this.bphi[i] != null && this.bphi[i].isFixed()) continue;
                this.bphi[i] = Parameter.undefined();
            }
        }
        if (this.theta != null) {
            for (i = 0; i < this.theta.length; ++i) {
                if (this.theta[i] != null && this.theta[i].isFixed()) continue;
                this.theta[i] = Parameter.undefined();
            }
        }
        if (this.btheta != null) {
            for (i = 0; i < this.btheta.length; ++i) {
                if (this.btheta[i] != null && this.btheta[i].isFixed()) continue;
                this.btheta[i] = Parameter.undefined();
            }
        }
    }

    public void airline(int freq) {
        this.period = freq;
        this.setP(0);
        this.d = 1;
        this.setQ(1);
        this.setBp(0);
        this.bd = 1;
        this.setBq(1);
    }

    public int getP() {
        return this.phi == null ? 0 : this.phi.length;
    }

    public void setP(int value) {
        this.phi = Parameter.make((int)value);
    }

    public int getD() {
        return this.d;
    }

    public void setD(int value) {
        this.d = value;
    }

    public int getQ() {
        return this.theta == null ? 0 : this.theta.length;
    }

    public void setQ(int value) {
        this.theta = Parameter.make((int)value);
    }

    public int getS() {
        return this.period;
    }

    public void setS(int value) {
        this.period = value;
        if (this.period == 1) {
            this.bd = 0;
            this.bphi = null;
            this.btheta = null;
        }
    }

    public int getBp() {
        return this.bphi == null ? 0 : this.bphi.length;
    }

    public void setBp(int value) {
        this.bphi = Parameter.make((int)value);
    }

    public int getBd() {
        return this.bd;
    }

    public void setBd(int value) {
        this.bd = value;
    }

    public int getBq() {
        return this.btheta == null ? 0 : this.btheta.length;
    }

    public void setBq(int value) {
        this.btheta = Parameter.make((int)value);
    }

    public Parameter[] getPhi() {
        return this.phi;
    }

    public void setPhi(Parameter[] value) {
        this.phi = value == null ? null : (Parameter[])value.clone();
    }

    public Parameter[] getTheta() {
        return this.theta;
    }

    public void setTheta(Parameter[] value) {
        this.theta = value == null ? null : (Parameter[])value.clone();
    }

    public Parameter[] getBphi() {
        return this.bphi;
    }

    public void setBphi(Parameter[] value) {
        this.bphi = value == null ? null : (Parameter[])value.clone();
    }

    public Parameter[] getBtheta() {
        return this.btheta;
    }

    public void setBtheta(Parameter[] value) {
        this.btheta = value == null ? null : (Parameter[])value.clone();
    }

    public int getDifferencingOrder() {
        return this.d + this.bd * this.period;
    }

    public BackFilter getDifferencingFilter() {
        int i;
        UnitRoots ur = new UnitRoots();
        if (this.period > 1) {
            for (i = 0; i < this.bd; ++i) {
                ur.add(this.period);
            }
        }
        for (i = 0; i < this.d; ++i) {
            ur.add(1);
        }
        return new BackFilter(ur.asPolynomial());
    }

    public int getPeriod() {
        return this.period;
    }

    public void setPeriod(int freq) {
        this.period = freq;
        if (freq == 1) {
            this.bd = 0;
            this.bphi = null;
            this.btheta = null;
        }
    }

    public SarimaModel getModel() {
        int i;
        SarimaOrders spec = new SarimaOrders(this.period);
        spec.setP(this.getP());
        spec.setD(this.d);
        spec.setQ(this.getQ());
        spec.setBp(this.getBp());
        spec.setBd(this.bd);
        spec.setBq(this.getBq());
        SarimaModel.Builder builder = SarimaModel.builder(spec);
        Parameter[] p = this.phi;
        for (i = 0; i < spec.getP(); ++i) {
            if (p[i] != null && p[i].getType() != ParameterType.Undefined) {
                builder.phi(i + 1, p[i].getValue());
                continue;
            }
            builder.phi(i + 1, -0.2);
        }
        p = this.theta;
        for (i = 0; i < spec.getQ(); ++i) {
            if (p[i] != null && p[i].getType() != ParameterType.Undefined) {
                builder.theta(i + 1, p[i].getValue());
                continue;
            }
            builder.theta(i + 1, -0.1);
        }
        p = this.bphi;
        for (i = 0; i < spec.getBp(); ++i) {
            if (p[i] != null && p[i].getType() != ParameterType.Undefined) {
                builder.bphi(i + 1, p[i].getValue());
                continue;
            }
            builder.bphi(i + 1, -0.2);
        }
        p = this.btheta;
        for (i = 0; i < spec.getBq(); ++i) {
            if (p[i] != null && p[i].getType() != ParameterType.Undefined) {
                builder.btheta(i + 1, p[i].getValue());
                continue;
            }
            builder.btheta(i + 1, -0.1);
        }
        return builder.build();
    }

    public SarimaOrders specification() {
        SarimaOrders spec = new SarimaOrders(this.period);
        spec.setP(this.getP());
        spec.setD(this.d);
        spec.setQ(this.getQ());
        spec.setBp(this.getBp());
        spec.setBd(this.bd);
        spec.setBq(this.getBq());
        return spec;
    }

    public boolean isDefined() {
        return Parameter.isDefined((Parameter[])this.phi) && Parameter.isDefined((Parameter[])this.theta) && Parameter.isDefined((Parameter[])this.bphi) && Parameter.isDefined((Parameter[])this.btheta);
    }

    public boolean isUndefined() {
        return Parameter.isDefault((Parameter[])this.phi) && Parameter.isDefault((Parameter[])this.theta) && Parameter.isDefault((Parameter[])this.bphi) && Parameter.isDefault((Parameter[])this.btheta);
    }

    public void setSpecification(SarimaOrders spec) {
        this.setP(spec.getP());
        this.d = spec.getD();
        this.setQ(spec.getQ());
        this.setBp(spec.getBp());
        this.bd = spec.getBd();
        this.setBq(spec.getBq());
        this.period = spec.getPeriod();
    }

    public void setModel(SarimaModel value) {
        int i;
        SarimaOrders spec = value.orders();
        this.setP(spec.getP());
        this.d = spec.getD();
        this.setQ(spec.getQ());
        this.setBp(spec.getBp());
        this.bd = spec.getBd();
        this.setBq(spec.getBq());
        this.period = spec.getPeriod();
        Parameter[] p = this.phi;
        for (i = 0; i < spec.getP(); ++i) {
            p[i] = Parameter.estimated((double)value.phi(i + 1));
        }
        p = this.theta;
        for (i = 0; i < spec.getQ(); ++i) {
            p[i] = Parameter.estimated((double)value.theta(i + 1));
        }
        p = this.bphi;
        for (i = 0; i < spec.getBp(); ++i) {
            p[i] = Parameter.estimated((double)value.bphi(i + 1));
        }
        p = this.btheta;
        for (i = 0; i < spec.getBq(); ++i) {
            p[i] = Parameter.estimated((double)value.btheta(i + 1));
        }
    }

    public int getParametersCount() {
        return this.getP() + this.getBp() + this.getQ() + this.getBq();
    }

    public int getFreeParametersCount() {
        int n = Parameter.freeParametersCount((Parameter[])this.phi);
        n += Parameter.freeParametersCount((Parameter[])this.bphi);
        n += Parameter.freeParametersCount((Parameter[])this.theta);
        return n += Parameter.freeParametersCount((Parameter[])this.btheta);
    }

    public int getFixedParametersCount() {
        int n = Parameter.fixedParametersCount((Parameter[])this.phi);
        n += Parameter.fixedParametersCount((Parameter[])this.bphi);
        n += Parameter.fixedParametersCount((Parameter[])this.theta);
        return n += Parameter.fixedParametersCount((Parameter[])this.btheta);
    }

    public boolean[] fixedConstraints() {
        int i;
        int n = this.getParametersCount();
        boolean[] fixed = new boolean[n];
        int j = 0;
        if (this.phi != null) {
            i = 0;
            while (i < this.phi.length) {
                if (this.phi[i] != null && this.phi[i].getType() == ParameterType.Fixed) {
                    fixed[j] = true;
                }
                ++i;
                ++j;
            }
        }
        if (this.bphi != null) {
            i = 0;
            while (i < this.bphi.length) {
                if (this.bphi[i] != null && this.bphi[i].getType() == ParameterType.Fixed) {
                    fixed[j] = true;
                }
                ++i;
                ++j;
            }
        }
        if (this.theta != null) {
            i = 0;
            while (i < this.theta.length) {
                if (this.theta[i] != null && this.theta[i].getType() == ParameterType.Fixed) {
                    fixed[j] = true;
                }
                ++i;
                ++j;
            }
        }
        if (this.btheta != null) {
            i = 0;
            while (i < this.btheta.length) {
                if (this.btheta[i] != null && this.btheta[i].getType() == ParameterType.Fixed) {
                    fixed[j] = true;
                }
                ++i;
                ++j;
            }
        }
        return fixed;
    }

    public double[] parameters() {
        int i;
        int n = this.getParametersCount();
        double[] p = new double[n];
        int j = 0;
        if (this.phi != null) {
            i = 0;
            while (i < this.phi.length) {
                if (this.phi[i] != null) {
                    p[j] = this.phi[i].getValue();
                }
                ++i;
                ++j;
            }
        }
        if (this.bphi != null) {
            i = 0;
            while (i < this.bphi.length) {
                if (this.bphi[i] != null) {
                    p[j] = this.bphi[i].getValue();
                }
                ++i;
                ++j;
            }
        }
        if (this.theta != null) {
            i = 0;
            while (i < this.theta.length) {
                if (this.theta[i] != null) {
                    p[j] = this.theta[i].getValue();
                }
                ++i;
                ++j;
            }
        }
        if (this.btheta != null) {
            i = 0;
            while (i < this.btheta.length) {
                if (this.btheta[i] != null) {
                    p[j] = this.btheta[i].getValue();
                }
                ++i;
                ++j;
            }
        }
        return p;
    }

    public void setFreeParameters(DoubleSeq p) {
        int i;
        DoubleSeqCursor cursor = p.cursor();
        if (this.phi != null) {
            for (i = 0; i < this.phi.length; ++i) {
                if (this.phi[i].isFixed()) continue;
                this.phi[i] = Parameter.estimated((double)cursor.getAndNext());
            }
        }
        if (this.bphi != null) {
            for (i = 0; i < this.bphi.length; ++i) {
                if (this.bphi[i].isFixed()) continue;
                this.bphi[i] = Parameter.estimated((double)cursor.getAndNext());
            }
        }
        if (this.theta != null) {
            for (i = 0; i < this.theta.length; ++i) {
                if (this.theta[i].isFixed()) continue;
                this.theta[i] = Parameter.estimated((double)cursor.getAndNext());
            }
        }
        if (this.btheta != null) {
            for (i = 0; i < this.btheta.length; ++i) {
                if (this.btheta[i].isFixed()) continue;
                this.btheta[i] = Parameter.estimated((double)cursor.getAndNext());
            }
        }
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof SarimaComponent && this.equals((SarimaComponent)obj);
    }

    private boolean equals(SarimaComponent other) {
        return other.bd == this.bd && other.d == this.d && other.period == this.period && Arrays.deepEquals(this.phi, this.phi) && Arrays.deepEquals(this.bphi, this.bphi) && Arrays.deepEquals(this.theta, this.theta) && Arrays.deepEquals(this.btheta, this.btheta);
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + this.d;
        hash = 97 * hash + this.bd;
        hash = 97 * hash + this.period;
        hash = 97 * hash + Arrays.deepHashCode(this.phi);
        hash = 97 * hash + Arrays.deepHashCode(this.theta);
        hash = 97 * hash + Arrays.deepHashCode(this.bphi);
        hash = 97 * hash + Arrays.deepHashCode(this.btheta);
        return hash;
    }

    public IArimaMapping<SarimaModel> defaultMapping() {
        if (this.getFixedParametersCount() == 0) {
            return SarimaMapping.of(this.specification());
        }
        return new SarimaFixedMapping(this.specification(), DoubleSeq.of((double[])this.parameters()), this.fixedConstraints());
    }
}

