/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.akf;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.LogSign;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.LowerTriangularMatrix;
import jdplus.toolkit.base.core.math.matrices.decomposition.ElementaryTransformations;
import jdplus.toolkit.base.core.ssf.akf.AugmentedState;
import jdplus.toolkit.base.core.ssf.akf.AugmentedUpdateInformation;
import jdplus.toolkit.base.core.ssf.likelihood.DiffuseLikelihood;
import jdplus.toolkit.base.core.stats.likelihood.DeterminantalTerm;

public class QAugmentation {
    private FastMatrix Q;
    private FastMatrix B;
    private int n;
    private int nd;
    private final DeterminantalTerm det = new DeterminantalTerm();

    public void prepare(int nd, int nvars) {
        this.clear();
        this.nd = nd;
        this.Q = FastMatrix.make(nd + 1, nd + 1 + nvars);
    }

    public void clear() {
        this.n = 0;
        this.Q = null;
        this.det.clear();
    }

    public int getDegreesofFreedom() {
        return this.n - this.nd;
    }

    public void update(AugmentedUpdateInformation pe) {
        double v = pe.getVariance();
        if (v == 0.0) {
            return;
        }
        ++this.n;
        double e = pe.get();
        this.det.add(v);
        DataBlock col = this.Q.column(this.nd + 1);
        double se = Math.sqrt(v);
        col.range(0, this.nd).setAY(1.0 / se, pe.E());
        col.set(this.nd, e / se);
        ElementaryTransformations.fastGivensTriangularize(this.Q);
    }

    public FastMatrix a() {
        return this.Q.extract(0, this.nd, 0, this.nd);
    }

    public DataBlock b() {
        return this.Q.row(this.nd).range(0, this.nd);
    }

    public double c() {
        return this.Q.get(this.nd, this.nd);
    }

    public FastMatrix B() {
        return this.B;
    }

    public DiffuseLikelihood likelihood(boolean scalingfactor) {
        double cc = this.c();
        cc *= cc;
        LogSign dsl = LogSign.of((DoubleSeq)this.a().diagonal());
        double dcorr = 2.0 * dsl.getValue();
        return DiffuseLikelihood.builder(this.n, this.nd).ssqErr(cc).logDeterminant(this.det.getLogDeterminant()).diffuseCorrection(dcorr).concentratedScalingFactor(scalingfactor).build();
    }

    public boolean canCollapse() {
        return QAugmentation.isPositive(this.Q.diagonal().drop(0, 1));
    }

    public boolean collapse(AugmentedState state) {
        if (!QAugmentation.isPositive(this.Q.diagonal().drop(0, 1))) {
            return false;
        }
        this.B = state.B().deepClone();
        int d = this.B.getColumnsCount();
        FastMatrix S = this.a();
        LowerTriangularMatrix.solveXLt(S, this.B);
        for (int i = 0; i < d; ++i) {
            DataBlock col = this.B.column(i);
            state.a().addAY(-this.Q.get(d, i), col);
            state.P().addXaXt(1.0, col);
        }
        state.dropAllConstraints();
        return true;
    }

    public static boolean isPositive(DataBlock q) {
        for (int i = 0; i < q.length(); ++i) {
            if (!(q.get(i) < 1.0E-9)) continue;
            return false;
        }
        return true;
    }
}

