/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.information;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import jdplus.toolkit.base.api.information.BasicInformationExtractor;
import jdplus.toolkit.base.api.information.InformationExtractor;
import jdplus.toolkit.base.api.util.WildCards;
import lombok.NonNull;

public abstract class InformationMapping<S>
implements InformationExtractor<S> {
    private final LinkedHashMap<String, BasicInformationExtractor<S>> map = new LinkedHashMap();
    private final List<BasicInformationExtractor<S>> list = new ArrayList<BasicInformationExtractor<S>>();

    public <Q> void set(@NonNull String name, Class<Q> targetClass, Function<S, Q> fn) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.map.put(name, BasicInformationExtractor.extractor(name, targetClass, fn));
    }

    public <Q> void delegate(String name, Class<Q> target, Function<S, Q> fn) {
        this.list.add(BasicInformationExtractor.delegate(name, target, fn));
    }

    public <Q> void delegateArray(@NonNull String name, int start, int end, Class<Q> target, BiFunction<S, Integer, Q> fn) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.map.put(name, BasicInformationExtractor.delegateArray(name, start, end, target, fn));
    }

    public <Q> void setArray(@NonNull String name, int start, int end, Class<Q> targetClass, BiFunction<S, Integer, Q> fn) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.map.put(name, BasicInformationExtractor.array(name, start, end, targetClass, fn));
    }

    public <Q> void setArray(@NonNull String name, int defparam, Class<Q> targetClass, BiFunction<S, Integer, Q> fn) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.map.put(name, BasicInformationExtractor.array(name, defparam, targetClass, fn));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fillDictionary(String prefix, Map<String, Class> dic, boolean compact) {
        InformationMapping informationMapping = this;
        synchronized (informationMapping) {
            this.list.forEach(extractor -> extractor.fillDictionary(prefix, dic, compact));
            this.map.forEach((key, extractor) -> extractor.fillDictionary(prefix, dic, compact));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BasicInformationExtractor<S> search(String id) {
        InformationMapping informationMapping = this;
        synchronized (informationMapping) {
            BasicInformationExtractor<S> extractor = this.map.get(id);
            if (extractor != null) {
                return extractor;
            }
            Optional<Map.Entry> findFirst = this.map.entrySet().stream().filter(entry -> ((BasicInformationExtractor)entry.getValue()).contains(id)).findFirst();
            if (findFirst.isPresent()) {
                return (BasicInformationExtractor)findFirst.orElseThrow().getValue();
            }
            for (BasicInformationExtractor<S> l : this.list) {
                if (!l.contains(id)) continue;
                return l;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(String id) {
        InformationMapping informationMapping = this;
        synchronized (informationMapping) {
            BasicInformationExtractor<S> extractor = this.map.get(id);
            if (extractor != null) {
                return true;
            }
            boolean any = this.map.entrySet().stream().anyMatch(entry -> ((BasicInformationExtractor)entry.getValue()).contains(id));
            if (any) {
                return true;
            }
            return this.list.stream().anyMatch(l -> l.contains(id));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getData(S source, String id, Class<T> tclass) {
        InformationMapping informationMapping = this;
        synchronized (informationMapping) {
            T data;
            BasicInformationExtractor<S> extractor = this.map.get(id);
            if (extractor != null) {
                return extractor.getData(source, id, tclass);
            }
            for (Map.Entry<String, BasicInformationExtractor<S>> entry : this.map.entrySet()) {
                data = entry.getValue().getData(source, id, tclass);
                if (data == null) continue;
                return data;
            }
            for (BasicInformationExtractor basicInformationExtractor : this.list) {
                data = basicInformationExtractor.getData(source, id, tclass);
                if (data == null) continue;
                return data;
            }
            return null;
        }
    }

    @Override
    public <T> void searchAll(S source, WildCards wc, Class<T> tclass, Map<String, T> smap) {
        for (BasicInformationExtractor<S> basicInformationExtractor : this.list) {
            basicInformationExtractor.searchAll(source, wc, tclass, smap);
        }
        for (Map.Entry entry : this.map.entrySet()) {
            String key = (String)entry.getKey();
            String swc = wc.toString();
            if (!swc.startsWith(key)) continue;
            LinkedHashMap tmap = new LinkedHashMap();
            ((BasicInformationExtractor)entry.getValue()).searchAll(source, wc, tclass, tmap);
            if (tmap.isEmpty()) continue;
            for (Map.Entry tentry : tmap.entrySet()) {
                smap.put((String)tentry.getKey(), tentry.getValue());
            }
        }
    }
}

