/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.modelling;

import jdplus.toolkit.base.api.modelling.ComponentInformation;
import lombok.Generated;
import org.jspecify.annotations.Nullable;

public final class SeriesInfo
implements Comparable<SeriesInfo> {
    private final String name;
    public final ComponentInformation componentInformation;
    public final String description;
    public static final String F_SUFFIX = "_f";
    public static final String E_SUFFIX = "_e";
    public static final String EF_SUFFIX = "_ef";
    public static final String B_SUFFIX = "_b";
    public static final String EB_SUFFIX = "_eb";

    @Override
    public int compareTo(SeriesInfo o) {
        if (this == o) {
            return 0;
        }
        int cmp = this.name.compareTo(o.name);
        if (cmp != 0) {
            return cmp;
        }
        return this.componentInformation.compareTo(o.componentInformation);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.description != null && this.description.length() > 0) {
            builder.append(this.description);
        } else {
            builder.append(this.name);
        }
        if (this.componentInformation == ComponentInformation.Value || this.componentInformation == ComponentInformation.Undefined) {
            return builder.toString();
        }
        builder.append(" (");
        if (null != this.componentInformation) {
            switch (this.componentInformation) {
                case Forecast: {
                    builder.append("forecasts)");
                    break;
                }
                case Stdev: {
                    builder.append("std error)");
                    break;
                }
                case StdevForecast: {
                    builder.append("forecast errors)");
                    break;
                }
            }
        }
        return builder.toString();
    }

    public String getCode() {
        if (this.componentInformation == ComponentInformation.Undefined || this.componentInformation == ComponentInformation.Value) {
            return this.name;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(this.name);
        switch (this.componentInformation) {
            case Forecast: {
                builder.append(F_SUFFIX);
                break;
            }
            case Stdev: {
                builder.append(E_SUFFIX);
                break;
            }
            case StdevForecast: {
                builder.append(EF_SUFFIX);
            }
        }
        return builder.toString();
    }

    public static SeriesInfo split(String code) {
        int len = code.length();
        if (SeriesInfo.hasSuffix(code, F_SUFFIX)) {
            return new SeriesInfo(code.substring(0, len - 2), ComponentInformation.Forecast, null);
        }
        if (SeriesInfo.hasSuffix(code, E_SUFFIX)) {
            return new SeriesInfo(code.substring(0, len - 2), ComponentInformation.Stdev, null);
        }
        if (SeriesInfo.hasSuffix(code, EF_SUFFIX)) {
            return new SeriesInfo(code.substring(0, len - 3), ComponentInformation.StdevForecast, null);
        }
        return new SeriesInfo(code, ComponentInformation.Value, null);
    }

    private static boolean hasSuffix(String s, String suffix) {
        return s.endsWith(suffix);
    }

    @Generated
    public SeriesInfo(String name, ComponentInformation componentInformation, String description) {
        this.name = name;
        this.componentInformation = componentInformation;
        this.description = description;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public ComponentInformation getComponentInformation() {
        return this.componentInformation;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SeriesInfo)) {
            return false;
        }
        SeriesInfo other = (SeriesInfo)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        ComponentInformation this$componentInformation = this.getComponentInformation();
        ComponentInformation other$componentInformation = other.getComponentInformation();
        if (this$componentInformation == null ? other$componentInformation != null : !((Object)((Object)this$componentInformation)).equals((Object)other$componentInformation)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        ComponentInformation $componentInformation = this.getComponentInformation();
        result = result * 59 + ($componentInformation == null ? 43 : ((Object)((Object)$componentInformation)).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

