/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.timeseries;

import java.time.LocalDateTime;
import java.time.format.DateTimeParseException;
import java.util.Locale;
import jdplus.toolkit.base.api.time.ISO_8601;
import jdplus.toolkit.base.api.time.TimeRecurrenceAccessor;
import jdplus.toolkit.base.api.time.TimeRecurrenceFormatter;
import jdplus.toolkit.base.api.timeseries.TimeSelector;
import jdplus.toolkit.base.api.timeseries.TimeSeriesRecurrence;
import jdplus.toolkit.base.api.timeseries.TsException;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.api.timeseries.TsUnit;
import jdplus.toolkit.base.api.util.HasShortStringRepresentation;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

@ISO_8601
public final class TsDomain
implements TimeSeriesRecurrence<TsPeriod>,
HasShortStringRepresentation {
    public static final TsDomain DEFAULT_EMPTY = TsDomain.of(TsPeriod.of(TsUnit.P1Y, 0L), 0);
    @NonNull
    private final TsPeriod startPeriod;
    private final int length;
    private static final TimeRecurrenceFormatter ISO_8601 = TimeRecurrenceFormatter.of(TsPeriod.ISO_8601, TsPeriod::from);

    @NonNull
    public static TsDomain splitOf(TsPeriod period, TsUnit hUnit, boolean exact) throws TsException {
        LocalDateTime start = period.start();
        LocalDateTime end = period.end();
        long len = hUnit.getChronoUnit().between(start, end) / hUnit.getAmount();
        TsPeriod pstart = period.withUnit(hUnit);
        if (!exact || end.equals(pstart.plus(len).start())) {
            return TsDomain.of(pstart, (int)len);
        }
        throw new TsException("Incompatible frequencies");
    }

    @Override
    public int length() {
        return this.getLength();
    }

    @Override
    @NonNull
    public TsPeriod getInterval() {
        return this.startPeriod;
    }

    @Override
    public TsPeriod get(int index) throws IndexOutOfBoundsException {
        return this.startPeriod.plus(index);
    }

    public TsUnit getTsUnit() {
        return this.startPeriod.getUnit();
    }

    public int getAnnualFrequency() {
        return this.startPeriod.getUnit().getAnnualFrequency();
    }

    public TsPeriod getEndPeriod() {
        this.checkNonEmpty();
        return this.startPeriod.plus(this.length);
    }

    public TsPeriod getLastPeriod() {
        this.checkNonEmpty();
        return this.startPeriod.plus(this.length - 1);
    }

    @Override
    @NonNull
    public LocalDateTime start() {
        return this.startPeriod.start();
    }

    @Override
    @NonNull
    public LocalDateTime end() {
        this.checkNonEmpty();
        return this.startPeriod.dateAt(this.startPeriod.getId() + (long)this.length);
    }

    @Override
    public boolean contains(@NonNull LocalDateTime date) {
        if (date == null) {
            throw new NullPointerException("date is marked non-null but is null");
        }
        return this.contains(this.startPeriod.idAt(date));
    }

    @Override
    public boolean contains(TsPeriod period) {
        this.startPeriod.checkCompatibility(period);
        return this.contains(this.startPeriod.getRebasedId(period));
    }

    @Override
    public int indexOf(LocalDateTime date) {
        return this.indexOf(this.startPeriod.idAt(date));
    }

    @Override
    public int indexOf(TsPeriod period) {
        this.startPeriod.checkCompatibility(period);
        return this.indexOf(this.startPeriod.getRebasedId(period));
    }

    @Override
    public boolean contains(TsDomain other) {
        this.startPeriod.checkCompatibility(other.startPeriod);
        int index = this.indexOf(this.startPeriod.getRebasedId(other.startPeriod));
        return index != -1 && index + other.length <= this.length;
    }

    public int position(TsPeriod period) {
        this.startPeriod.checkCompatibility(period);
        return this.distance(this.startPeriod.getRebasedId(period));
    }

    public boolean hasDefaultEpoch() {
        return this.startPeriod.hasDefaultEpoch();
    }

    public TsDomain move(int count) {
        return count != 0 ? new TsDomain(this.startPeriod.plus(count), this.length) : this;
    }

    public TsDomain range(int startIndex, int endIndex) {
        if (endIndex < startIndex || startIndex < 0) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Invalid bounds: [%s, %s[", startIndex, endIndex));
        }
        if (this.isEmpty()) {
            return this;
        }
        return startIndex >= this.length ? new TsDomain(this.get(startIndex), 0) : new TsDomain(this.get(startIndex), Math.min(endIndex, this.length) - startIndex);
    }

    public TsDomain drop(int nstart, int nend) {
        if (this.isEmpty()) {
            return this;
        }
        int len = this.length() - nstart - nend;
        return new TsDomain(this.get(nstart), len < 0 ? 0 : len);
    }

    public TsDomain extend(int nstart, int nend) {
        int len = this.length() + nstart + nend;
        return new TsDomain(this.startPeriod.plus(-nstart), len < 0 ? 0 : len);
    }

    public TsDomain intersection(TsDomain other) {
        this.startPeriod.checkCompatibility(other.startPeriod);
        if (this.equals(other)) {
            return this;
        }
        if (this.isEmpty()) {
            return this;
        }
        int n1 = this.length();
        int n2 = other.length();
        long lbeg = this.startPeriod.getId();
        long rbeg = this.startPeriod.getRebasedId(other.startPeriod);
        long lend = lbeg + (long)n1;
        long rend = rbeg + (long)n2;
        long beg = lbeg <= rbeg ? rbeg : lbeg;
        long end = lend >= rend ? rend : lend;
        return new TsDomain(this.startPeriod.withId(beg), Math.max(0, TsDomain.distance(beg, end)));
    }

    public TsDomain union(TsDomain other) {
        this.startPeriod.checkCompatibility(other.startPeriod);
        if (this.equals(other)) {
            return this;
        }
        if (this.isEmpty()) {
            return other;
        }
        if (other.isEmpty()) {
            return this;
        }
        int ln = this.length();
        int rn = other.length();
        long lbeg = this.startPeriod.getId();
        long rbeg = this.startPeriod.getRebasedId(other.startPeriod);
        long lend = lbeg + (long)ln;
        long rend = rbeg + (long)rn;
        long beg = lbeg <= rbeg ? lbeg : rbeg;
        long end = lend >= rend ? lend : rend;
        return new TsDomain(this.startPeriod.withId(beg), TsDomain.distance(beg, end));
    }

    public TsDomain aggregate(@NonNull TsUnit newUnit, boolean complete) {
        if (newUnit == null) {
            throw new NullPointerException("newUnit is marked non-null but is null");
        }
        int ratio = this.getTsUnit().ratioOf(newUnit);
        switch (ratio) {
            case -1: 
            case 0: {
                throw new TsException("Incompatible frequencies");
            }
            case 1: {
                return this;
            }
        }
        if (this.isEmpty()) {
            return TsDomain.of(this.getStartPeriod().withUnit(newUnit), 0);
        }
        int oldLength = this.length();
        TsPeriod start = this.getStartPeriod();
        TsPeriod nstart = start.withUnit(newUnit);
        int spos = TsDomain.splitOf(nstart, start.getUnit(), false).indexOf(start);
        int head = spos > 0 ? ratio - spos : 0;
        int tail = (oldLength - head) % ratio;
        int nlength = (oldLength - head - tail) / ratio;
        if (head > 0) {
            if (complete) {
                nstart = nstart.next();
            } else {
                ++nlength;
            }
        }
        if (tail > 0 && !complete) {
            ++nlength;
        }
        return TsDomain.of(nstart, nlength);
    }

    public TsDomain aggregateByPosition(@NonNull TsUnit newUnit, int position) {
        if (newUnit == null) {
            throw new NullPointerException("newUnit is marked non-null but is null");
        }
        int ratio = this.getTsUnit().ratioOf(newUnit);
        switch (ratio) {
            case -1: 
            case 0: {
                throw new TsException("Incompatible frequencies");
            }
            case 1: {
                return this;
            }
        }
        if (position < 0 || position >= ratio) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return TsDomain.of(this.getStartPeriod().withUnit(newUnit), 0);
        }
        int oldLength = this.length();
        TsPeriod start = this.getStartPeriod();
        TsPeriod nstart = start.withUnit(newUnit);
        int spos = TsDomain.splitOf(nstart, start.getUnit(), false).indexOf(start);
        int head = position - spos;
        if (head < 0) {
            head += ratio;
            nstart = nstart.next();
        }
        int nlength = 1 + (oldLength - head - 1) / ratio;
        return TsDomain.of(nstart, nlength);
    }

    public TsDomain select(TimeSelector ps) {
        if (this.isEmpty()) {
            return this;
        }
        switch (ps.getType()) {
            case All: {
                return this;
            }
            case None: {
                return this.range(0, 0);
            }
            case First: {
                return this.range(0, ps.getN0());
            }
            case Last: {
                return this.range(Math.max(0, this.length - ps.getN1()), this.length);
            }
            case Excluding: {
                return ps.getN0() <= this.length - ps.getN1() ? this.range(ps.getN0(), this.length - ps.getN1()) : this.range(0, 0);
            }
            case From: {
                long fromId = this.startPeriod.idAt(ps.getD0());
                return this.range(Math.max(0, this.distance(fromId)), Integer.MAX_VALUE);
            }
            case To: {
                long toId = this.startPeriod.idAt(ps.getD1());
                return this.range(0, Math.max(0, this.distance(toId)));
            }
            case Between: {
                long fromId = this.startPeriod.idAt(ps.getD0());
                long toId = this.startPeriod.idAt(ps.getD1());
                return this.range(Math.max(0, this.distance(fromId)), Math.max(0, this.distance(toId)));
            }
        }
        throw new RuntimeException();
    }

    @Override
    private boolean contains(long id) {
        return this.startPeriod.getId() <= id && id < this.startPeriod.getId() + (long)this.length;
    }

    @Override
    private int indexOf(long id) {
        int index = this.distance(id);
        return this.length == 0 || index < 0 ? -1 : (index < this.length ? index : -this.length);
    }

    private void checkNonEmpty() throws IllegalStateException {
        if (this.length == 0) {
            throw new IllegalStateException();
        }
    }

    private int distance(long endId) {
        return TsDomain.distance(this.startPeriod.getId(), endId);
    }

    private static int distance(long startId, long endId) {
        return (int)(endId - startId);
    }

    public String toString() {
        return ISO_8601.format(this);
    }

    @Override
    @NonNull
    public String toShortString() {
        return ISO_8601.format(this, this.getTsUnit().getPrecision());
    }

    @NonNull
    public static TsDomain parse(@NonNull CharSequence text) throws DateTimeParseException {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        return ISO_8601.parse(text, TsDomain::from);
    }

    @NonNull
    public static TsDomain from(@NonNull TimeRecurrenceAccessor timeRecurrence) {
        if (timeRecurrence == null) {
            throw new NullPointerException("timeRecurrence is marked non-null but is null");
        }
        return TsDomain.of(TsPeriod.from(timeRecurrence.getInterval()), timeRecurrence.length());
    }

    @Generated
    private TsDomain(@NonNull TsPeriod startPeriod, int length) {
        if (startPeriod == null) {
            throw new NullPointerException("startPeriod is marked non-null but is null");
        }
        this.startPeriod = startPeriod;
        this.length = length;
    }

    @Generated
    public static @org.jspecify.annotations.NonNull TsDomain of(@NonNull TsPeriod startPeriod, int length) {
        if (startPeriod == null) {
            throw new NullPointerException("startPeriod is marked non-null but is null");
        }
        return new TsDomain(startPeriod, length);
    }

    @NonNull
    @Generated
    public TsPeriod getStartPeriod() {
        return this.startPeriod;
    }

    @Generated
    public int getLength() {
        return this.length;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TsDomain)) {
            return false;
        }
        TsDomain other = (TsDomain)o;
        if (this.getLength() != other.getLength()) {
            return false;
        }
        TsPeriod this$startPeriod = this.getStartPeriod();
        TsPeriod other$startPeriod = other.getStartPeriod();
        return !(this$startPeriod == null ? other$startPeriod != null : !((Object)this$startPeriod).equals(other$startPeriod));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLength();
        TsPeriod $startPeriod = this.getStartPeriod();
        result = result * 59 + ($startPeriod == null ? 43 : ((Object)$startPeriod).hashCode());
        return result;
    }
}

