/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.timeseries.calendars;

import java.time.DayOfWeek;
import java.time.LocalDate;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.api.timeseries.ValidityPeriod;
import jdplus.toolkit.base.api.timeseries.calendars.Holiday;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class FixedWeekDay
implements Holiday {
    private final int month;
    private final int place;
    private final DayOfWeek dayOfWeek;
    private final double weight;
    private final ValidityPeriod validityPeriod;
    public static final FixedWeekDay LABORDAY = new FixedWeekDay(9, 1, DayOfWeek.MONDAY);
    public static final FixedWeekDay THANKSGIVING = new FixedWeekDay(11, 4, DayOfWeek.THURSDAY);
    public static final FixedWeekDay BLACKFRIDAY = new FixedWeekDay(11, 4, DayOfWeek.FRIDAY);

    public FixedWeekDay(int month, int place, DayOfWeek day) {
        this(month, place, day, 1.0, ValidityPeriod.ALWAYS);
    }

    public FixedWeekDay(int month, int place, DayOfWeek day, double weight, ValidityPeriod validityPeriod) {
        this.place = place;
        this.month = month;
        this.dayOfWeek = day;
        this.weight = weight;
        this.validityPeriod = validityPeriod;
    }

    @Override
    public FixedWeekDay reweight(double nweight) {
        if (this.weight == this.weight) {
            return this;
        }
        return new FixedWeekDay(this.month, this.place, this.dayOfWeek, nweight, this.validityPeriod);
    }

    @Override
    public FixedWeekDay forPeriod(LocalDate start, LocalDate end) {
        if (this.validityPeriod.getStart().equals(start) && this.validityPeriod.getEnd().equals(end)) {
            return this;
        }
        return new FixedWeekDay(this.month, this.place, this.dayOfWeek, this.weight, ValidityPeriod.between(start, end));
    }

    public static LocalDate firstWeekDate(DayOfWeek day, int year, int month) {
        TsPeriod m = TsPeriod.monthly(year, month);
        LocalDate start = m.start().toLocalDate();
        DayOfWeek dow = start.getDayOfWeek();
        int istart = dow.getValue();
        int n = day.getValue() - istart;
        if (n < 0) {
            n += 7;
        }
        if (n != 0) {
            start = start.plusDays(n);
        }
        return start;
    }

    public static LocalDate lastWeekDate(DayOfWeek day, int year, int month) {
        TsPeriod m = TsPeriod.monthly(year, month);
        LocalDate end = m.end().toLocalDate();
        DayOfWeek dow = end.getDayOfWeek();
        int istart = dow.getValue();
        int n = day.getValue() - istart;
        if (n >= 0) {
            n -= 7;
        }
        if (n != 0) {
            end = end.plusDays(n);
        }
        return end;
    }

    public LocalDate calcDate(int year) {
        if (this.place < 0) {
            return FixedWeekDay.lastWeekDate(this.dayOfWeek, year, this.month);
        }
        LocalDate d = FixedWeekDay.firstWeekDate(this.dayOfWeek, year, this.month);
        if (this.place > 1) {
            d = d.plusDays((this.place - 1) * 7);
        }
        return d;
    }

    @Override
    public String display() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.place).append('-').append(this.dayOfWeek).append('-').append(this.month);
        return builder.toString();
    }

    @Generated
    public int getMonth() {
        return this.month;
    }

    @Generated
    public int getPlace() {
        return this.place;
    }

    @Generated
    public DayOfWeek getDayOfWeek() {
        return this.dayOfWeek;
    }

    @Override
    @Generated
    public double getWeight() {
        return this.weight;
    }

    @Override
    @Generated
    public ValidityPeriod getValidityPeriod() {
        return this.validityPeriod;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FixedWeekDay)) {
            return false;
        }
        FixedWeekDay other = (FixedWeekDay)o;
        if (this.getMonth() != other.getMonth()) {
            return false;
        }
        if (this.getPlace() != other.getPlace()) {
            return false;
        }
        if (Double.compare(this.getWeight(), other.getWeight()) != 0) {
            return false;
        }
        DayOfWeek this$dayOfWeek = this.getDayOfWeek();
        DayOfWeek other$dayOfWeek = other.getDayOfWeek();
        if (this$dayOfWeek == null ? other$dayOfWeek != null : !this$dayOfWeek.equals(other$dayOfWeek)) {
            return false;
        }
        ValidityPeriod this$validityPeriod = this.getValidityPeriod();
        ValidityPeriod other$validityPeriod = other.getValidityPeriod();
        return !(this$validityPeriod == null ? other$validityPeriod != null : !((Object)this$validityPeriod).equals(other$validityPeriod));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMonth();
        result = result * 59 + this.getPlace();
        long $weight = Double.doubleToLongBits(this.getWeight());
        result = result * 59 + (int)($weight >>> 32 ^ $weight);
        DayOfWeek $dayOfWeek = this.getDayOfWeek();
        result = result * 59 + ($dayOfWeek == null ? 43 : $dayOfWeek.hashCode());
        ValidityPeriod $validityPeriod = this.getValidityPeriod();
        result = result * 59 + ($validityPeriod == null ? 43 : ((Object)$validityPeriod).hashCode());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "FixedWeekDay(month=" + this.getMonth() + ", place=" + this.getPlace() + ", dayOfWeek=" + String.valueOf(this.getDayOfWeek()) + ", weight=" + this.getWeight() + ", validityPeriod=" + String.valueOf(this.getValidityPeriod()) + ")";
    }
}

