/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.timeseries.regression;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import jdplus.toolkit.base.api.data.Parameter;
import jdplus.toolkit.base.api.timeseries.regression.ITsVariable;
import jdplus.toolkit.base.api.timeseries.regression.ModifiedTsVariable;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class Variable<V extends ITsVariable> {
    @NonNull
    private final String name;
    @NonNull
    private final V core;
    private final Parameter[] coefficients;
    @NonNull
    private final Map<String, String> attributes;
    public static final String EXCLUDED = "excluded";

    public int dim() {
        return this.core.dim();
    }

    public boolean hasAttribute(String id) {
        return this.attributes.containsKey(id);
    }

    public String attribute(String id) {
        return this.attributes.get(id);
    }

    public boolean isAttribute(String key, String value) {
        String val = this.attributes.get(key);
        return val != null && val.equals(value);
    }

    public boolean test(Predicate<ITsVariable> pred) {
        V v = this.core;
        if (v instanceof ModifiedTsVariable) {
            ModifiedTsVariable mcore = (ModifiedTsVariable)v;
            return pred.test(mcore.getVariable());
        }
        return pred.test((ITsVariable)this.core);
    }

    @NonNull
    public Parameter getCoefficient(int i) {
        return this.coefficients == null ? Parameter.undefined() : this.coefficients[i];
    }

    @NonNull
    public Parameter[] getCoefficients() {
        return this.coefficients == null ? Parameter.make(this.core.dim()) : (Parameter[])this.coefficients.clone();
    }

    public static Variable variable(@NonNull String name, @NonNull ITsVariable variable, Map<String, String> attributes) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (variable == null) {
            throw new NullPointerException("variable is marked non-null but is null");
        }
        if (attributes == null) {
            return new Variable<ITsVariable>(name, variable, null, Collections.emptyMap());
        }
        return new Variable<ITsVariable>(name, variable, null, Collections.unmodifiableMap(attributes));
    }

    public static Variable variable(@NonNull String name, @NonNull ITsVariable variable) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (variable == null) {
            throw new NullPointerException("variable is marked non-null but is null");
        }
        return new Variable<ITsVariable>(name, variable, null, Collections.emptyMap());
    }

    public int freeCoefficientsCount() {
        if (this.coefficients == null) {
            return this.core.dim();
        }
        return Parameter.freeParametersCount(this.coefficients);
    }

    public int fixedCoefficientsCount() {
        if (this.coefficients == null) {
            return 0;
        }
        return Parameter.fixedParametersCount(this.coefficients);
    }

    public boolean isPreadjustment() {
        return this.coefficients != null && !Parameter.hasFreeParameters(this.coefficients);
    }

    public boolean isFree() {
        return Parameter.isFree(this.coefficients);
    }

    public Variable rename(String name) {
        if (name.equals(this.name)) {
            return this;
        }
        return new Variable<V>(name, this.core, this.coefficients, this.attributes);
    }

    public Variable withCoefficient(Parameter coefficient) {
        Parameter[] parameterArray;
        if (this.core.dim() != 1) {
            throw new IllegalArgumentException();
        }
        if (coefficient == null && this.coefficients == null) {
            return this;
        }
        if (coefficient == null) {
            parameterArray = null;
        } else {
            Parameter[] parameterArray2 = new Parameter[1];
            parameterArray = parameterArray2;
            parameterArray2[0] = coefficient;
        }
        return new Variable<V>(this.name, this.core, parameterArray, this.attributes);
    }

    public Variable withCoefficients(Parameter[] coefficients) {
        if (coefficients != null && this.core.dim() != coefficients.length) {
            throw new IllegalArgumentException();
        }
        if (coefficients == null && this.coefficients == null) {
            return this;
        }
        return new Variable<V>(this.name, this.core, coefficients, this.attributes);
    }

    public Variable withCore(ITsVariable ncore) {
        if (this.coefficients != null && ncore.dim() != this.coefficients.length) {
            throw new IllegalArgumentException();
        }
        return new Variable<ITsVariable>(this.name, ncore, this.coefficients, this.attributes);
    }

    public Variable withoutAttribute(String key) {
        if (!this.attributes.containsKey(key)) {
            return this;
        }
        HashMap<String, String> natts = new HashMap<String, String>(this.attributes);
        natts.remove(key);
        return natts.isEmpty() ? new Variable<V>(this.name, this.core, this.coefficients, Collections.emptyMap()) : new Variable<V>(this.name, this.core, this.coefficients, Collections.unmodifiableMap(natts));
    }

    public Variable setAttribute(String key, String value) {
        HashMap<String, String> natts = new HashMap<String, String>(this.attributes);
        natts.put(key, value);
        return new Variable<V>(this.name, this.core, this.coefficients, Collections.unmodifiableMap(natts));
    }

    public Variable removeAttribute(String key) {
        HashMap<String, String> natts = new HashMap<String, String>(this.attributes);
        natts.remove(key);
        return new Variable<V>(this.name, this.core, this.coefficients, Collections.unmodifiableMap(natts));
    }

    public Variable replaceAttribute(String oldkey, String newkey, String newvalue) {
        HashMap<String, String> natts = new HashMap<String, String>(this.attributes);
        natts.remove(oldkey);
        natts.put(newkey, newvalue);
        return new Variable<V>(this.name, this.core, this.coefficients, Collections.unmodifiableMap(natts));
    }

    public Variable setAttributes(Map<String, String> additionalAttributes) {
        if (additionalAttributes.isEmpty()) {
            return this;
        }
        if (this.attributes.isEmpty()) {
            return new Variable<V>(this.name, this.core, this.coefficients, Collections.unmodifiableMap(additionalAttributes));
        }
        HashMap<String, String> natts = new HashMap<String, String>(this.attributes);
        natts.putAll(additionalAttributes);
        return new Variable<V>(this.name, this.core, this.coefficients, Collections.unmodifiableMap(natts));
    }

    public boolean isExcluded() {
        return this.attributes.containsKey(EXCLUDED);
    }

    public Variable exclude(boolean excluded) {
        if (this.isExcluded() == excluded) {
            return this;
        }
        if (!excluded) {
            return this.removeAttribute(EXCLUDED).withCoefficients(null);
        }
        return this.setAttribute(EXCLUDED, Boolean.toString(excluded)).withCoefficients(Parameter.zero(this.core.dim()));
    }

    @Generated
    Variable(@NonNull String name, @NonNull V core, Parameter[] coefficients, @NonNull Map<String, String> attributes) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (core == null) {
            throw new NullPointerException("core is marked non-null but is null");
        }
        if (attributes == null) {
            throw new NullPointerException("attributes is marked non-null but is null");
        }
        this.name = name;
        this.core = core;
        this.coefficients = coefficients;
        this.attributes = attributes;
    }

    @Generated
    public static <V extends ITsVariable> @org.jspecify.annotations.NonNull Builder<V> builder() {
        return new Builder();
    }

    @Generated
    public @org.jspecify.annotations.NonNull Builder<V> toBuilder() {
        Builder builder = new Builder().name(this.name).core(this.core).coefficients(this.coefficients);
        if (this.attributes != null) {
            builder.attributes(this.attributes);
        }
        return builder;
    }

    @NonNull
    @Generated
    public String getName() {
        return this.name;
    }

    @NonNull
    @Generated
    public V getCore() {
        return this.core;
    }

    @NonNull
    @Generated
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Variable)) {
            return false;
        }
        Variable other = (Variable)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        V this$core = this.getCore();
        V other$core = other.getCore();
        if (this$core == null ? other$core != null : !this$core.equals(other$core)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getCoefficients(), other.getCoefficients())) {
            return false;
        }
        Map<String, String> this$attributes = this.getAttributes();
        Map<String, String> other$attributes = other.getAttributes();
        return !(this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        V $core = this.getCore();
        result = result * 59 + ($core == null ? 43 : $core.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getCoefficients());
        Map<String, String> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        return result;
    }

    @Generated
    public @org.jspecify.annotations.NonNull String toString() {
        return "Variable(name=" + this.getName() + ", core=" + String.valueOf(this.getCore()) + ", coefficients=" + Arrays.deepToString(this.getCoefficients()) + ", attributes=" + String.valueOf(this.getAttributes()) + ")";
    }

    @Generated
    public static class Builder<V extends ITsVariable> {
        @Generated
        private String name;
        @Generated
        private V core;
        @Generated
        private Parameter[] coefficients;
        @Generated
        private ArrayList<String> attributes$key;
        @Generated
        private ArrayList<String> attributes$value;

        @Generated
        Builder() {
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder<V> name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder<V> core(@NonNull V core) {
            if (core == null) {
                throw new NullPointerException("core is marked non-null but is null");
            }
            this.core = core;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder<V> coefficients(Parameter[] coefficients) {
            this.coefficients = coefficients;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder<V> attribute(String attributeKey, String attributeValue) {
            if (this.attributes$key == null) {
                this.attributes$key = new ArrayList();
                this.attributes$value = new ArrayList();
            }
            this.attributes$key.add(attributeKey);
            this.attributes$value.add(attributeValue);
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder<V> attributes(@org.jspecify.annotations.NonNull Map<? extends String, ? extends String> attributes) {
            if (attributes == null) {
                throw new NullPointerException("attributes cannot be null");
            }
            if (this.attributes$key == null) {
                this.attributes$key = new ArrayList();
                this.attributes$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : attributes.entrySet()) {
                this.attributes$key.add($lombokEntry.getKey());
                this.attributes$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder<V> clearAttributes() {
            if (this.attributes$key != null) {
                this.attributes$key.clear();
                this.attributes$value.clear();
            }
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Variable<V> build() {
            Map<String, String> attributes;
            switch (this.attributes$key == null ? 0 : this.attributes$key.size()) {
                case 0: {
                    attributes = Collections.emptyMap();
                    break;
                }
                case 1: {
                    attributes = Collections.singletonMap(this.attributes$key.get(0), this.attributes$value.get(0));
                    break;
                }
                default: {
                    attributes = new LinkedHashMap(this.attributes$key.size() < 0x40000000 ? 1 + this.attributes$key.size() + (this.attributes$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.attributes$key.size(); ++$i) {
                        attributes.put(this.attributes$key.get($i), this.attributes$value.get($i));
                    }
                    attributes = Collections.unmodifiableMap(attributes);
                }
            }
            return new Variable<V>(this.name, this.core, this.coefficients, attributes);
        }

        @Generated
        public @org.jspecify.annotations.NonNull String toString() {
            return "Variable.Builder(name=" + this.name + ", core=" + String.valueOf(this.core) + ", coefficients=" + Arrays.deepToString(this.coefficients) + ", attributes$key=" + String.valueOf(this.attributes$key) + ", attributes$value=" + String.valueOf(this.attributes$value) + ")";
        }
    }
}

