;  BITBLT.ASM  BitBlt routines
;  Copyright (C) 1991-1998  Felix Ritter
;
;  This program is free software; you can redistribute it and/or modify
;  it under the terms of the GNU General Public License as published by
;  the Free Software Foundation; either version 2 of the License, or
;  (at your option) any later version.
;
;  This program is distributed in the hope that it will be useful,
;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;  GNU General Public License for more details.
;
;  You should have received a copy of the GNU General Public License
;  along with this program; if not, write to the Free Software
;  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

.MODEL huge, C
.286

INCLUDE VIOCONST.INC

.CODE
	ColAnz1_tmp     DW 0
	Spalten1_tmp    DW 0
	Xq              DW 0
	Yq              DW 0
	Xz              DW 0
	Yz              DW 0
	Sig_VIOLEN      DW 0

	EXTRN   VideoReset:     FAR

;*---------------------------------------------------------*
;* WinPtr   : Ermittelt den Offset in einem RAM-Window fr 
;*            ein best. Bit
;*- Eingabe  : AX    = Grafikzeile
;*             BX    = Grafikspalte
;*             CX    = Lnge des Windows (in Textspalten)  
;*             DX    = Hhe der Segment-Teilung des Windows
;*                     (falls keine Teilung erwnscht, DX=0)
;*- Ausgabe  : BX    = Window-Offset (Pointer)
;*- Register : AX und BX werden verndert
;*---------------------------------------------------------*

PUBLIC WinPtr
WinPtr PROC FAR
        PUSH    BX              ;* Grafikspalte retten

        OR      DX,DX           ;* Teilung erwnscht?
        JZ      NoTeil          ;* nein, Sprung
        MOV     BX,DX
	PUSH    CX
        XOR     CX,CX
SD1:    SUB     AX,BX
        JC      SDR
        JZ      SDNR
        INC     CX
        JMP     SD1
SDR:    ADD     AX,BX
        MOV     BX,AX           ;* BX = Rest
        JMP     SDEx
SDNR:   INC     CX
        XOR     BX,BX
SDEx:   XOR     AX,AX
        MOV     AX,CX
	POP     CX
        MOV     AX,BX           ;* AX = AX MOD DX
NoTeil: POP     BX
        PUSH    BX

        MOV     BX,CX           ;* Anzahl der Bytes pro
                                ;*  Zeile nach BX
	PUSH    BX
        PUSH    CX
        CMP     AX,BX       ;* Ausnutzung des Kommunikativ-
                            ;*  Gesetzes
        JNC     AXGross     ;* zur Beschleunigung der 
			    ;*  Multiplikation
        MOV     CX,AX       ;* AX kleiner als BX -> 
                            ;*        AX = Schleifenzhler
        JMP     MultBeg     ;*        BX = Additions-Element
AXGross:MOV     CX,BX       ;* BX kleiner als AX -> 
                            ;*        BX = Schleifenzhler
        MOV     BX,AX       ;*        AX = Additions-Element
MultBeg:XOR     AX,AX
        CMP     CX,0        ;* kleinster Faktor=0 ?
        JZ      ExitMul     ;* ja -> Ende der Multiplikation
        XOR     AX,AX
AM1:    ADD     AX,BX
        LOOP    AM1
ExitMul:POP     CX
	POP     BX
	POP     BX              ;* Grafikspalte holen
        SHR     BX,1            ;* Grafikspalte drei mal 
                                ;*  nach rechts ...
        SHR     BX,1            ;* verschieben und damit 
                                ;*  durch 8 teilen ...
        SHR     BX,1
        ADD     BX,AX           ;* Zeilenoffset addieren
        RET
WinPtr ENDP

;*---------------------------------------------------------*
;*  Kopiert rechteckige Bereiche innerhalb des Video-RAM   *
;*---------------------------------------------------------*

PUBLIC GMove1VE
PROC GMove1VE, VX:WORD, VY:WORD, Spalten2:WORD, Lines2:WORD, NX:WORD, NY:WORD

	PUSHA
	PUSH DS
	MOV     AX,Spalten2
	MOV     CS:Spalten1_tmp,AX
	ADD     AX,7
	SHR     AX,1
	SHR     AX,1
	SHR     AX,1
	INC     AX
	MOV     CS:ColAnz1_tmp,AX
	MOV     CX,Lines2

	MOV     AX,NY
	CMP     AX,VY
	JG      Abwaerts
	JL      Aufwaerts
	MOV     AX,NX
	CMP     AX,VX
	JG      Abwaerts

 Aufwaerts:
	CLD
	MOV     AX,VX           ;* Kopierrichtung aufwrts
	MOV     CS:Xq,AX
	MOV     AX,VY
	MOV     CS:Yq,AX
	MOV     AX,NX
	MOV     CS:Xz,AX
	MOV     AX,NY
	MOV     CS:Yz,AX
	MOV     CS:Sig_VIOLEN,VIO_LEN
	JMP     Weiter

 Abwaerts:
	STD                     ;* Kopierrichtung abwrts
	MOV     AX,CS:Spalten1_tmp
	;DEC     AX                ! FR 'IconMove' HERAUSGENOMMEN !
	PUSH    AX
	ADD     AX,VX
	MOV     CS:Xq,AX
	POP     AX
	ADD     AX,NX
	MOV     CS:Xz,AX
	MOV     AX,CX
	DEC     AX
	PUSH    AX
	ADD     AX,VY
	MOV     CS:Yq,AX
	POP     AX
	ADD     AX,NY
	MOV     CS:Yz,AX
	XOR     AX,AX
	SUB     AX,VIO_LEN
	MOV     CS:Sig_VIOLEN,AX

 Weiter:PUSH    CX
	MOV     DX,3CEH         ;* Write-Modus 1
        MOV     AX,0105H
        OUT     DX,AX


        ;----- Offset in die auszulesende Seite bilden -----
        
	MOV     AX,CS:Yq
	MOV     BX,CS:Xq
	MOV     CX,VIO_LEN
        XOR     DX,DX
        CALL    WinPtr
	MOV     SI,BX
	MOV     AX,CS:Yz
	MOV     BX,CS:Xz
	MOV     CX,VIO_LEN
        XOR     DX,DX
        CALL    WinPtr
	MOV     DI,BX
	MOV     AX,VIO_SEG
        MOV     ES,AX
        MOV     DS,AX           ; DS = ES = VIO_SEG
	MOV     AX,CS:Sig_VIOLEN
        MOV     DX,SI

        POP     CX              ;* Zeilenzhler holen

NextRow:PUSH    CX 
	MOV     CX,CS:ColAnz1_tmp
	REP     MOVSB

	ADD     BX,AX           ;* Addieren der Bytes pro Zeile
	ADD     DX,AX
         
        MOV     DI,BX           ;* Startpointer neu stellen
        MOV     SI,DX
        POP     CX              ;* Zeilenzhler holen
        LOOP    NextRow

        MOV     DX,3CEH         ;* Reset --> Write-Modus 0
        MOV     AX,0005H
        OUT     DX,AX

	POP DS
	POPA
	RET
ENDP


END


;*---------------------------------------------------------*
;*                   Ende von VIO.ASM                      *
