/*  CALC.C  Calculator
 *  Copyright (C) 1991-1998  Felix Ritter
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <dos.h>
#include <graphics.h>
#include <conio.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <signal.h>
#include <float.h>
#include "pal_op.h"
#include "filemgr.h"
#include "mouse_op.h"

#define MAXOPERATIONEN  50

enum{ ADDITION= 1,
      SUBTRAKTION,
      MULTIPLIKATION,
      DIVISION,
      PROZENT,
      X_WURZEL,
      POTENZIEREN };

typedef void (*fptr)();

#pragma warn -par /* WARNUNG: 'Parameter 'parameter' is never used' unterdrcken */

void x87Handler( int fault, int sub)
{
   switch( sub)
   {
      case FPE_INEXACT:                                   /* Rundungsfehler */
	 ErrorMsg( "Rundungsfehler");
	 break;
      case FPE_INTDIV0:                          /* Integerdivision durch 0 */
      case FPE_ZERODIVIDE:                               /* Division duch 0 */
	 ErrorMsg( "Division durch 0");
	 break;
      case FPE_INTOVFLOW:              /* INTO-Aufruf mit gesetztem OF-Flag */
	 ErrorMsg( "INTO-Aufruf mit gesetztem OF-Flag");
	 break;
      case FPE_INVALID:                                /* ungltiger Befehl */
	 ErrorMsg( "ungltiger Befehl");
	 break;
      case FPE_OVERFLOW:                                        /* berlauf */
      case FPE_UNDERFLOW:                                      /* Unterlauf */
	 ErrorMsg( "Zahlenbereich (3.4E-380 bis 3.4E+380) berschritten");
	 break;
   }
}

#pragma warn +par /* WARNUNG: 'Parameter 'parameter' is never used' erlauben */

int matherr( struct exception *e)
{
   int ret_val= 0;

   switch( e->type)
   {
      case DOMAIN:                /* Argument nicht im Definitionsbereich ? */
	 ErrorMsg( "der X- bzw. Y-Wert der Teilrechnung ist nicht definiert");
	 e->retval= 0;
	 ret_val= 1;
	 break;
      case OVERFLOW:
	 ErrorMsg( "Zahlenbereich (3.4E-380 bis 3.4E+380) berschritten");
	 e->retval= 0;
	 ret_val= 1;
	 break;
      case SING:
	 ErrorMsg( "das Ergebnis wre singulr");
	 e->retval= 0;
	 ret_val= 1;
	 break;
      case UNDERFLOW:
	 e->retval= 0;
	 ret_val= 1;
	 break;
      case TLOSS:       /* Genauigkeitsverlust, doch Problem wird ignoriert */
	 ret_val= 1;
	 break;
   }
   return( ret_val);                 /* bei anderen Fehlern keine Korrektur */
}

double _Rechnung( BYTE Operation, double operand1, double operand2)
{
   double retVal= 0;
   fptr oldHandler;

   oldHandler= signal( SIGFPE, ( fptr)x87Handler);

   switch( Operation)
   {
      case ADDITION:
	 retVal= operand1+ operand2;
	 break;
      case SUBTRAKTION:
	 retVal= operand1- operand2;
	 break;
      case MULTIPLIKATION:
	 retVal= operand1* operand2;
	 break;
      case DIVISION:
	 retVal= operand1/ operand2;
	 break;
      case PROZENT:
	 retVal= operand1* operand2/ 100.0;
	 break;
      case X_WURZEL:
	 retVal= pow( operand1, 1.0/ operand2);
	 break;
      case POTENZIEREN:
	 retVal= pow( operand1, operand2);
	 break;
   }
   signal( SIGFPE, oldHandler);

   return( retVal);
}

void _Rechner( void)
{
   int ret= 0, status;
   char anz_new_chars= 0, new_chars[ 25], Anzeige[ 25], *Anzeige_ptr, *tmp_ptr;
   double operand[ MAXOPERATIONEN+ 1], last_Anz, Speicher= 0, letzter_Wert;
   BYTE operation[ MAXOPERATIONEN+ 1], operanden_z= 0, operations_z= 0, operanden_i,
	operations_i, anf_operation= 0, durchlauf= 0, letzte_Operation;
   BOOL new_Anz= 0, RETURN_con= 0;
   WORD mauspos[]= { BUTTON| FRAME| KEY| DEFBUTTON,   5,  27,   5,  21, ESC,
		     BUTTON|        KEY,            316, 338,  39,  61, BACKSPACE,
		     BUTTON|        KEY,            131, 173, 186, 208, '0',
		     BUTTON|        KEY,            131, 173, 156, 178, '1',
		     BUTTON|        KEY,            181, 223, 156, 178, '2',
		     BUTTON|        KEY,            231, 273, 156, 178, '3',
		     BUTTON|        KEY,            131, 173, 126, 148, '4',
		     BUTTON|        KEY,            181, 223, 126, 148, '5',
		     BUTTON|        KEY,            231, 273, 126, 148, '6',
		     BUTTON|        KEY,            131, 173,  96, 118, '7',
		     BUTTON|        KEY,            181, 223,  96, 118, '8',
		     BUTTON|        KEY,            231, 273,  96, 118, '9',
		     BUTTON|        KEY,             31,  73,  66,  88, 'e',
		     BUTTON|        KEY,             81, 123,  66,  88, 'h',
		     BUTTON|        KEY,            131, 173,  66,  88, 'q',
		     BUTTON|        KEY,            181, 223,  66,  88, 'a',
		     BUTTON|        KEY,            231, 273,  66,  88, 'x',
		     BUTTON|        KEY,            281, 323,  66,  88, 'k',
		     BUTTON|        KEY,             31,  73,  96, 118, '#',
		     BUTTON|        KEY,             81, 123,  96, 118, '/',
		     BUTTON|        KEY,            281, 323,  96, 118, 'w',
		     BUTTON|        KEY,             31,  73, 126, 148, 'm',
		     BUTTON|        KEY,             81, 123, 126, 148, '*',
		     BUTTON|        KEY,            281, 323, 126, 148, '%',
		     BUTTON|        KEY,             31,  73, 156, 178, 'p',
		     BUTTON|        KEY,             81, 123, 156, 178, '-',
		     BUTTON|        KEY,            281, 323, 156, 178, 'r',
		     BUTTON|        KEY,             31,  73, 186, 208, 'c',
		     BUTTON|        KEY,             81, 123, 186, 208, '+',
		     BUTTON|        KEY,            181, 223, 186, 208, 'i',
		     BUTTON|        KEY,            231, 273, 186, 208, ',',
		     BUTTON|        KEY,            281, 323, 186, 208, RETURN,
		     MOVEWINDOW };
   MAUSStruct MS= { DEFAULT, DEFAULT, 355, 230, 33, INIT, NULL, AUS};

   MS.x= &rechnerx;
   MS.y= &rechnery;
   MS.mauspos= mauspos;
   PCX_Window( MS.x, MS.y, PCX_RECHNER, &MS.sa, SHADOW);
   Anzeige_ptr= strcpy( Anzeige, "                      0")+ 22;
   do
   {
      if( new_Anz|| ( anf_operation> 0))
	 sprintf( Anzeige+ 1, "%22G", last_Anz);
      MOverTextxy( *MS.x+ 86, *MS.y+ 39, Anzeige, 23);
      while(( status= __CheckMousepos( &MS))== -1)
	 ;
      if( RETURN_con&& ( status!= 31))               /* Ergebnisanforderung */
	 RETURN_con= 0;
      last_Anz= atof( Anzeige+ 1);                         /* 'M' auslassen */
      if( new_Anz|| ( anf_operation> 0))
      {
	 *( Anzeige_ptr= ( char *)memset( Anzeige+ 1, SPACE, 22)+ 21)= '0';
	 new_Anz= anf_operation= 0;
      }
      switch( status)
      {
	 case 0:                                                     /* ESC */
	    ret= 1;
	    break;
	 case 1:                                               /* BACKSPACE */
	    if( Anzeige_ptr< Anzeige+ 22)
	    {
	       if( *( Anzeige+ 21)== 'E')
		  status= 2;
	       else
		  status= 1;
	       memmove( Anzeige_ptr+ status, Anzeige_ptr, strlen( Anzeige_ptr)- status);
	       memset( Anzeige_ptr, SPACE, status);
	       Anzeige_ptr+= status;
	    }
	    else
	       *Anzeige_ptr= '0';
	    break;
	 case 2:                                             /* Ziffern 0-9 */
	 case 3:
	 case 4:
	 case 5:
	 case 6:
	 case 7:
	 case 8:
	 case 9:
	 case 10:
	 case 11:
	    anz_new_chars= sprintf( new_chars, "%c", 46+ status);
	    break;
	 case 12:                                                    /* EXP */
	    if( *( Anzeige+ 22)!= '.')
	    {
	       if( strchr( Anzeige_ptr, 'E')== NULL)
	       {
		  if(( *Anzeige_ptr== '0')|| (( *Anzeige_ptr== '-')&& ( Anzeige_ptr== Anzeige+ 22)))
		  {
		     anz_new_chars= 1;
		     strcpy( new_chars, "1");
		  }
		  anz_new_chars+= 2;
		  strcat( new_chars, "E+");
	       }
	       else
		  Hinweis( "Es ist nur ein Exponent mglich");
	    }
	    else
	       Hinweis( "Komma was ???");
	    break;
	 case 13:                                                    /* X^Y */
	    anf_operation= POTENZIEREN;
	    break;
	 case 14:                                                     /* X */
	    last_Anz= pow( last_Anz, 2);
	    new_Anz= 1;
	    break;
	 case 15:                                                    /* ABS */
	    last_Anz= fabs( last_Anz);
	    new_Anz= 1;
	    break;
	 case 16:                                                     /* x */
	    anf_operation= X_WURZEL;
	    break;
	 case 17:                                                     /* 3 */
	    last_Anz= pow( last_Anz, 1.0/ 3.0);
	    new_Anz= 1;
	    break;
	 case 18:                                                     /* MR */
	    if( *Anzeige== 'M')
	    {
	       last_Anz= Speicher;
	       new_Anz= 1;
	    }
	    break;
	 case 19:                                                      /* / */
	    anf_operation= DIVISION;
	    break;
	 case 20:                                                      /*  */
	    last_Anz= sqrt( last_Anz);
	    new_Anz= 1;
	    break;
	 case 21:                                                      /* M */
	    if( last_Anz!= 0)
	    {
	       Speicher= last_Anz;
	       *Anzeige= 'M';
	       new_Anz= 1;
	    }
	    else
	    {
	       Speicher= 0;
	       *Anzeige= SPACE;
	    }
	    break;
	 case 22:                                                      /* * */
	    anf_operation= MULTIPLIKATION;
	    break;
	 case 23:                                                      /* % */
	    anf_operation= PROZENT;
	    break;
	 case 24:                                                     /* M+ */
	    if( last_Anz!= 0)
	    {
	       Speicher+= last_Anz;
	       *Anzeige= 'M';
	       new_Anz= 1;
	    }
	    else
	    {
	       Speicher= 0;
	       *Anzeige= SPACE;
	    }
	    break;
	 case 25:                                                      /* - */
	    anf_operation= SUBTRAKTION;
	    break;
	 case 26:                                                    /* 1/X */
	    last_Anz= _Rechnung( DIVISION, 1.0, last_Anz);
	    new_Anz= 1;
	    break;
	 case 27:                                                     /* CE */
	    operanden_z= operations_z= 0;
	    last_Anz= 0;
	    new_Anz= 1;
	    break;
	 case 28:                                                      /* + */
	    anf_operation= ADDITION;
	    break;
	 case 29:                                                      /*  */
	    if( *Anzeige_ptr!= '0')
	    {
	       if(( tmp_ptr= strchr( Anzeige_ptr, 'E'))== NULL)
	       {
		  if( *Anzeige_ptr!= '-')
		     *( --Anzeige_ptr)= '-';
		  else
		     *( Anzeige_ptr++)= SPACE;
	       }
	       else
	       {
		  if( *( tmp_ptr+ 1)== '+')
		     *( tmp_ptr+ 1)= '-';
		  else
		     *( tmp_ptr+ 1)= '+';
	       }
	    }
	    else
	    {
	       anz_new_chars= 1;
	       strcpy( new_chars, "-");
	    }
	    break;
	 case 30:                                                      /* . */
	    if( strchr( Anzeige_ptr, 'E')== NULL)
	    {
	       if( strchr( Anzeige_ptr, '.')== NULL)
	       {
		  anz_new_chars= 1;
		  strcpy( new_chars, ".");
	       }
	       else
		  Hinweis( "Es ist nur ein Dezimalpunkt mglich");
	    }
	    else
	       Hinweis( "Es kann nur mit ganzen Werten als Exponent gerechnet werden");
	    break;
	 case 31:                                                      /* = */
	    operand[ operanden_z]= last_Anz;
	    if( RETURN_con|| ( operations_z> 0))   /* wurde ein Rechnung eingegeben ? */
	    {
	       if( !RETURN_con)  /* keine wiederholte Ergebnisanforderung ? */
	       {
		  letzter_Wert= last_Anz;
		  letzte_Operation= operation[ operations_z- 1];
		  RETURN_con= 1;
	       }
	       else
	       {
		  operand[ ++operanden_z]= letzter_Wert;
		  operation[ operations_z++]= letzte_Operation;
	       }
	       for( durchlauf= 1; durchlauf<= 2; durchlauf++)
	       {
		  for( operations_i= 0; operations_i< operations_z; operations_i++)
		  {
		     if(( durchlauf== 1)&&(( operation[ operations_i]== ADDITION)|| ( operation[ operations_i]== SUBTRAKTION)))
			continue;
		     operand[ operations_i]= _Rechnung( operation[ operations_i], operand[ operations_i], operand[ operations_i+ 1]);
		     memmove( &operation[ operations_i], &operation[ operations_i+ 1], operations_z- operations_i);
		     memmove( &( double)operand[ operations_i+ 1], &( double)operand[ operations_i+ 2], (( operations_z-- - 1)- operations_i)* sizeof( double));
		     operations_i= -1;  /* -1 da eine 0 sofort bei 'for' zur 1 increminiert wrde */
		  }
	       }
	       operanden_z= operations_z= 0;
	       last_Anz= operand[ 0];
	       new_Anz= 1;
	    }
	    break;
      }
      if( anf_operation> 0)
      {
	 if(( operanden_z< MAXOPERATIONEN)&& ( operations_z< MAXOPERATIONEN))
	 {
	    operand[ operanden_z++]= last_Anz;
	    operation[ operations_z++]= anf_operation;
	 }
	 else
	    Hinweis( "Maximale Anzahl zusammenhngender Operationen erreicht");
      }
      if( anz_new_chars> 0)
      {
	 if( Anzeige_ptr> ( Anzeige+ 2+ anz_new_chars))
	 {
	    if( *Anzeige_ptr!= '0')
	    {
	       memmove( Anzeige_ptr- anz_new_chars, Anzeige_ptr, strlen( Anzeige_ptr));
	       Anzeige_ptr-= anz_new_chars;
	    }
	    else
	       Anzeige_ptr-= anz_new_chars- 1;
	    strcpy( Anzeige+ 23- anz_new_chars, new_chars);
	 }
	 else
	    Hinweis( "Die Anzeige ist voll");
	 *new_chars= anz_new_chars= 0;
      }
   }while( !ret);
   ShowMouse( AUS);
   BigScreenRestore( &MS.sa, *MS.x, *MS.y);
   ShowMouse( AN);
}
