/*  CD_OP.C  CDPlayer-related operations
 *  Copyright (C) 1991-1998  Felix Ritter
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <dos.h>
#include <alloc.h>
#include "msg.h"
#include "cd_op.h"

/* Alle Variablen werden als statische Objekte definiert, die nur
   von Funktionen in diesem Modul verndert werden knnen.
*/

typedef struct _Track_Info{
			     CD_Addr start;        /* Startzeitpunkt in RED */
			     DWORD   frames;           /* Lnge des Stckes */
			     CD_Addr delta; /* Lnge in minute:second:frame */
			  }CD_index[ 99];
static CD_index *index;               /* dynamischer Zeiger auf _Track_Info */

static DWORD    start_play;        /* Startframe des aktuellen Playrequests */
static DWORD    end_play;            /* Endframe des aktuellen Playrequests */

static QChannel_Info qinfo;   /* Globale Variable fr Q-Kanal Informationen */
static WORD     audio_drive;   /* Laufwerknummer, auf die alle Audiofunktionen
				  zugreifen (0=A:, 1=B: etc.). Diese Variable
				  wird in init_CDAudio gesetzt. */

static BYTE     titles;                /* Anzahl der Titel auf aktueller CD */

/* Umsetzung einer Zeitangabe in RED-Book Notation MM:SS.FF in Sektorwert
   nach High Sierra Group (HSG). */

DWORD RED2HSG( CD_Addr time)
{
   return( ( DWORD)( ( DWORD)time.TIME.minute* 4500+ ( DWORD)time.TIME.second* 75+ ( DWORD)time.TIME.frame));
}

/* Umsetzung eines HSG-Sektors in RED-Book Zeitangabe */

CD_Addr HSG2RED( DWORD nsect)
{
   CD_Addr local;

   local.TIME.frame= nsect% 75;
   nsect= nsect/ 75;
   local.TIME.second= nsect% 60;
   local.TIME.minute= nsect/ 60;
   local.TIME.unused= 0;
   return( local);
}

/* Struktur eines IOCTL Anfrageblockes, in dem die invarianten Elemente
   initialisert wurden */

IOCTL_Inp_Request rqinp={ {sizeof( IOCTL_Inp_Request), 0, IOCTL_INP}, 0, 0, 0, 0, 0};

/* Schickt einen IOCTL-Input-Request an das CDROM Laufwerk, das mit der
   Laufwerknummer drive bei MSCDEX registriert wurde.
   Als Ergebnis wird das Statuswort der Anfrage zurckgeliefert. */

WORD IOctl_in( WORD drive, BYTE unit, void *prequest, WORD rqlen)
{
   IOCTL_Inp_Request far *prqinp;

   rqinp.ioctl_nbytes= rqlen;
   rqinp.ioctl_xfer= ( void far *)prequest;
   rqinp.ioctl_rqh.rq_unit= unit;                           /* erste Unit ! */
   prqinp= ( IOCTL_Inp_Request far *)&rqinp;
   asm{
       mov ax, 1510h
       mov cx, drive
       les bx, prqinp
       int 2Fh
   }
   return( rqinp.ioctl_rqh.rq_status);
}

/* Ermitteln des Laufwerkzustands.
   Aus der Ergebnisstruktur kann erkannt werden, ob das angegebene
   Laufwerk die Audio Extension untersttzt.
*/

static IO_Inp_Device_Status rq_status= { IOI_DEV_STAT};

DWORD get_Status( BYTE drive)
{
   if( IOctl_in( drive, 0x0, &rq_status, sizeof( IO_Inp_Device_Status))& 0x8000)
      return( -1);
   else
      return( rq_status.status);
}

/* Lesen des Universal Producer Code der CD */

static IO_Inp_UPC rq_upc= { IOI_UPC, RED};

void get_UPC( BYTE upc[])
{
   int i;

   IOctl_in( audio_drive, 0x0, &rq_upc, sizeof( IO_Inp_UPC));

   for( i= 0; i< 7; i++)
      upc[ i]= rq_upc.signature[ i];
}

/*
 * get_Header() liefert die (far) Adresse des Gertesteuerprogrammes fr das
 * CD-ROM Laufwerk.
 */

static IO_Inp_Device_Hdr rq_header={ IOI_DRV_HEAD};

void far *get_Header( void)
{
   IOctl_in( audio_drive, 0x0, &rq_header, sizeof( IO_Inp_Device_Hdr));
   return( rq_header.device_hdr);
}

/*
 * audio_busy() benutzt die zuvor definierte Funktion get_Header(), um zu
 * ermitteln, ob das Laufwerk einen Audio Track abspielt. 
 * Diese Funktion liefert:
	1    - wenn das Laufwerk Musik abspielt 
	0    - wenn keine Musik gespielt wird
 */

static IO_Inp_Device_Hdr rq_busy={ IOI_DRV_HEAD};

WORD audio_busy( void)
{
   return(( IOctl_in(audio_drive, 0x0, &rq_busy, sizeof( IO_Inp_Device_Hdr))& 0x8200));
}

/*
 * Read_Audio_Status() ermittelt liefert eine Struktur, die Auskunft ber
 * PAUSE Modus, Anfangs- und Endezeitpunkt des nchsten PLAY oder RESUME
 * Kommandos gibt.
 */

static IO_Inp_Audio_Status rq_audio_status={ IOI_AUDIO_STATUS};

Audio_Status Read_Audio_Status( void)
{
   IOctl_in( audio_drive, 0, &rq_audio_status, sizeof( IO_Inp_Audio_Status));
   return( rq_audio_status.report);
}

/*
 * get_Media_Changed liefert als Ergebnis die Information, ob die CD
 * gewechselt wurde. Das Mitsumi CRCM Laufwerk schaltet die Audio Kanle erst
 * nach dieser Abfrage frei !
 */

static IO_Inp_Media_Changed rq_media={ IOI_MEDIA_CHANG};

BYTE get_Media_Changed( void)
{
   IOctl_in( audio_drive, 0x0, &rq_media, sizeof( IO_Inp_Media_Changed));
   return( rq_media.media_byte);
}

/*
 * get_TOC() liest das Table of Contents einer CD und speichert dieses
 * in der globalen Struktur index[]. Der Rckgabewert ist die Titelzahl.
 * Neben dem Startzeitpunkt jedes Stckes in RED Notation wird die Lnge 
 * des Stckes in Frames und in RED ermittelt.
 */

BYTE get_TOC(void)
{
   IO_Inp_Audio_Info rq_toc;	                        /* CD Informationen */
   IO_Inp_Track_Info rq_track;                        /* Stckinformationen */
   int i;

   rq_toc.ioctl_cmd= IOI_AUDIO_INFO;
   IOctl_in( audio_drive, 0x0, &rq_toc, sizeof( IO_Inp_Audio_Info));

   /* Ermittle fr alle Stcke oben genannte Informationen! */
   rq_track.ioctl_cmd= IOI_TRACK_INFO;
   for( i= rq_toc.track_lo; i<= rq_toc.track_hi; i++)
   {
      rq_track.tno= i;
      IOctl_in(audio_drive, 0x0, &rq_track, sizeof( IO_Inp_Track_Info));
      ( *index)[i].start= rq_track.start;
      ( *index)[ i- 1].frames= RED2HSG( ( *index)[ i].start)- RED2HSG( ( *index)[i- 1].start);
      ( *index)[ i- 1].delta= HSG2RED( ( *index)[ i- 1].frames);
   }
   ( *index)[ i- 1].frames= RED2HSG( rq_toc.track_lead_out)- RED2HSG( ( *index)[ i- 1].start);
   ( *index)[ i- 1].delta= HSG2RED( ( *index)[ i- 1].frames);

   /* Im Element 0 des Inhaltverzeichnisses wird der Startzeitpunkt und die
      Gesamtlnge der CD gespeichert. */

   ( *index)[ 0].start= ( *index)[ 1].start;
   ( *index)[ 0].frames= RED2HSG( rq_toc.track_lead_out)- RED2HSG( ( *index)[ 1].start);
   ( *index)[ 0].delta= HSG2RED( ( *index)[ 0].frames);
   return( rq_toc.track_hi);                                   /* Titelzahl */
}

/* Information, ob sich das CD Laufwerk im Pause Zustand befindet:
	0 - Nein
	1 - Ja
*/

WORD audio_pause( void)
{
   IO_Inp_Audio_Status rq_audio_status;

   rq_audio_status.ioctl_cmd= IOI_AUDIO_STATUS;
   IOctl_in( audio_drive, 0, &rq_audio_status, sizeof( IO_Inp_Audio_Status));
   return(( rq_audio_status.report.status)& 0x01);
}

BYTE get_track_info( BYTE tno)
{
   IO_Inp_Track_Info rq_track;

   rq_track.ioctl_cmd= IOI_TRACK_INFO;
   rq_track.tno= tno;
   IOctl_in( audio_drive, 0, &rq_track, sizeof( IO_Inp_Track_Info));
   return( rq_track.control);
}

/* Liest die Q-Kanal Information. */

QChannel_Info read_QChannel( void)
{
   static IO_Inp_QChannel rq_qchan;

   rq_qchan.ioctl_cmd= IOI_QCHAN_INFO;
   rq_qchan.addr_mode= RED;
   IOctl_in( audio_drive, 0x0, &rq_qchan, sizeof( IO_Inp_QChannel));
   return( rq_qchan.qinfo);
}

IOCTL_Inp_Request rqoutp={ { sizeof( IOCTL_Outp_Request), 0, IOCTL_OUTP}, 0, 0, 0, 0, 0};

WORD IOctl_out( WORD drive, BYTE unit, void *prequest, WORD rqlen)
{
    IOCTL_Inp_Request far *prqoutp;

    rqoutp.ioctl_nbytes= rqlen;
    rqoutp.ioctl_xfer= ( void far *)prequest;
    rqoutp.ioctl_rqh.rq_unit= unit;                         /* erste Unit ! */

    prqoutp= ( IOCTL_Inp_Request far *)&rqoutp;
    asm{
	mov ax, 1510h
	mov cx, drive
	les bx, prqoutp
	int 2fh
    }
    return( rqoutp.ioctl_rqh.rq_status);
}

/* Zurcksetzten des Laufwerkes */

WORD CD_Reset( void)
{
   static IO_Outp_Reset rq_reset;
   rq_reset.ioctl_cmd= IOO_RESET;
   return( IOctl_out( audio_drive, 0x0, &rq_reset, sizeof( IO_Outp_Reset)));
}

/* Auswerfen der CD */

WORD eject_CD( void)
{
   static IO_Outp_Eject rq_eject;
   rq_eject.ioctl_cmd= IOO_EJECT;
   return( IOctl_out( audio_drive, 0x0, &rq_eject, sizeof( IO_Outp_Eject)));
}

/* Einziehen der CD */

WORD insert_CD( void)
{
   static IO_Outp_Close_Tray rq_insert;
   rq_insert.ioctl_cmd= IOO_CLOSE_TRAY;
   return( IOctl_out( audio_drive, 0x0, &rq_insert, sizeof( IO_Outp_Close_Tray)));
}

/* Einstellen der Lautstrke */

void setvolume( BYTE chan0, BYTE chan1, BYTE chan2, BYTE chan3)
{
   static IO_Outp_Audiochan_Ctrl rq_volume;

   /* Ermitteln des aktuellen Kanalzustandes */

   rq_volume.ioctl_cmd= IOI_AUDIOCHAN_INFO;
   IOctl_in( audio_drive, 0x0, &rq_volume, sizeof( IO_Outp_Audiochan_Ctrl));

   /* ndern der Ausgangslautstrke */

   rq_volume.ioctl_cmd= IOO_AUDIOCHAN_CTRL;
   rq_volume.vol_chan0= chan0;         /* Lautstrke von Ausgang 0 (0-255)  */
   rq_volume.vol_chan1= chan1;
   rq_volume.vol_chan2= chan2;
   rq_volume.vol_chan3= chan3;
   IOctl_out( audio_drive, 0x0, &rq_volume, sizeof( IO_Outp_Audiochan_Ctrl));
}

void setinput( BYTE chan0, BYTE chan1, BYTE chan2, BYTE chan3)
{
   static IO_Outp_Audiochan_Ctrl rq_input;

   /* Ermitteln des aktuellen Kanalzustandes */

   rq_input.ioctl_cmd= IOI_AUDIOCHAN_INFO;
   IOctl_in( audio_drive, 0x0, &rq_input, sizeof( IO_Outp_Audiochan_Ctrl));

   /* ndern der Eingangskanle */

   rq_input.ioctl_cmd= IOO_AUDIOCHAN_CTRL;
   rq_input.inp_chan0= chan0;          /* Eingangskanal (0-3) fr Ausgang 0 */
   rq_input.inp_chan1= chan1;
   rq_input.inp_chan2= chan2;
   rq_input.inp_chan3= chan3;
   IOctl_out( audio_drive, 0x0, &rq_input, sizeof( IO_Outp_Audiochan_Ctrl));
}

/*
 * ----------------------- IOCTL Ende
 */

/* Der Auftragsblock fr PLAY, STOP und RESUME ist immer derselbe.
   Der einzige unterschied findet sich im Befehlscode; abhngig
   hiervon werden die restlichen Informationen ganz oder teilweise
   ignoriert. */

Audio_Play_Request rq_play={ { sizeof( Audio_Play_Request), 0, PLAY_AUDIO}, RED};

WORD Play_Audio( CD_Addr start, DWORD nsectors)
{
   Audio_Play_Request far *prq_play;

   rq_play.start= start;
   rq_play.nframes= nsectors;
   prq_play= ( Audio_Play_Request far *)& rq_play;
   asm{
       mov ax, 1510h
       mov cx, audio_drive
       les bx, prq_play
       int 2fh
   }
   return( rq_play.play_rqh.rq_status);
}

/* Anfang und Dauer eines Stckes werden aus der internen Struktur index
   gelesen und in einem Play Request bermittelt. */

BYTE Play_Track( BYTE tno)
{
   if( tno<= titles)
   {
      Play_Audio( ( *index)[ tno].start, ( *index)[ tno].frames);
      start_play= RED2HSG( ( *index)[ tno].start);
      end_play= RED2HSG( ( *index)[ tno].start)+ ( *index)[ tno].frames;
      return( 0);
   }
   else
      return( -1);
}

/* Abspielen einer Gruppe von Stcken, die direkt hintereinander 
   liegen mssen. */

BYTE Play_Tracks( BYTE from, BYTE to)
{
   DWORD frames= 0;

   if(( from> 0)&& ( from<= to)&& ( to<= titles))
   {
      frames= RED2HSG( ( *index)[ to].start)- RED2HSG( ( *index)[ from].start)+ ( *index)[ to].frames;
      Play_Audio( ( *index)[ from].start, frames);
      start_play= RED2HSG( ( *index)[ from].start);
      end_play= start_play+ frames;
      return( 0);
   }
   return( -1);
}

/* Der Anfang des Stckes wird aus der internen Struktur gelesen und die
   Dauer des Abpielens wird auf 10 Sekunden festgelegt. */

BYTE Play_Track_Intro( int tno)
{
   if(( tno>= 0)&& ( tno<= titles))
   {
      Play_Audio( ( *index)[ tno].start, 15* 75);
      start_play= RED2HSG( ( *index)[ tno].start);
      end_play= RED2HSG( ( *index)[ tno].start)+ 15 *75;
      return( 0);
   }
   else
      return( -1);
}

/* Auer dem Anfrageblock braucht fr das Stopkommando nichts
   bertragen werden.
*/

Audio_Play_Request rq_stop= { { sizeof( Request_Hdr), 0, STOP_AUDIO}, RED};

WORD Stop_Audio( void)
{
    Audio_Play_Request far *prq_stop;

    prq_stop= ( Audio_Play_Request far *)&rq_stop;
    asm{
	mov ax, 1510h
	mov cx, audio_drive
	les bx, prq_stop
	int 2fh
    }
    return( rq_stop.play_rqh.rq_status);
}

/* Der Resume Befehl zum Wiederaufnehmen der Wiedergabe verwendet die
   Informationen des vorausgegangenen Play Requests. */

Audio_Play_Request rq_resume= { { sizeof( Request_Hdr), 0, RESUME_AUDIO}, RED};

WORD Resume_Audio( void)
{
   Audio_Play_Request far *prq_resume;

   prq_resume= ( Audio_Play_Request far *)&rq_resume;
   asm{
       mov ax, 1510h
       mov cx, audio_drive
       les bx, prq_resume
       int 2fh
   }
   return( rq_resume.play_rqh.rq_status);
}

/* Die Funktion Skip_Audio ermittelt die Momentane Position des Kopfes
   und berechnet den Zielframe. Liegt dieser Zielframe hinter dem letzten
   Frame, der durch das Play Kommando angegeben wurde, so wird das Abspielen 
   beendet. 
*/

WORD Skip_Audio( long frames)
{
   DWORD        skip_delta;
   CD_Addr      skip_to;
   DWORD        tmp_start;
   Audio_Status stat_audio;

   qinfo= read_QChannel();
   tmp_start= ( DWORD)qinfo.dmin* 4500+ ( DWORD)qinfo.dsec* 75+ ( DWORD)qinfo.dframe+ frames;
   if( tmp_start>= end_play)
      return( 0);
   skip_to= HSG2RED( tmp_start);
   skip_delta= end_play- tmp_start;
   Stop_Audio();
   Play_Audio( skip_to, skip_delta);
   return( 1);
}

/* Initialisierung des CD ROM Laufwerkes zum Abspielen einer Audio CD.
 * Diese Funktion m u   aufgerufen werden, damit alle anderen Funktionen
 * in diesem Modul korrekt arbeiten.
 * Als Ergebniswert wird die Anzahl der Titel zurckgeliefert.
 * Falls ein Fehler Auftritt, so wird ein Wert < 0 zurckgeliefert:
	- 1: Kein CD-ROM Laufwerk vorhanden
  - 2: Kein Laufwerk untersttzt die Audio Erweiterungen
  - 3: Nicht genug Speicher um TOC zu lesen
  - 4: CD wurde gewechselt bzw. keine CD eingelegt
*/

int re_init_CDAudio( void)
{
   Audio_Status stat_audio;

   /* Lesen des Inhaltsverzeichnis */
   titles= get_TOC();

   /* Ende des letzten Playrequests merken ! */

   stat_audio= Read_Audio_Status();
   end_play= RED2HSG( stat_audio.end);
   return( titles);
}

int init_CDAudio( void)
{
   union REGS   inregs, outregs;
   struct SREGS sreg;
   int          i;
   int          ndrives;                        /* Anzahl der CD Laufwerke */
   BYTE         logical_drives[ 26]; /* Feld der logischen Laufwerksbzeichner */
   DWORD        L_Stat;

   if(( index= ( CD_index *)malloc( sizeof( CD_index)))== NULL)
   {
      ErrorMsg( KEIN_SPEICHER);
      return( NOMEMORY);
   }

   /* Test MSCDEX installiert      */

   inregs.x.ax= 0x1500;                           /* Anzahl CD Laufwerke ? */
   inregs.x.bx= 0;                              /* Initial kein Laufwerk ! */
   int86( 0x2F, &inregs, &outregs);           /* Aufruf Multiplexinterrupt */
   if( outregs.x.bx== 0)                      /* Kein Laufwerk vorhanden ? */
      return( NODRIVE);                          /* Abbruch mit Fehlercode */

   ndrives= outregs.x.bx;
   inregs.x.ax= 0x150d;       /* Anfrage nach logischen Laufwerkskennungen */
   sreg.es= FP_SEG( logical_drives);
   inregs.x.bx= FP_OFF( logical_drives);
   int86x( 0x2F, &inregs, &outregs, &sreg);

   /* berprfung, ob ein Laufwerk die Audio Extension untersttzt ! */

   for( i= 0; i< ndrives; i++)
   {
      if(( get_Status( logical_drives[i])& DATA_AND_AUDIO))
      {
	 audio_drive= logical_drives[ i];
	 break;
      }
   }

   if( i== ndrives)
      return( NOAUDIO);

   get_Header();

   /* Kann auf das Laufwerk zugegriffen werden ? */

   if((( L_Stat= get_Status( audio_drive))& DOOR_OPEN)|| ( L_Stat& NO_CD_INSERT))
      return( NOTREADY);

   return( re_init_CDAudio());
}

/* gibt den mit init_CDAudio() belegten Speicher wieder frei */

void Free_CD_Res( void)
{
   if( index!= NULL)
   {
      free( index);
      index= NULL;
   }
}

/* Ermittelt Anzahl der Titel der CD */

BYTE get_Titles( void)
{
   return( titles);
}

/* Liefert die Lnge eines Stckes in RED Book Format mm:ss.ff */

CD_Addr get_len( BYTE tno)
{
   return( ( *index)[ tno].delta);
}

/* Liefert die aktuelle Titelnummer als Integerwert (1-99) */

BYTE get_actual_track( void)
{
   /* Q Kanal Lesen */

   qinfo= read_QChannel();

   /* Umwandlung BCD -> Integer */

   return(( qinfo.tno>> 4)* 10+ ( qinfo.tno& 0x0F));
}

/* Liefert Zeitinformationen in der Q Kanal Struktur */

QChannel_Info get_time_in_track( void)
{
   /* Q Kanal Lesen */

   qinfo= read_QChannel();

   /* Gib alles zurck */

   return( qinfo);
}

BYTE get_audio_drive( void)
{
   return( audio_drive);
}

WORD CD_length_in_Sec( void)
{
   return( ( *index)[ 0].frames/ 75);
}

WORD CD_length_in_Frames( void)
{
   return( ( *index)[ 0].frames);
}

WORD Song_Begin_in_Sec( int Song)
{
   return( ( *index)[ Song].start.TIME.frame/ 75+ ( *index)[ Song].start.TIME.second+ ( *index)[ Song].start.TIME.minute* 60);
}