/*  CRIT_ERR.C  Critical error handler
 *  Copyright (C) 1991-1998  Felix Ritter
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <dos.h>
#include <conio.h>
#include <graphics.h>
#include <ctype.h>
#include "pal_op.h"
#include "filemgr.h"
#include "mouse_op.h"

extern WORD MouseStat( void);

int error_win( char *msg)
{
   struct textsettingstype text;
   void *old_maus_cursor= last_maus_cursor;
   int retval= -1, xref, textref, color, Taste;
   
   color= getcolor();
   gettextsettings( &text);
   settextjustify( LEFT_TEXT, text.vert);
   textref= ( strlen( msg)<< 2); 
   ( textref< 160) ? ( xref= 180) : ( xref= textref+ 20);
   MouseArt( maus_pfeil);
   ShowMouse( AUS);
   SCR_move( 300- xref, 200, ( xref<< 1)+ 1, 104, 300- xref, 485);
   PutPaper( 300- xref, 200, 300+ xref, 300, EGA_LIGHTRED, AN, AUS, "Hardwarefehler");
   setfillstyle( SOLID_FILL, EGA_LIGHTGRAY);
   bar( 300- xref+ 12, 238, 300+ xref- 12, 254);
   DrawTal( 300- xref+ 12, 238, 300+ xref- 12, 254);
   setcolor( EGA_BLACK);
   outtextxy( 300- textref, 243, msg);
   Button( 135, 265, 235, 285, "Abbrechen", 1);
   Button( 250, 265, 350, 285, "Wiederholen", 1);
   Button( 365, 265, 465, 285, "Ignorieren", 1);
   ShowMouse( AN);
   showclock= AUS;
   do
   {
      Taste= 0;
      if(( MouseStat()!= NOTHING)|| (( Taste= kbhit())!= 0))
      {
	 if( Taste)
	 {
	    if(( Taste= getch())== 0)
	       getch();
	 }
	 if((( MStat.x>= 135)&& ( MStat.x<= 235)&& ( MStat.y>= 265)&& ( MStat.y<= 285))|| ( Taste== 'a'))
	    retval= _HARDERR_FAIL;
	 else
	 {
	    if((( MStat.x>= 250)&& ( MStat.x<= 350)&& ( MStat.y>= 265)&& ( MStat.y<= 285))|| ( Taste== 'w'))
	       retval= _HARDERR_RETRY;
	    else
	    {
	       if((( MStat.x>= 365)&& ( MStat.x<= 465)&& ( MStat.y>= 265)&& ( MStat.y<= 285))|| ( Taste== 'i'))
		  retval= _HARDERR_IGNORE;
	    }
	 }
	 while( MouseStat()!= NOTHING)
	    ;
      }
   }while( retval== -1);
   showclock= AN;
   ShowMouse( AUS);
   SCR_move( 300- xref, 485, ( xref<< 1)- 7, 104, 300- xref, 200);
   ShowMouse( AN);
   MouseArt( old_maus_cursor);
   settextjustify( text.horiz, text.vert);
   setcolor( color);
   return( retval);
}   

#pragma warn -par /* WARNUNG: 'Parameter 'parameter' is never used' unterdrcken */

void far _CritHandler( WORD deverr, WORD errval, WORD far *devhdr)
{
   char msg[ 100];
   char *err_msg[]= { "Diskette ist schreibgeschtzt",
		      "unbekannte Einheit",
		      "Laufwerk nicht bereit",
		      "unbekanntes Kommando",
		      "Datenfehler (CRC)",
		      "falsche Lnge (Request-Struktur)",
		      "Suchfehler",
		      "unbekannter Mediumstyp",
		      "Sektor nicht gefunden",
		      "Drucker hat kein Papier",
		      "Schreibfehler",
		      "Lesefehler",
		      "allgemeiner Fehler",
		      "unbekannter Fehler",
		      "unbekannter Fehler",
		      "ungltiger Diskettenwechsel" };

   if( deverr& 0x8000)
      strcpy( msg, "Gertefehler");
   else
      sprintf( msg, "Fehler bei Laufwerk %c: '%s'", 'A'+ ( deverr& 0x00FF), err_msg[ errval& 0x00FF]);
   _hardresume( error_win( msg));
}

#pragma warn +par /* WARNUNG: 'Parameter 'parameter' is never used' erlauben */

static BOOL isBreakActive= FALSE;

int BreakHandler( void)
{
   gotoxy( 1, 1);

   if( !isBreakActive)
   {
      isBreakActive= TRUE;

      if( SaveSysDial()== 0)                                        /* OK */
      {
	 Free_All_Resourcen();
	 puts( "Programm wurde abnormal beendet !\n");
	 exit( 255);
      }

      isBreakActive= FALSE;
   }
   else
      Hinweis( "BREAK wurde bereits erkannt");

   return( 1);
}
