/*  DISK_OP.C  Disk operations
 *  Copyright (C) 1991-1998  Felix Ritter
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <dos.h>
#include <graphics.h>
#include <stdlib.h>
#include <conio.h>
#include <io.h>
#include <fcntl.h>
#include <process.h>
#include <sys\stat.h>
#include <string.h>
#include <time.h>
#include <dir.h>
#include <bios.h>
#include <math.h>
#include <alloc.h>
#include "pal_op.h"
#include "filemgr.h"
#include "mouse_op.h"
#include "cd_op.h"
#include "xms.h"
#include "version.h"

#define MAXVERSUCHE   5                         /* Maximale Anzahl Versuche */
#define FAULT         0
#define OK            1
#define GROSSE_ANZ    0
#define KLEINE_ANZ    1
#define _DISK_PREPARE 0x18
#define FORMATIEREN   0
#define UEBERPRUEFEN  1
#define SCHREIBEN     2
#define LESEN         3
#define FERTIG        4
#define DEFEKT        5
#define FREI          6
#define IDENTISCH     7
#define VERSCHIEDEN   8

extern void far _CritHandler();

int DriveSize( int LW)                                     /* 0=A, 1=B, ... */
{
   RP.r_ax= 0x0800;
   RP.r_dx= LW;
   intr( DISK_INT, &RP);
   if( RP.r_flags& CARRY_FLAG)          /* Fkt. nicht vorhanden -> XT-360KB */
      return( DD_525);
   else
      return( LO( RP.r_bx));
}

int ExistLaufwerk( int LW)                                 /* 0=A, 1=B, ... */
{
   RP.r_ax= 0x4408;
   RP.r_bx= LW+ 1;
   intr( DOS_INT, &RP);
   if( RP.r_ax!= 15)
   {
      if( !((( LW== 0)|| ( LW== 1))&& ( DriveSize( LW)== 0))) /* A: oder B: */
	 return( 0);
   }
   return( -1);
}

int Laufwerksart( int LW)                                  /* 0=A, 1=B, ... */
{
   /*
      0= FLOPPY_525
      1= FLOPPY_35
      2= NETZWERK
      3= FESTPLATTE
      4= DOUBLEDENSITY
      5= RAMDISK
      6= CD_ROM
     -1= NO_DRIVE -> Laufwerk konnte nicht erkannt werden (existiert nicht)
   */

   char *dpb_ptr, buf[ 512];

   RP.r_ax= 0x4409;
   RP.r_bx= LW+ 1;
   RP.r_dx= 0x0000;
   intr( DOS_INT, &RP);
   if( RP.r_flags& CARRY_FLAG)
      return( NO_DRIVE);
   if( RP.r_dx& 0x1000)
   {
      RP.r_ax= 0x150B;
      RP.r_bx= 0;
      RP.r_cx= LW;
      intr( MULTIPLEX_INT, &RP);

      if(( RP.r_bx== 0xADAD)&& ( RP.r_ax!= 0))
	 return( CD_ROM);
      else
	 return( NETZWERK);
   }
   RP.r_ax= 0x4408;
   intr( DOS_INT, &RP);
   if( RP.r_flags& CARRY_FLAG)
   {
      if( RP.r_ax== 1)
      {
	 if( !absread( LW, 1, 0, buf))
	 {
	    if( !strncmp( &buf[ 3], "D_D_VOL", 7))
	       return( DOUBLEDENSITY);
	 }
      }
      return( NO_DRIVE);
   }
   if( RP.r_ax== 0)                                    /* Diskettenlaufwerk */
   {
      switch( DriveSize( LW))
      {
	 case DD_525:
	 case HD_525:
	    return( FLOPPY_525);
	 default:
	    return( FLOPPY_35);
      }
   }
   RP.r_ax= 0x3200;
   RP.r_dx= LW+ 1;
   intr( DOS_INT, &RP);
   dpb_ptr= MK_FP( RP.r_ds, RP.r_bx);
   if( *( dpb_ptr+ 0x04)== 0)
      return( RAMDISK);
   else
      return( FESTPLATTE);
}

#pragma warn -par

void _Crit_fault_LW( WORD deverr, WORD errval, WORD far *devhdr)
{
   hardretn( 'A'+ ( deverr& 0x00FF));
}

#pragma warn +par

int Get_phys_LW( int LW, char *phystab)
{
   /*
      LW - 0=A, 1=B, ...
      ret 0-> virt== phys
      ret 1-> virt!= phys
   */

   int retlw;
   char lw[]= "X:\\";

   lw[ 0]= LW+ 'A';         /* virtuelle Laufwerke in physikalische wandeln */
   _harderr( _Crit_fault_LW);
   if(( retlw= access( lw, 0))!= 0)
   {
      _harderr( _CritHandler);
      sprintf( phystab, "%c:", retlw);
      return( 1);
   }
   RP.r_ax= 0x6000;
   RP.r_ds= FP_SEG( lw);
   RP.r_si= FP_OFF( lw);
   RP.r_es= FP_SEG( phystab);
   RP.r_di= FP_OFF( phystab);
   intr( DOS_INT, &RP);
   _harderr( _CritHandler);
   if( stricmp( lw, phystab))
      return( 1);
   return( 0);
}

#pragma warn -par

void _CritDummy( WORD deverr, WORD errval, WORD far *devhdr)
{
   _hardresume( _HARDERR_FAIL);
}

#pragma warn +par

int DriveOK( int LW)                                       /* 0=A, 1=B, ... */
{
   int ret_val;
   char FLOPPY_lw[]= "X:\\";

   MouseArt( maus_sanduhr);
   switch( Laufwerksart( LW))
   {
      case FLOPPY_525:
      case FLOPPY_35:
	 FLOPPY_lw[ 0]= LW+ 'A';
	 _harderr( _CritDummy);
	 ret_val= access( FLOPPY_lw, 0);
	 _harderr( _CritHandler);
	 break;
      case CD_ROM:
	 (( init_CDAudio()> 0)&& ( get_track_info( 1)& DATA)) ? ( ret_val= 0) : ( ret_val= -1);
	 Free_CD_Res();
	 break;
      default:
	 ret_val= ExistLaufwerk( LW);
	 break;
   }
   MouseArt( maus_pfeil);
   return( ret_val);
}

int DiskReady( int LW)  		                   /* 0=A, 1=B, ... */
{
   int ret_val;
   char buffer[ 40];

   sprintf( buffer, "Laufwerk %c: wird gelesen ...", LW+ 'A');
   PrintStatus( buffer);
   if(( ret_val= DriveOK( LW))!= 0)
   {
      sprintf( buffer, "Fehler beim Lesen von Laufwerk %c:", LW+ 'A');
      ErrorMsg( buffer);
   }
   else
      ClearStatus();
   return( ret_val);
}

void ShowDrive( int x, int y, int art)
{
   setcolor( EGA_BLACK);
   setfillstyle( SOLID_FILL, EGA_LIGHTGRAY);
   bar( x+ 1, y+ 1, x+ 19, y+ 10);
   rectangle( x, y, x+ 20, y+ 11);
   setcolor( EGA_WHITE);
   line( x+ 1, y+ 1, x+ 19, y+ 1);
   line( x+ 1, y+ 1, x+ 1, y+ 10);
   setcolor( EGA_DARKGRAY);
   line( x+ 2, y+ 10, x+ 19, y+ 10);
   line( x+ 19, y+ 10, x+ 19, y+ 1);
   setcolor( EGA_BLACK);
   switch( art)
   {
      case RAMDISK:
	 /* R */
	 line( x+ 3, y+ 3, x+ 3, y+ 8);
	 line( x+ 4, y+ 3, x+ 5, y+ 3);
	 line( x+ 4, y+ 6, x+ 5, y+ 6);
	 line( x+ 6, y+ 4, x+ 6, y+ 5);
	 line( x+ 6, y+ 7, x+ 6, y+ 8);
	 /* A */
	 line( x+ 8, y+ 4, x+ 8, y+ 8);
	 line( x+ 11, y+ 4, x+ 11, y+ 8);
	 line( x+ 9, y+ 3, x+ 10, y+ 3);
	 line( x+ 9, y+ 6, x+ 10, y+ 6);
	 /* M */
         line( x+ 13, y+ 3, x+ 13, y+ 8);
	 putpixel( x+ 14, y+ 4, EGA_BLACK);
	 line( x+ 15, y+ 5, x+ 15, y+ 8);
	 putpixel( x+ 16, y+ 4, EGA_BLACK);
         line( x+ 17, y+ 3, x+ 17, y+ 8);
	 break;
      case FLOPPY_525:
	 putpixel( x+ 6, y+ 4, EGA_BLACK);
	 line( x+ 11, y+ 4, x+ 12, y+ 4);
	 line( x+  5, y+ 5, x+  6, y+ 5);
	 line( x+  8, y+ 5, x+ 13, y+ 5);
	 line( x+  3, y+ 6, x+ 17, y+ 6);
	 line( x+  6, y+ 7, x+ 12, y+ 7);
	 setcolor( EGA_LIGHTRED);
	 line( x+ 15, y+ 3, x+ 17, y+ 3);
	 line( x+ 15, y+ 4, x+ 17, y+ 4);
	 setcolor( EGA_DARKGRAY);
	 line( x+ 6, y+ 3, x+ 12, y+ 3);
	 line( x+ 6, y+ 8, x+ 12, y+ 8);
	 break;
      case FLOPPY_35:
	 line( x+  7, y+ 4, x+ 13, y+ 4);
	 line( x+  3, y+ 5, x+ 17, y+ 5);
	 line( x+  7, y+ 6, x+ 13, y+ 6);
	 line( x+ 16, y+ 7, x+ 17, y+ 7);
	 line( x+ 16, y+ 8, x+ 17, y+ 8);
	 setcolor( EGA_LIGHTRED);
	 line( x+ 3, y+ 8, x+ 4, y+ 8);
	 setcolor( EGA_DARKGRAY);
	 line( x+ 7, y+ 3, x+ 13, y+ 3);
	 line( x+ 7, y+ 7, x+ 13, y+ 7);
	 line( x+ 7, y+ 8, x+ 13, y+ 8);
	 break;
      case NETZWERK:
	 line( x+ 3, y+ 4, x+ 8, y+ 4);
	 line( x+ 12, y+ 4, x+ 17, y+ 4);
	 line( x+ 8, y+ 7, x+ 12, y+ 7);
	 line( x+ 9, y+ 5, x+ 10, y+ 6);
	 putpixel( x+ 11, y+ 5, EGA_BLACK);
	 setcolor( EGA_DARKGRAY);
	 line( x+ 8, y+ 8, x+ 12, y+ 8);
	 break;
      case DOUBLEDENSITY:
	 line( x+ 11, y+ 3, x+ 11, y+ 8);
	 line( x+ 13, y+ 4, x+ 13, y+ 7);
	 putpixel( x+ 12, y+ 3, EGA_BLACK);
	 putpixel( x+ 12, y+ 8, EGA_BLACK);
	 line( x+ 15, y+ 3, x+ 15, y+ 8);
	 line( x+ 17, y+ 4, x+ 17, y+ 7);
	 putpixel( x+ 16, y+ 3, EGA_BLACK);
	 putpixel( x+ 16, y+ 8, EGA_BLACK);
	 line( x+ 3, y+ 4, x+ 9, y+ 4);
	 line( x+ 3, y+ 6, x+ 9, y+ 6);
	 setcolor( EGA_LIGHTGREEN);
	 line( x+ 3, y+ 8, x+ 4, y+ 8);
	 break;
      case CD_ROM:
	 line( x+  3, y+  3, x+ 17, y+  3);
	 line( x+  3, y+  4, x+  4, y+  4);
	 line( x+  9, y+  4, x+ 11, y+  4);
	 line( x+ 16, y+  4, x+ 17, y+  4);
	 arc(  x+ 10, y+  1, 200, 340, 7);
	 line( x+  3, y+  7, x+  4, y+  7);
	 line( x+  3, y+  8, x+  4, y+  8);
	 setcolor( EGA_WHITE);
	 line( x+  8, y+  5, x+  7, y+  6);
	 line( x+ 12, y+  4, x+ 14, y+  6);
	 setcolor( EGA_DARKGRAY);
	 line( x+  8, y+  4, x+  6, y+  6);
	 putpixel( x+  6, y+  5, EGA_DARKGRAY);
	 line( x+ 12, y+  5, x+ 12, y+  7);
	 putpixel( x+ 13, y+  6, EGA_DARKGRAY);
	 setcolor( EGA_LIGHTGREEN);
	 line( x+ 16, y+ 8, x+ 17, y+ 8);
	 break;
      default:                                                /* Festplatte */
	 line( x+ 3, y+ 4, x+ 17, y+ 4);
	 line( x+ 3, y+ 6, x+ 17, y+ 6);
	 setcolor( EGA_LIGHTGREEN);
	 line( x+ 3, y+ 8, x+ 4, y+ 8);
	 break;
   }
}

int Disk_Change( int LW)                                        /* 0=A, 1=B */
{
   int ret_val= 0, status, Zeit, X= 250, Y= 230;
   BYTE Dummy[ 512];
   WORD mauspos[]= { BUTTON| FRAME| KEY| DEFBUTTON,  54, 222, 114, 139, RETURN,
		     BUTTON| FRAME| KEY,              5,  27,   5,  21, ESC,
		     MOVEWINDOW };
   MAUSStruct MS= { DEFAULT, DEFAULT, 278, 150, 3, INIT, NULL, AUS};

   MS.x= &X;
   MS.y= &Y;
   MS.mauspos= mauspos;
   PCX_Window( MS.x, MS.y, PCX_INFO, &MS.sa, SHADOW);
   sprintf( Dummy, "%c: aus.", LW+ 'A');
   ShowMouse( AUS);
   setcolor( EGA_BLACK);
   outtextxy( *MS.x+  75, *MS.y+ 50, "Wechseln Sie bitte die");
   outtextxy( *MS.x+  75, *MS.y+ 63, "Diskette in Laufwerk");
   outtextxy( *MS.x+ 100, *MS.y+ 76, Dummy);
   ShowDrive( *MS.x+ 75, *MS.y+ 73, Laufwerksart( LW));
   ShowMouse( AN);
   HinweisSound();
   RP.r_ax= 0x1500;
   RP.r_dx= LW;
   intr( DISK_INT, &RP);
   if( !( RP.r_flags& CARRY_FLAG)&& ( HI( RP.r_ax)== 2))  /* LW erkennt Diskwechsel */
   {
      do
      {
	 if(( status= __CheckMousepos( &MS))== -1)
	 {
	    RP.r_ax= 0x1600;
	    RP.r_dx= LW;
	    intr( DISK_INT, &RP);
	 }
      }while( !HI( RP.r_ax)&& ( status== -1));  /* Diskette nicht aus LW entfernt */
      if( status== -1)                              /* Kein Button bettigt */
      {
	 do
	 {
	    Zeit= 60;
	    while((( status= __CheckMousepos( &MS))== -1)&& ( Zeit--!= 0))
	       delay( 10);
	    if( status== -1)
	    {
	       RP.r_ax= 0x0201;
	       RP.r_dx= LW;
	       RP.r_cx= 0x0001;
	       RP.r_es= FP_SEG( Dummy);
	       RP.r_bx= FP_OFF( Dummy);
	       intr( DISK_INT, &RP);
	    }
	 }while((( RP.r_flags& CARRY_FLAG)&& ( HI( RP.r_ax)== 0x80))&& ( status== -1));
      }
      if( status!= -1)
	 ret_val= status;
   }
   else
   {
      while(( ret_val= __CheckMousepos( &MS))== -1)
	 ;
   }
   ShowMouse( AUS);
   BigScreenRestore( &MS.sa, *MS.x, *MS.y);
   ShowMouse( AN);
   return( ret_val);                           /* 0- Diskwechsel, 1-Abbruch */
}

BOOL is_CASE( int lw, WORD geg_lw, WORD modus)
{
   BOOL Flag= 0;

   switch( modus& LW_AUSWAHL_CODE)
   {
      case DRIVES_WITH_FORMAT:
	 if( !( Laufwerksart( lw)& FLOPPY_CODE)&& !LW_work_Format( DriveSize( lw), geg_lw))
	    Flag= 1;
	 break;
      case SPEZ_DRIVES:
	 if(( ( WORD)0x0001<< Laufwerksart( lw))& geg_lw)
	    Flag= 1;
	 break;
      default:
	 Flag= 1;
	 break;
   }
   return( Flag);
}

int LW_Anwahl( int *x, int *y, BYTE *ret_lw_array, char *msg, WORD geg_lw, WORD modus)
{
   /* MODUS:

      ALL_DRIVES         - alle vorhandenen Laufwerke werden angezeigt
      DRIVES_WITH_FORMAT - alle Laufwerke die dieses Format verarbeiten werden angezeigt
      SPEZ_DRIVES        - alle Laufwerke die angegeben sind

      in 'retlw' knnen schon Voreinstellungen gespeichert sein
   */

   int lw, index, xlw, ylw, status;
   char lw_zeichen[ MAXDRIVE], LW[ 26]= { 0};
   void *arg_ptr[ 26];
   WORD mauspos[ 117]= { BUTTON| FRAME| KEY,   5,  27,   5,  21, ESC,
			 BUTTON| FRAME| KEY,  25, 305, 166, 191, RETURN };
   MAUSStruct MS= { DEFAULT, DEFAULT, 331, 204, DEFAULT, INIT, NULL, AUS};

   MS.x= x;
   MS.y= y;
   MS.arg_ptr= arg_ptr;
   MS.mauspos= mauspos;
   PCX_Window( MS.x, MS.y, PCX_LWANWAHL, &MS.sa, SHADOW);
   ShowMouse( AUS);
   for( lw= 0, index= 12, xlw= 11, ylw= 65, MS.spotanz= 3; lw< 26; lw++, xlw+= 24)
   {
      if( xlw> 299)
      {
	 ylw+= 47;
	 xlw= 11;
      }
      if( !ExistLaufwerk( lw))                        /* Laufwerk vorhanden */
      {
	 if( is_CASE( lw, geg_lw, modus))
	 {
	    ShowDrive( *MS.x+ xlw, *MS.y+ ylw, Laufwerksart( lw));
	    sprintf( lw_zeichen, "%c:", lw+ 'A');
	    setcolor( EGA_BLACK);
	    outtextxy( *MS.x+ xlw+ 4, *MS.y+ ylw+ 15, lw_zeichen);
	    mauspos[ index++]= CHECKBOX| FRAME| KEY;
	    mauspos[ index++]= xlw+ 4;
	    mauspos[ index++]= ylw+ 27;
	    mauspos[ index++]= lw+ 'a';
	    arg_ptr[ MS.spotanz++ - 3]= ret_lw_array+ lw;
	 }
      }
   }
   ShowMouse( AN);
   PrintStatus_to_Klick( msg);
   mauspos[ index]= MOVEWINDOW;
   mauspos[ 12]|= DEFBUTTON;
   while((( status= __CheckMousepos( &MS))== -1)|| ( status>= 2))
      ;
   ClearStatus();
   ShowMouse( AUS);
   BigScreenRestore( &MS.sa, *MS.x, *MS.y);
   ShowMouse( AN);
   if( status== 1)                                                /* Return */
   {
      for( lw= 0, index= 0; lw< 26; lw++)
	 if( *( ret_lw_array+ lw)== AN)
	    LW[ index++]= lw;
      memcpy( ret_lw_array, LW, index);
   }
   else                                                          /* Abbruch */
      index= -1;
   return( index);                                  /* Anzahl der Laufwerke */
}

int LW_Auswahl( int *x, int *y, char *msg, WORD geg_lw, WORD modus)
{
   /* MODUS:

      ALL_DRIVES         - alle vorhandenen Laufwerke werden angezeigt
      DRIVES_WITH_FORMAT - alle Laufwerke die dieses Format verarbeiten werden angezeigt
      SPEZ_DRIVES        - alle Laufwerke die angegeben sind

      |DRIVE_READY       - es wird getestet, ob die Laufwerke bereit sind
   */

   int lw, index, xlw, ylw, status;
   char lw_zeichen[ MAXDRIVE], LW[ 26];
   BOOL Flag;
   WORD mauspos[ 163]= { BUTTON| FRAME| KEY,   5,  27,   5, 21, ESC };
   MAUSStruct MS= { DEFAULT, DEFAULT, 331, 126, DEFAULT, INIT, NULL, AUS};

   MS.x= x;
   MS.y= y;
   MS.mauspos= mauspos;
   PCX_Window( MS.x, MS.y, PCX_LWAUSWAHL, &MS.sa, SHADOW);
   ShowMouse( AUS);
   for( lw= 0, index= 6, xlw= 11, ylw= 65, MS.spotanz= 2; lw< 26; lw++, xlw+= 24)
   {
      if( xlw> 299)
      {
	 ylw+= 27;
	 xlw= 11;
      }
      if( !ExistLaufwerk( lw))                        /* Laufwerk vorhanden */
      {
	 if( is_CASE( lw, geg_lw, modus))
	 {
	    ShowDrive( *MS.x+ xlw, *MS.y+ ylw, Laufwerksart( lw));
	    sprintf( lw_zeichen, "%c:", lw+ 'A');
	    setcolor( EGA_BLACK);
	    outtextxy( *MS.x+ xlw+ 4, *MS.y+ ylw+ 15, lw_zeichen);
	    mauspos[ index++]= BUTTON2| FRAME| KEY;
	    mauspos[ index++]= xlw;
	    mauspos[ index++]= xlw+ 20;
	    mauspos[ index++]= ylw;
	    mauspos[ index++]= ylw+ 11;
	    mauspos[ index++]= lw+ 'a';
	    LW[ MS.spotanz++ - 2]= lw;
	 }
      }
   }
   ShowMouse( AN);
   PrintStatus_to_Klick( msg);
   mauspos[ index]= MOVEWINDOW;
   mauspos[ 6]|= DEFBUTTON;
   while(( status= __CheckMousepos( &MS))== -1)
      ;
   ClearStatus();
   ShowMouse( AUS);
   BigScreenRestore( &MS.sa, *MS.x, *MS.y);
   ShowMouse( AN);
   if( !status)                                                      /* ESC */
   {
      return( -1);
   }
   if( modus& DRIVE_READY)
   {
      if( DiskReady( LW[ status- 1]))              /* Laufwerk nicht bereit */
	 return( -2);
   }
   return( LW[ status- 1]);                                /* 0=A, 1=B, ... */
}

void Block( int X, int Y, int x, int y, BYTE code)
{
   int code_color[]= { EGA_LIGHTRED,
		       EGA_BLACK,
		       EGA_DARKGRAY,
		       EGA_RED };

   setfillstyle( SOLID_FILL, code_color[ code]);
   if((( x- X)== 22)|| (( y- Y)== 31))
   {
      rectangle( x, y, x+ 7, y+ 7);
   }
   else
   {
      line( x+ 1, y+ 7, x+ 7, y+ 7);
      line( x+ 7, y+ 6, x+ 7, y+ 1);
   }
   bar( x+ 1, y+ 1, x+ 6, y+ 6);
}

int sort_function( unsigned *a, unsigned *b)
{
   if( *a< *b)
      return( 1);
   if( *a> *b)
      return( -1);
   else
      return( 0);
}

void _show_FAT( int X, int Y, BYTE lw)
{
   typedef int ( *fcmp) (const void *, const void *);
   struct fatinfo diskinfo;
   char tmp_array[ 5];
   BYTE *FAT_ptr;
   WORD arr[ 4], firstfatsec, x, y, fatbits, anzausgew, cluster_pro_block,
	code, frei= 0, reserviert= 0, schlecht= 0, belegt= 0, flag= 0;
   int clusterz= 0, clus;

   getfat( lw+ 1, &diskinfo);
   if(( FAT_ptr= malloc( 512))!= NULL)
   {
      absread( lw, 1, 0L, FAT_ptr);
      cluster_pro_block= ( ( DWORD)diskinfo.fi_nclus+ 3359)/ 3360;   /* Blcke maximal */
      sprintf( tmp_array, "%2d", cluster_pro_block);
      ShowMouse( AUS);
      setcolor( EGA_BLACK);
      outtextxy( X+ 277, Y+ 362, tmp_array);
      firstfatsec= *( WORD *)( FAT_ptr+ 0x0E);
      ( diskinfo.fi_nclus> 4079) ? ( fatbits= 16) : ( fatbits= 12);
      absread( lw, 1, firstfatsec++, FAT_ptr);
      anzausgew= ( fatbits>> 2);
      for( y= Y+ 31; ( y<= Y+ 320)&& ( clusterz<= diskinfo.fi_nclus); y+= 7)
      {
	 for( x= X+ 22; ( x<= X+ 577)&& ( clusterz<= diskinfo.fi_nclus); x+= 7)
	 {
	    for( clus= 0; ( clus< cluster_pro_block)&& ( clusterz<= diskinfo.fi_nclus); clus++)
	    {
	       if( anzausgew>= diskinfo.fi_bysec)
	       {
		  absread( lw, 1, firstfatsec++, FAT_ptr);
		  anzausgew= 0;
	       }
	       if( fatbits== 16)
	       {
		  code= *( WORD *)( FAT_ptr+ anzausgew);
		  anzausgew+= 2;
	       }
	       else
	       {
		  if( !flag)
		  {
		     code= *( FAT_ptr+ anzausgew++);
		     if( anzausgew>= diskinfo.fi_bysec)
		     {
			absread( lw, 1, firstfatsec++, FAT_ptr);
			anzausgew= 0;
		     }
		     code+= ( WORD)( *( FAT_ptr+ anzausgew)& 0x0F)<< 8;
		     flag= 1;
		  }
		  else
		  {
		     code= (( *( FAT_ptr+ anzausgew++)& 0xF0)>> 4);
		     if( anzausgew>= diskinfo.fi_bysec)
		     {
			absread( lw, 1, firstfatsec++, FAT_ptr);
			anzausgew= 0;
		     }
		     code+= ( ( ( WORD)( *( FAT_ptr+ anzausgew)& 0x0F)<< 4)+ ( ( WORD)( *( FAT_ptr+ anzausgew)& 0xF0)<< 4));
		     flag= 0;
		     anzausgew++;
		  }
	       }
	       if( !code)
		  frei++;
	       else
	       {
		  if( fatbits== 16)
		  {
		     if(( code>= 0xFFF0)&& ( code<= 0xFFF6))
			reserviert++;
		     else
			if( code== 0xFFF7)
			   schlecht++;
			else
			   belegt++;
		  }
		  else
		  {
		     if(( code>= 0xFF0)&& ( code<= 0xFF6))
			reserviert++;
		     else
			if( code== 0xFF7)
			   schlecht++;
			else
			   belegt++;
		  }
	       }
	       clusterz++;
	    }
	    arr[ 0]= frei;
	    arr[ 1]= reserviert;
	    arr[ 2]= schlecht;
	    arr[ 3]= belegt;
	    qsort( ( void *)arr, 4, sizeof( int), ( fcmp)sort_function);
	    if( arr[ 0]== frei)
	       code= 0;
	    if( arr[ 0]== reserviert)
	       code= 1;
	    if( arr[ 0]== schlecht)
	       code= 2;
	    if( arr[ 0]== belegt)
	       code= 3;
	    Block( X, Y, x, y, code);
	    frei= reserviert= schlecht= belegt= 0;
	 }
      }
      ShowMouse( AN);
      free( FAT_ptr);
   }
   else
      ErrorMsg( KEIN_SPEICHER);
}

void ShowFAT( void)
{
   int ret= 0, lw, x_lw= 120, y_lw= 150;
   char tmp_array[ MAXDRIVE];
   WORD mauspos[]= { BUTTON|      FRAME| KEY,              5,  27,   5,  21, ESC,
		     BUTTON|      FRAME| KEY| DEFBUTTON, 448, 503, 348, 387, RETURN,
		     BUTTON|      FRAME| KEY,            507, 562, 348, 387, 'l',
		     MOVEWINDOW };
   MAUSStruct MS= { DEFAULT, DEFAULT, 605, 410, 4, INIT, NULL, AUS};

   if(( lw= LW_Auswahl( &x_lw, &y_lw, "", A_FLOPPY_525| A_FLOPPY_35| A_FESTPLATTE| A_DOUBLEDENSITY| A_RAMDISK, SPEZ_DRIVES| DRIVE_READY))>= 0)
   {
      MS.x= &X_fatinfo;
      MS.y= &Y_fatinfo;
      MS.mauspos= mauspos;
      PCX_Window( MS.x, MS.y, PCX_FATINFO, &MS.sa, SHADOW);
      do
      {
	 ShowMouse( AUS);
	 ShowDrive( *MS.x+ 383, *MS.y+ 364, Laufwerksart( lw));
	 setcolor( EGA_BLACK);
	 ClearTextN( *MS.x+ 408, *MS.y+ 367, 2);
	 sprintf( tmp_array, "%c:", lw+ 'A');
	 outtextxy( *MS.x+ 408, *MS.y+ 367, tmp_array);
	 ShowMouse( AN);
	 _show_FAT( *MS.x, *MS.y, lw);
	 ret= 0;
	 do
	 {
	    switch( __CheckMousepos( &MS))
	    {
	       case 0:                                               /* ESC */
	       case 1:                                            /* Return */
		  ret= ABBRUCH;
		  break;
	       case 2:                                        /* LW-Auswahl */
		  if(( lw= LW_Auswahl( &x_lw, &y_lw, "", A_FLOPPY_525| A_FLOPPY_35| A_FESTPLATTE| A_DOUBLEDENSITY, SPEZ_DRIVES| DRIVE_READY))>= 0)
		  {
		     ShowMouse( AUS);
		     ClearTextN( *MS.x+ 275, *MS.y+ 362, 2);
		     setfillstyle( SOLID_FILL, EGA_LIGHTGRAY);
		     bar( *MS.x+ 22, *MS.y+ 31, *MS.x+ 582, *MS.y+ 325);
		     ShowMouse( AN);
		     ret= NOCHMAL;
		  }
		  break;
	    }
	 }while( !ret);
      }while( ret!= ABBRUCH);
      ShowMouse( AUS);
      BigScreenRestore( &MS.sa, *MS.x, *MS.y);
      ShowMouse( AN);
   }
}

void KreisDiagramm( int x, int y, int prozent, int prozentfarbe, int farbe, int randfarbe, char *format)
{
   setcolor( randfarbe);
   ShowMouse( AUS);
   setfillstyle( SOLID_FILL, farbe);
   fillellipse( x, y, 60, 20);
   setfillstyle( SOLID_FILL, prozentfarbe);
   sector( x, y, 0, prozent* 3.6, 60, 20);
   ellipse( x, y+7, 180, 360, 60, 20);
   line( x-60, y+7, x-60, y);
   line( x+60, y+7, x+60, y);
   setfillstyle( SOLID_FILL, randfarbe);
   floodfill( x, y+24, randfarbe);
   line( x+50, y, x+70, y-20);
   line( x+70, y-20, x+100, y-20);
   setcolor( EGA_BLACK);
   outtextxy( x+105, y-23, format);
   ShowMouse( AN);
}

char *Tausender_Gruppen( char *ret_Zahl, unsigned long Zahl)
{
   char *end_ptr, *l_ptr, pkt_z= 1;              /* pkt_z= 1 wegen \0 */

   l_ptr= end_ptr= ltoa( Zahl, ret_Zahl, 10)+ strlen( ret_Zahl);
   while( l_ptr> ret_Zahl)
   {
      l_ptr-= 3;
      if( l_ptr> ret_Zahl)
      {
	 memmove( l_ptr+ 1, l_ptr, end_ptr- l_ptr+ pkt_z++);
	 *l_ptr= '.';
      }
   }
   return( ret_Zahl);
}

void DiskInfo( int lw)                               /* 'A', 'B', LWAUSWAHL */
{
   struct dfree dfree;
   struct fatinfo diskinfo;
   long avail, gesammt, ges_Sektoren;
   int ret= ABBRUCH, x_lw= 120, y_lw= 220,
       cls_poly[ 18];
   double resultat;
   char tmp_array[ 80], OEM_ID[ 9], lw_art[ 25], phystab[ MAXPATH], phsp[ 35],
	Tausender[ 40];
   BOOL is_Double_Density= 0;
   BYTE *mem_ptr;
   WORD mauspos[]= { BUTTON| FRAME| KEY,              5,  27,   5,  21, ESC,
		     BUTTON| FRAME| KEY| DEFBUTTON, 248, 303, 401, 440, RETURN,
		     BUTTON| FRAME| KEY,            307, 362, 401, 440, 'l' };
   MAUSStruct MS= { DEFAULT, DEFAULT, 303, 449, 3, INIT, NULL, AUS};

   if( lw== LWAUSWAHL)
      lw= LW_Auswahl( &x_lw, &y_lw, "", A_FLOPPY_525| A_FLOPPY_35| A_FESTPLATTE| A_DOUBLEDENSITY| A_RAMDISK, SPEZ_DRIVES| DRIVE_READY);
   else
   {
      if( !is_CASE( lw-= 'A', A_FLOPPY_525| A_FLOPPY_35| A_FESTPLATTE| A_DOUBLEDENSITY| A_RAMDISK, SPEZ_DRIVES))
      {
	 Hinweis( "Dieser Laufwerkstyp wird nicht untersttzt");
	 lw= -1;
      }
   }
   if( lw>= 0)
   {
      MS.x= &X_diskinfo;
      MS.y= &Y_diskinfo;
      MS.mauspos= mauspos;
      PCX_Window( MS.x, MS.y, PCX_DISKINFO, &MS.sa, SHADOW);
      do
      {
	 getfat( lw+ 1, &diskinfo);
	 if(( mem_ptr= malloc( diskinfo.fi_bysec))!= NULL)
	 {
	    if( !absread( lw, 1, 0, mem_ptr))
	    {
	       *( strncpy( OEM_ID, mem_ptr+ 3, 8)+ 8)= '\0';
	       switch( Laufwerksart( lw))
	       {
		  case RAMDISK:
		     strcpy( lw_art, "RAM- Laufwerk");
		     break;
		  case FLOPPY_525:
		  case FLOPPY_35:
		     switch( GetDiskSize( lw))
		     {
			case DD_525:
			   strcpy( lw_art, "DD 5\" 360 KByte");
			   break;
			case DD_35:
			   strcpy( lw_art, "DD 3\" 720 KByte");
			   break;
			case HD_525:
			   strcpy( lw_art, "HD 5\" 1.2 MByte");
			   break;
			case HD_35:
			   strcpy( lw_art, "HD 3\" 1.44 MByte");
			   break;
			case ED_35:
			   strcpy( lw_art, "ED 3\" 2.88 MByte");
			   break;
			default:
			   strcpy( lw_art, "Diskette unbekannt");
			   break;
		     }
		     break;
		  case DOUBLEDENSITY:
		     is_Double_Density= 1;
		  case FESTPLATTE:
		     strcpy( lw_art, "Festplatte");
		     break;
	       }
	       gesammt= ( long)diskinfo.fi_sclus* ( long)diskinfo.fi_nclus* ( long)diskinfo.fi_bysec;
	       sprintf( tmp_array, "%c: - %s ( %s Byte )", 'A'+ lw, lw_art, Tausender_Gruppen( Tausender, gesammt));
	       setcolor( EGA_BLACK);
	       ShowMouse( AUS);
	       outtextxy( *MS.x+ 27, *MS.y+ 40, tmp_array);
	       if( Get_phys_LW( lw, phystab))
	       {
		  MakeShowPath( phystab, phsp, 30);
		  sprintf( tmp_array, "%c: ersetzt %s", 'A'+ lw, phsp);
	       }
	       else
	       {
		  if( is_Double_Density)
		     sprintf( tmp_array, "%c: ist ein Double Density Laufwerk", 'A'+ lw);
		  else
		     sprintf( tmp_array, "%c: ist ein physikalisches Laufwerk", 'A'+ lw);
	       }
	       setcolor( EGA_BLACK);
	       outtextxy( *MS.x+ 27, *MS.y+ 55, tmp_array);
	       sprintf( tmp_array, "%.2X%.2X-%.2X%.2X", mem_ptr[ 0x2A], mem_ptr[ 0x29], mem_ptr[ 0x28], mem_ptr[ 0x27]);
	       outtextxy( *MS.x+ 243, *MS.y+ 70, tmp_array);
	       outtextxy( *MS.x+ 243, *MS.y+ 85, OEM_ID);
	       sprintf( tmp_array, "%.2X Hex", mem_ptr[ 0x15]);
	       outtextxy( *MS.x+ 243, *MS.y+ 100, tmp_array);
	       sprintf( tmp_array, "%u", *( WORD *)( mem_ptr+ 0x0B));
	       outtextxy( *MS.x+ 243, *MS.y+ 115, tmp_array);
	       sprintf( tmp_array, "%u", mem_ptr[ 0x0D]);
	       outtextxy( *MS.x+ 243, *MS.y+ 130, tmp_array);
	       sprintf( tmp_array, "%u", ( WORD)diskinfo.fi_nclus);
	       outtextxy( *MS.x+ 243, *MS.y+ 145, tmp_array);
	       sprintf( tmp_array, "%u", mem_ptr[ 0x10]);
	       outtextxy( *MS.x+ 243, *MS.y+ 160, tmp_array);
	       sprintf( tmp_array, "%u", *( WORD *)( mem_ptr+ 0x16));
	       outtextxy( *MS.x+ 243, *MS.y+ 175, tmp_array);
	       outtextxy( *MS.x+ 243, *MS.y+ 190, ( ( WORD)diskinfo.fi_nclus> 4096) ? ( "16-Bit") : ( "12-Bit"));
	       sprintf( tmp_array, "%lu", ges_Sektoren= ( long)diskinfo.fi_nclus* ( long)diskinfo.fi_sclus+ ( long)*( WORD *)( mem_ptr+ 0x0E)+ ( long)*( WORD *)( mem_ptr+ 0x16)* ( long)mem_ptr[ 0x10]+ ( long)( *( WORD *)( mem_ptr+ 0x11)>> 4));
	       outtextxy( *MS.x+ 243, *MS.y+ 205, tmp_array);
	       sprintf( tmp_array, "%u", *( WORD *)( mem_ptr+ 0x0E));
	       outtextxy( *MS.x+ 243, *MS.y+ 220, tmp_array);
	       sprintf( tmp_array, "%u", *( WORD *)( mem_ptr+ 0x1C));
	       outtextxy( *MS.x+ 243, *MS.y+ 235, tmp_array);
	       sprintf( tmp_array, "%u", *( WORD *)( mem_ptr+ 0x0E));
	       outtextxy( *MS.x+ 243, *MS.y+ 250, tmp_array);
	       sprintf( tmp_array, "%u", *( WORD *)( mem_ptr+ 0x0E)+ *( WORD *)( mem_ptr+ 0x16)* mem_ptr[ 0x10]);
	       outtextxy( *MS.x+ 243, *MS.y+ 265, tmp_array);
	       sprintf( tmp_array, "%u", *( WORD *)( mem_ptr+ 0x0E)+ *( WORD *)( mem_ptr+ 0x16)* mem_ptr[ 0x10]+ ( *( WORD *)( mem_ptr+ 0x11)>> 4));
	       outtextxy( *MS.x+ 243, *MS.y+ 280, tmp_array);
	       sprintf( tmp_array, "%u", *( WORD *)( mem_ptr+ 0x11));
	       outtextxy( *MS.x+ 243, *MS.y+ 295, tmp_array);
	       sprintf( tmp_array, "%u", *( WORD *)( mem_ptr+ 0x1A));
	       outtextxy( *MS.x+ 243, *MS.y+ 310, tmp_array);
	       sprintf( tmp_array, "%u", ( WORD)ceil( (( double)ges_Sektoren+ ( double)*( WORD *)( mem_ptr+ 0x1C))/ ( ( double)*( WORD *)( mem_ptr+ 0x1A)* ( double)*( WORD *)( mem_ptr+ 0x18))));
	       outtextxy( *MS.x+ 243, *MS.y+ 325, tmp_array);
	       sprintf( tmp_array, "%u", *( WORD *)( mem_ptr+ 0x18));
	       outtextxy( *MS.x+ 243, *MS.y+ 340, tmp_array);
	       getdfree( lw+ 1, &dfree);
	       avail= ( long)dfree.df_avail* ( long)dfree.df_bsec* ( long)dfree.df_sclus;
	       sprintf( tmp_array, "In %c: sind noch %s Bytes frei", 'A'+ lw, Tausender_Gruppen( Tausender, avail));
	       outtextxy( *MS.x+ 27, *MS.y+ 365, tmp_array);
	       resultat= ((( double)avail* 100)/ ( double)gesammt);   /* Wieviel Prozent noch frei ? */
	       sprintf( tmp_array, "%.2f%% frei", resultat);
	       KreisDiagramm( *MS.x+ 102, *MS.y+ 408, resultat, EGA_LIGHTRED, EGA_RED, EGA_DARKGRAY, tmp_array);
	       ShowMouse( AN);
	       ret= 0;
	       do
	       {
		  switch( __CheckMousepos( &MS))
		  {
		     case 0:                                            /* ESC */                        /* ESC */
		     case 1:                                         /* Return */
			ret= ABBRUCH;
			break;
		     case 2:                                     /* LW-Auswahl */
			if(( lw= LW_Auswahl( &x_lw, &y_lw, "", A_FLOPPY_525| A_FLOPPY_35| A_FESTPLATTE| A_DOUBLEDENSITY, SPEZ_DRIVES| DRIVE_READY))>= 0)
			{
			   cls_poly[  0]= *MS.x+ 17;
			   cls_poly[  1]= *MS.y+ 34;
			   cls_poly[  2]= *MS.x+ 365;
			   cls_poly[  3]= *MS.y+ 34;
			   cls_poly[  4]= *MS.x+ 365;
			   cls_poly[  5]= *MS.y+ 345;
			   cls_poly[  6]= *MS.x+ 332;
			   cls_poly[  7]= *MS.y+ 378;
			   cls_poly[  8]= *MS.x+ 17;
			   cls_poly[  9]= *MS.y+ 378;
			   cls_poly[ 10]= *MS.x+ 17;
			   cls_poly[ 11]= *MS.y+ 351;
			   cls_poly[ 12]= *MS.x+ 232;
			   cls_poly[ 13]= *MS.y+ 351;
			   cls_poly[ 14]= *MS.x+ 232;
			   cls_poly[ 15]= *MS.y+ 67;
			   cls_poly[ 16]= *MS.x+ 17;
			   cls_poly[ 17]= *MS.y+ 67;
			   ShowMouse( AUS);
			   setcolor( EGA_LIGHTGRAY);
			   setfillstyle( SOLID_FILL, EGA_LIGHTGRAY);
			   fillpoly( 9, cls_poly);
			   bar( *MS.x+ 204, *MS.y+ 383, *MS.x+ 309, *MS.y+ 393);
			   ShowMouse( AN);
			   ret= NOCHMAL;
			}
			break;
		  }
	       }while( !ret);
	    }
	    else
	       ErrorMsg( "Konnte Datentrger nicht lesen");
	    free( mem_ptr);
	 }
	 else
	    ErrorMsg( KEIN_SPEICHER);
      }while( ret== NOCHMAL);
      ShowMouse( AUS);
      BigScreenRestore( &MS.sa, *MS.x, *MS.y);
      ShowMouse( AN);
   }
}

int SetLabel( int lw, char *Label)
{
   int handle;
   char path[ 20];

   if( *Label)
   {
      sprintf( path, "%c:\\%s", 'A'+ lw, Label);
      if( strlen( Label)> 8)                           /* Dateipunkt setzen */
      {
	 memmove( path+ 12, path+ 11, 4);
	 *( path+ 11)= '.';
      }
      if((( handle= _creat( path, FA_LABEL))== -1)|| close( handle))
      {
	 ErrorMsg( "Diskettenname konnte nicht gespeichert werden");
	 lw= -1;
      }
   }
   return( lw);
}

int EraseLabel( int lw)                                    /* 0=A, 1=B, ... */
{
   struct xfcb Label_xfcb= { 0xFF, 0, 0, 0, 0, 0, FA_LABEL, 0, "????????", "???"};

   Label_xfcb.xfcb_fcb.fcb_drive= lw+ 1;
   RP.r_ax= 0x1300;                                  /* altes Label lschen */
   RP.r_dx= FP_OFF( &Label_xfcb);
   RP.r_ds= FP_SEG( &Label_xfcb);
   intr( DOS_INT, &RP);
   return( LO( RP.r_ax));            /* =0 -> Label gelscht, !=0 -> Fehler */
}

int DiskLabel( int LW)                          /* LWAUSWAHL, 'A', 'B', ... */
{
   struct ffblk ffblk;
   int ret_val= 0, ret, lw, status, x_lw= 200, y_lw= 200;
   char Label[ 15], path[ 20], *tmp_ptr;
   void *arg_ptr[ 1];
   char *msg[]= { "Name, der dem Datentrger zugeordnet ist",
		  "Datentrgername lschen",
		  "Datentrger mit oben genanntem Namen versehen",
		  "Neuen Datentrger auswhlen (neues Laufwerk)" };
   WORD mauspos[]= { BUTTON| FRAME| KEY,                   5,  27,   5,  21, ESC,
		     INPUT|  FRAME| KEY| DEFBUTTON| MSG,  12,  44, 143,  11, 'n',
		     BUTTON| FRAME| KEY|            MSG,  12,  67,  75, 114, 'c',
		     BUTTON| FRAME| KEY|            MSG,  73, 128,  75, 114, 's',
		     BUTTON| FRAME| KEY|            MSG, 134, 189,  75, 114, 'l',
		     BUTTON| FRAME| KEY,                 195, 250,  75, 114, 'a',
		     MOVEWINDOW };
   MAUSStruct MS= { DEFAULT, DEFAULT, 263, 128, 7, INIT, NULL, AN};

   switch( LW)
   {
      case LWAUSWAHL:
	 if(( lw= LW_Auswahl( &x_lw, &y_lw, "Laufwerk auswhlen, dem ein neuer Name gegeben werden soll", A_FLOPPY_525| A_FLOPPY_35| A_FESTPLATTE| A_DOUBLEDENSITY, SPEZ_DRIVES| DRIVE_READY))< 0)
	    ret_val= -1;
	 break;
      default:
	 lw= LW- 'A';
	 break;
   }
   if( ret_val== 0)                                         /* kein Abbruch */
   {
      arg_ptr[ 0]= Label;
      MS.x= &disklabelx;
      MS.y= &disklabely;
      MS.msg= msg;
      MS.mauspos= mauspos;
      MS.arg_ptr= arg_ptr;
      PCX_Window( MS.x, MS.y, PCX_DISKLABEL, &MS.sa, SHADOW);
      do
      {
	 ret= 0;
	 ShowMouse( AUS);
	 ShowDrive( *MS.x+ 187, *MS.y+ 46, Laufwerksart( lw));
	 setcolor( EGA_BLACK);
	 ClearTextN( *MS.x+ 212, *MS.y+ 49, 2);
	 sprintf( path, "%c:", lw+ 'A');
	 outtextxy( *MS.x+ 212, *MS.y+ 49, path);
	 ShowMouse( AN);
	 sprintf( path, "%c:\\*.*", lw+ 'A');
	 if( !findfirst( path, &ffblk, FA_LABEL))
	 {
	    if(( tmp_ptr= strchr( strcpy( Label, ffblk.ff_name), '.'))!= NULL) /* Dateipunkt lschen */
	       memmove( tmp_ptr, tmp_ptr+ 1, 4);
	 }
	 else
	    *Label= '\0';
	 do
	 {
	    switch( status= __CheckMousepos( &MS))
	    {
	       case 0:                                               /* ESC */
	       case 5:                                           /* Abbruch */
		  ret= ABBRUCH;
		  ret_val= -1;
		  break;
	       case 2:                                           /* Lschen */
	       case 3:                                            /* Setzen */
		  MouseArt( maus_sanduhr);
		  EraseLabel( lw);
		  ret_val= (( status== 2) ? lw : SetLabel( lw, Label)); /* nur Lschen ? */
		  MouseArt( maus_pfeil);
		  break;
	       case 4:
		  if(( status= LW_Auswahl( &x_lw, &y_lw, "Laufwerk auswhlen, dem ein neuer Name gegeben werden soll", A_FLOPPY_525| A_FLOPPY_35| A_FESTPLATTE| A_DOUBLEDENSITY, SPEZ_DRIVES| DRIVE_READY))>= 0)
		  {
		     lw= status;
		     ret= NOCHMAL;
		     MS.statsp= REINIT;
		  }
		  break;
	    }
	 }while( !ret);
      }while( ret!= ABBRUCH);
      ShowMouse( AUS);
      BigScreenRestore( &MS.sa, *MS.x, *MS.y);
      ShowMouse( AN);
   }
   return( ret_val);                           /* -1= Fehler, 0=A, 1=B, ... */
}

typedef BYTE DDPTType[ 11];                           /* Feld fr eine DDPT */
typedef DDPTType *DDPTPTR;                          /* Zeiger auf eine DDPT */

typedef struct{                             /* physikalische Formatparamter */
		  BYTE    Seiten,                      /* Anzahl der Seiten */
			  Spuren,                       /* Spuren pro Seite */
			  Sektoren;                    /* Sektoren pro Spur */
		  DDPTPTR DDPT;                         /* Zeiger auf DDPTR */
	      }PhysDataType;

typedef struct{                                 /* logische Formatparameter */
		  BYTE Media,                                 /* Media-Byte */
		       Cluster,              /* Anzahl Sektoren pro Cluster */
		       FAT,                  /* Anzahl Sektoren fr die FAT */
		       RootSize,            /* Eintrge im Hauptverzeichnis */
		       DatenSektor;                      /* Daten ab Sektor */
	      }LogDataType;

typedef struct{  int x,
		     y,
		     xbal,
		     ybal,
		     rad,
		     rad_per_spur;
	      }SpurenGraph;

void GetFormatParameter( BYTE ZuFormat, PhysDataType *PDataP, LogDataType *LDataP)
{
   DDPTType DDPT_Format[]= { { 0xDF, 0x02, 0x25, 0x02, 0x09, 0x2A, 0xFF, 0x50, 0xF6, 0x0F, 0x08}, /* DD_525 */
			     { 0xDF, 0x02, 0x25, 0x02, 0x0F, 0x1B, 0xFF, 0x54, 0xF6, 0x0F, 0x08}, /* HD_525 */
			     { 0xDF, 0x02, 0x25, 0x02, 0x09, 0x2A, 0xFF, 0x50, 0xF6, 0x0F, 0x08},  /* DD_35 */
			     { 0xDF, 0x02, 0x25, 0x02, 0x12, 0x1B, 0xFF, 0x6C, 0xF6, 0x0F, 0x08},  /* HD_35 */
			     { 0xDF, 0x02, 0x25, 0x02, 0x24, 0x1B, 0xFF, 0x50, 0xF6, 0x0F, 0x08}   /* ED_35 */
			   };
   static DDPTType DDPT;

   /* logische Formatparameter:

      Media-Byte,
      Anzahl Sektoren pro Cluster,
      Anzahl Sektoren fr die FAT,
      Eintrge im Hauptverzeichnis,
      Daten ab Sektor */

   LogDataType LOG_Format[]= { { 0xFD, 2, 2, 0x70, 12},           /* DD_525 */
			       { 0xF9, 1, 7, 0xE0, 29},           /* HD_525 */
			       { 0xF9, 2, 3, 0x70, 14},            /* DD_35 */
			       { 0xF0, 1, 9, 0xE0, 33},            /* HD_35 */
			       { 0xF0, 1, 9, 0xE0, 33}             /* ED_35 */
			     };

   /* physikalische Formatparamter:

      Anzahl der Seiten,
      Spuren pro Seite,
      Sektoren pro Spur,
      Zeiger auf DDPTR */

   PhysDataType PHYS_Format[]= { { 2, 40,  9, &DDPT},             /* DD_525 */
				 { 2, 80, 15, &DDPT},             /* HD_525 */
				 { 2, 80,  9, &DDPT},              /* DD_35 */
				 { 2, 80, 18, &DDPT},              /* HD_35 */
				 { 2, 80, 36, &DDPT}               /* ED_35 */
			       };

   if( PDataP!= NULL)
   {
      memcpy( DDPT,   &DDPT_Format[ ZuFormat- 1], sizeof( DDPTType));
      memcpy( PDataP, &PHYS_Format[ ZuFormat- 1], sizeof( PhysDataType));
   }
   if( LDataP!= NULL)
      memcpy( LDataP, &LOG_Format[ ZuFormat- 1],  sizeof( LogDataType));
}

void DiskReset( void)
{
   biosdisk( _DISK_RESET, DEFAULT, DEFAULT, DEFAULT, DEFAULT, DEFAULT, NULL);
}

void DiskPrepare( BYTE Drive, BYTE Max_Spur, BYTE Max_Sektor)
{
   union REGS regs;

   regs.h.ah= _DISK_PREPARE;
   regs.h.ch= Max_Spur;
   regs.h.cl= Max_Sektor;
   regs.h.dl= Drive;
   int86( DISK_INT, &regs, &regs);
}

BYTE FormatTrack( BYTE Drive, BYTE Seite, BYTE Spur, BYTE Anzahl)
{
   struct{ BYTE DSpur, DSeite, DZaehler, DLaenge; }Datenfeld[ 36];
   struct diskinfo_t dinfo;
   BYTE versuche= MAXVERSUCHE, Zaehler, ret_AH;

   for( Zaehler= 0; Zaehler< Anzahl; Zaehler++)
   {
      Datenfeld[ Zaehler].DSpur=    Spur;
      Datenfeld[ Zaehler].DSeite=   Seite;
      Datenfeld[ Zaehler].DZaehler= Zaehler+ 1;
      Datenfeld[ Zaehler].DLaenge=  2;               /* 512 Byte pro Sektor */
   }
   dinfo.drive=    Drive;
   dinfo.head=     Seite;
   dinfo.track=    Spur;
   dinfo.sector=   DEFAULT;
   dinfo.nsectors= Anzahl;
   dinfo.buffer=   Datenfeld;
   while((( ret_AH= HI( _bios_disk( _DISK_FORMAT, &dinfo)))!= 0)&& ( --versuche!= 0))
      DiskReset();
   return( ret_AH);
}

BYTE VerifyTrack( BYTE Drive, BYTE Seite, BYTE Spur, BYTE Sektoren, BYTE *Verify)
{
   struct diskinfo_t dinfo;
   BYTE versuche= MAXVERSUCHE, ret_AH;
   void *sbptr;                                    /* Zeiger auf Spurpuffer */

   dinfo.drive=    Drive;
   dinfo.head=     Seite;
   dinfo.track=    Spur;
   dinfo.sector=   1;
   dinfo.nsectors= Sektoren;
   dinfo.buffer=   sbptr;
   if(( sbptr= malloc( Sektoren* 512))!= NULL)
   {
      while((( ret_AH= HI( _bios_disk( _DISK_VERIFY, &dinfo)))!= 0)&& ( --versuche!= 0))
	 DiskReset();
      free( sbptr);
      return( ret_AH);                            /* Fehler-Status auslesen */
   }
   else
   {
      if( Info_Frage( 220, 230, "Nicht genug Speicher\nvorhanden um die Spu-\nren zu berprfen.\n>ESC< -> Abbruch\n>OK<  -> Weiter", INFO))
	 return( 0xBB);     /* Abbruch (undefinierbarer Fehler aufgetaucht) */
      else
      {
	 *Verify= AUS;
	 return( 0);
      }
   }
}

BYTE WriteTrack( BYTE Drive, BYTE Seite, BYTE Spur, BYTE Start, BYTE Sektoren, void *Daten)
{
   struct diskinfo_t dinfo;
   BYTE versuche= MAXVERSUCHE, ret_AH;

   dinfo.drive=    Drive;
   dinfo.head=     Seite;
   dinfo.track=    Spur;
   dinfo.sector=   Start;
   dinfo.nsectors= Sektoren;
   dinfo.buffer=   Daten;
   while((( ret_AH= HI( _bios_disk( _DISK_WRITE, &dinfo)))!= 0)&& ( --versuche!= 0))
      DiskReset();
   return( ret_AH);
}

BYTE ReadTrack( BYTE Drive, BYTE Seite, BYTE Spur, BYTE Start, BYTE Sektoren, void *Daten)
{
   struct diskinfo_t dinfo;
   BYTE versuche= MAXVERSUCHE, ret_AH;

   dinfo.drive=    Drive;
   dinfo.head=     Seite;
   dinfo.track=    Spur;
   dinfo.sector=   Start;
   dinfo.nsectors= Sektoren;
   dinfo.buffer=   Daten;
   while((( ret_AH= HI( _bios_disk( _DISK_READ, &dinfo)))!= 0)&& ( --versuche!= 0))
      DiskReset();
   return( ret_AH);
}

int GetDiskSize( int lw)                                   /* 0=A, 1=B, ... */
{
   BYTE Status, buf[ 512];

   if(( Status= ReadTrack( lw, 0, 0, 1, 1, buf))!= 0)
   {
      if( Status== 0x80)                           /* Laufwerk nicht bereit */
	 return( -1);
      else
	 return( NO_FORMAT);
   }
   switch( ( WORD)buf[ 0x13]+ ( ( WORD)buf[ 0x14]<< 8))  /* Sektoren auf der Diskette */
   {
      case 720:
	 return( DD_525);
      case 2400:
	 return( HD_525);
      case 1440:
	 return( DD_35);
      case 2880:
	 return( HD_35);
      case 5760:
	 return( ED_35);
      default:
	 return( UNBEKANNT);
   }
}

void Show_Track( SpurenGraph SG, BYTE Spur, BYTE Spuren_ges, BYTE Track_Stat_sp, BYTE Track_Stat, char Anzeige)
{
   static int xsp;
   int aussen_rad, innen_rad,
       color[][ 2]= { { SOLID_FILL, EGA_BLACK},             /* FAULT+ FAULT */
		      { SLASH_FILL, EGA_LIGHTGREEN},        /* FAULT+ OK */
		      { SOLID_FILL, EGA_LIGHTGREEN}         /* OK+    OK */
		    };

   ShowMouse( AUS);
   if( Anzeige== GROSSE_ANZ)
   {
      aussen_rad= SG.rad- ( Spur* SG.rad_per_spur);
      innen_rad= aussen_rad- SG.rad_per_spur;
      setcolor( EGA_BLACK);
      arc( SG.x, SG.y, 0, 90, aussen_rad);
      arc( SG.x, SG.y, 0, 90, innen_rad);
      line( SG.x, SG.y- innen_rad, SG.x, SG.y- aussen_rad);
      line( SG.x+ innen_rad, SG.y, SG.x+ aussen_rad, SG.y);
      setfillstyle( color[ Track_Stat_sp+ Track_Stat][ 0], color[ Track_Stat_sp+ Track_Stat][ 1]);
      floodfill( SG.x+ 1, SG.y- innen_rad- 1, EGA_BLACK);
   }
   else
      Balken( SG.xbal, SG.ybal, 200, 15, ( long)Spur, ( long)Spuren_ges- 1L, &xsp);
   ShowMouse( AN);
}

void MOverTextxy( int X, int Y, char *msg, char clearN)
{
   ShowMouse( AUS);
   ClearTextN( X, Y, clearN);
   setcolor( EGA_BLACK);
   outtextxy( X, Y, msg);
   ShowMouse( AN);
}

void Show_Prozent( SpurenGraph SG, int *Wert, int Grundwert, char Anzeige)
{
   char Zahl[ 5];

   if( Anzeige== GROSSE_ANZ)
   {
      sprintf( Zahl, "%3d%%", ++( *Wert)* 100/ Grundwert);
      MOverTextxy( SG.x+ 181, SG.y- 241, Zahl, 3);
   }
}

void Show_Work( SpurenGraph SG, char Mode, char Anzeige)
{
   int poly[ 8], color[]= { EGA_BLUE,                        /* FORMATIEREN */
			    EGA_DARKGRAY                    /* UEBERPRUEFEN */
			  };

   if( Anzeige== GROSSE_ANZ)
   {
      poly[ 0]= SG.x+ 159;
      poly[ 1]= SG.y- 236;
      poly[ 2]= SG.x+ 163;
      poly[ 3]= SG.y- 236;
      poly[ 4]= SG.x+ 159;
      poly[ 5]= SG.y- 229;
      poly[ 6]= SG.x+ 155;
      poly[ 7]= SG.y- 229;
      setcolor( color[ Mode]);
      setfillstyle( SOLID_FILL, color[ Mode]);
      ShowMouse( AUS);
      fillpoly( 4, poly);
      ShowMouse( AN);
   }
}

#define UNBENUTZT   0x0000
#define FEHLERHAFT  0x0FF7

/* !!! DER FAT-SPEICHERBEREICH MU MIT 0 INITIALISIERT SEIN !!!*/

void Put_FATCode( BYTE Spur, BYTE Seite, BYTE Sektor, WORD Zustand, BYTE Sekt_Spur, BYTE Sekt_Cluster, BYTE Daten_ab_Sektor, BYTE *FAT_Beginn)
{
   WORD Cluster;
   BYTE *FAT_ptr;

   Cluster= (((((( Spur<< 1)+ Seite)* Sekt_Spur)+ ( Sektor- 1))- Daten_ab_Sektor)/ Sekt_Cluster)+ 2;
   FAT_ptr= FAT_Beginn+ ( WORD)(( float)Cluster* ( float)1.5);
   if( Cluster& 1)
      ( *( WORD *)FAT_ptr)|= Zustand<< 4;
   else
      ( *( WORD *)FAT_ptr)|= Zustand& 0x0FFF;
}

DWORD Datentraegernummer( void)
{
   return( ( DWORD)time( NULL));
}

int PhysLogFormat( BYTE Drive, PhysDataType PData, LogDataType LData, BYTE Verify, SpurenGraph SG, BYTE Anzeige)
{
   WORD GesamtSektoren, Anzahl;
    int	ret_val= 0, Grundwert, Wert= -1;
   BYTE *Mem_ptr, Track_Stat_sp, Track_Stat, versuche, Spur, Seite, Sektor,
	Status, i, AktSector, AktSide, AktTrack,
	BootMaske[]= { 0xEB, 0x3E,                     // 0000  JMP  0040
		       0x90,                           // 0002  NOP

		       /*-- Daten des BPB ------------------------------*/

		       'D',  'E',  'S',  'K',  'T',  'O',  'P',  ' ',
		       0x00, 0x02, 0x00, 0x01, 0x00, 0x02, 0x00, 0x00,
		       0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		       0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		       0x00, 0x00, 0x00, 0x29, 0x00, 0x00, 0x00, 0x00,
		       'N',  'O',  ' ',  'N',  'A',  'M',  'E',  ' ',
		       ' ',  ' ',  ' ', 'F',  'A',  'T',  '1',  '2',
		       ' ',  ' ',  ' ',  0x00, 0x00,

		       /*-- Eigentliches Ladeprogramm ------------------*/

		       0xFA,                           // 0040  CLI
		       0x33, 0xC0,                     // 0041  XOR	AX, AX
		       0x8E, 0xD8,                     // 0043  MOV	DS, AX
		       0x8E, 0xC0,                     // 0045  MOV	ES, AX
		       0xFC,                           // 0047  CLD
		       0xB9, 0x00, 0x01,               // 0048  MOV	CX, 0100
		       0xBE, 0x00, 0x7C,               // 004B  MOV	SI, 7C00
		       0xBF, 0x00, 0x80,               // 004E  MOV	DI, 8000
		       0xF3,                           // 0051  REPZ
		       0xA5,                           // 0052  MOVSW
		       0xEA, 0x58, 0x00, 0x00, 0x08,   // 0053  JMP	0800:0058
		       0xBE, 0xF9, 0x00,               // 0058  MOV	SI, sizeof( BootMaske)
		       0xE8, 0x7D, 0x00,               // 005B  CALL	00DB
		       0xBB, 0x6C, 0x04,               // 005E  MOV	BX, 046C
		       0x8B, 0x37,                     // 0061  MOV	SI,[ BX]
		       0x8B, 0x7F, 0x02,               // 0063  MOV	DI,[ BX+ 02]
		       0x83, 0xC6, 0x7F,               // 0066  ADD	SI, 7F
		       0x83, 0xD7, 0x00,               // 0069  ADC	DI, 00
		       0xB4, 0x01,                     // 006C  MOV	AH, 01
		       0xCD, 0x16,                     // 006E  INT	16
		       0x75, 0x0B,                     // 0070  JNZ	007D
		       0x39, 0x7F, 0x02,               // 0072  CMP	[ BX+ 02], DI
		       0x72, 0xF5,                     // 0075  JB	006C
		       0x39, 0x37,                     // 0077  CMP	[ BX], SI
		       0x72, 0xF1,                     // 0079  JB	006C
		       0xEB, 0x13,                     // 007B  JMP	0090
		       0xB4, 0x00,                     // 007D  MOV	AH, 00        Welche Taste wurde gedrckt ?
		       0xCD, 0x16,                     // 007F  INT	16
		       0x80, 0xFC, 0x3E,               // 0081  CMP	AH, 3E        [F4]
		       0x74, 0x4D,                     // 0084  JZ	00D3
		       0x80, 0xFC, 0x3D,               // 0086  CMP	AH, 3D        [F3]
		       0x74, 0x46,                     // 0089  JZ	00D1
		       0x80, 0xFC, 0x3C,               // 008B  CMP	AH, 3C        [F2]
		       0x74, 0x15,                     // 008E  JZ	00A5
		       0xB8, 0x01, 0x02,               // 0090  MOV	AX, 0201      [F1] bzw. keine Taste -> von Platte booten
		       0xBB, 0x00, 0x7C,               // 0093  MOV	BX, 7C00
		       0xBA, 0x80, 0x00,               // 0096  MOV	DX, 0080
		       0xB9, 0x01, 0x00,               // 0099  MOV	CX, 0001
		       0xCD, 0x13,                     // 009C  INT	13
		       0x72, 0x31,                     // 009E  JB	00D1
		       0xEA, 0x00, 0x7C, 0x00, 0x00,   // 00A0  JMP	0000:7C00
		       0x8B, 0x1E, 0x02, 0x01,         // 00A5  MOV	BX, [ 0102]
		       0x23, 0xDB,                     // 00A9  AND	BX, BX
		       0x74, 0x24,                     // 00AB  JZ	00D1
		       0x53,                           // 00AD  PUSH	BX
		       0xBE, 0xCA, 0x01,               // 00AE  MOV	SI, sizeof( BootMaske)+ sizeof( BootMes)
		       0xE8, 0x27, 0x00,               // 00B1  CALL	00DB
		       0x5B,                           // 00B4  POP	BX
		       0x89, 0x1E, 0x42, 0x03,         // 00B5  MOV	[ 0342], BX
		       0xBF, 0x00, 0x03,               // 00B9  MOV	DI, 0300
		       0x8B, 0xC7,                     // 00BC  MOV	AX, DI
		       0x87, 0x06, 0x00, 0x01,         // 00BE  XCHG	AX, [ 0100]
		       0xA3, 0x40, 0x03,               // 00C2  MOV	[ 0340], AX
		       0x8C, 0x06, 0x02, 0x01,         // 00C5  MOV	[ 0102], ES
		       0xBE, 0xEA, 0x80,               // 00C9  MOV	SI, 80EA
		       0xB9, 0x0F, 0x00,               // 00CC  MOV	CX, 000F
		       0xF3,                           // 00CF  REPZ
		       0xA4,                           // 00D0  MOVSB
		       0xCD, 0x19,                     // 00D1  INT	19
		       0xBA, 0x64, 0x00,               // 00D3  MOV	DX, 0064
		       0xB0, 0xFE,                     // 00D6  MOV	AL, FE
		       0xEE,                           // 00D8  OUT	DX, AL
		       0xEB, 0xF8,                     // 00D9  JMP	00D3

		       /*-- Routine zu Ausgeben einer Zeichenkette -----*/

		       0x2E,                           // 00DB  CS:
		       0xAC,                           // 00DC  LODSB
		       0x0A, 0xC0,                     // 00DD  OR	AL, AL
		       0x74, 0x08,                     // 00DF  JZ	00E9
		       0x32, 0xFF,                     // 00E1  XOR	BH, BH
		       0xB4, 0x0E,                     // 00E3  MOV	AH, 0E
		       0xCD, 0x10,                     // 00E5  INT	10
		       0xEB, 0xF2,                     // 00E7  JMP	00DB
		       0xC3,                           // 00E9  RET

		       /*-- neuer INT 0x40 -----------------------------*/

		       0x9C,                           // 00EA  PUSHF
		       0x80, 0xF2, 0x01,               // 00EB  XOR	DL, 01
		       0x9D,                           // 00EE  POPF
		       0xCD, 0xD0,                     // 00EF  INT	D0
		       0x9C,                           // 00F1  PUSHF
		       0x80, 0xF2, 0x01,               // 00F2  XOR	DL, 01
		       0x9D,                           // 00F5  POPF
		       0xCA, 0x02, 0x00                // 00F6  RETF	0002
		       };

   char BootMes[]= "\r\n"
		   "DESKTOP V"DESKTOP_VERSION"\r\n\n"
		   "Diese Diskette ist nicht bootfhig !\r\n\n"
		   "F1 -> Betriebssystem von der Festplatte booten\r\n"
		   "F2 -> von Laufwerk B: booten\r\n"
		   "F3 -> erneut von diesem Laufwerk booten\r\n"
		   "F4 -> Software-RESET ausfhren\r\n\n",
   LW_change[]= "Diskettenlaufwerke vertauscht !\r\n";

   if(( Mem_ptr= calloc( AktSector= ( 2* LData.FAT)+ 1, 512))!= NULL)  /* 2xFAT_Sektoren+ Bootsektor */
   {
      Grundwert= ( int)PData.Spuren<< 1;
      Show_Prozent( SG, &Wert, Grundwert, Anzeige);
      for( Spur= 0; ( Spur< PData.Spuren)&& !ret_val; Spur++)
      {
	 for( Seite= 0; ( Seite< PData.Seiten)&& !ret_val; Seite++)
	 {
	    if( Break( 200, 275, "Soll 'Formatieren'\nwirklich abgebrochen\nwerden ?"))
	       ret_val= -1;
	    else
	    {
	       Show_Work( SG, FORMATIEREN, Anzeige);
	       switch( Status= FormatTrack( Drive, Seite, Spur, PData.Sektoren))
	       {
		  case 0x03:                   /* Diskette schreibgeschtzt */
		     ErrorMsg( "Die Diskette ist schreibgeschtzt");
		     ret_val= -1;
		     break;
		  case 0x80:                  /* keine Diskette im Laufwerk */
		     ErrorMsg( "Laufwerk reagiert nicht (eventuell keine Disk im Laufwerk)");
		     ret_val= -1;
		     break;
		  default:
		     if( Verify== AN)
		     {
			Show_Work( SG, UEBERPRUEFEN, Anzeige);
			if(( Status= VerifyTrack( Drive, Seite, Spur, PData.Sektoren, &Verify))== 0xBB) /* Abbruch */
			   ret_val= -1;
		     }
		     break;
	       }
	       if( !ret_val)            /* kein Hardwarefehler oder Abbruch */
	       {
		  if( Status> 0)                /*  Fehler beim Formatieren */
		  {
		     if( Spur== 0)
		     {
			Info_Frage( 220, 230, "Spur 0 ist fehlerhaft.\nDatentrger kann\nnicht formatiert\nwerden.", INFO);
			ret_val= -1;
		     }
		     else
		     {
			for( Sektor= 1; Sektor<= PData.Sektoren; Sektor++)
			   Put_FATCode( Spur, Seite, Sektor, FEHLERHAFT, PData.Sektoren, LData.Cluster, LData.DatenSektor, Mem_ptr+ 512);
			if( Seite== ( PData.Seiten- 1))
			   Track_Stat= FAULT;
			else
			   Track_Stat_sp= FAULT;
		     }
		  }
		  else
		  {
		     if( Seite== ( PData.Seiten- 1))
			Track_Stat= OK;
		     else
			Track_Stat_sp= OK;
		  }
	       }
	       Show_Prozent( SG, &Wert, Grundwert, Anzeige);
	    }
	 }
	 Show_Track( SG, Spur, PData.Spuren, Track_Stat_sp, Track_Stat, Anzeige);
      }
      if( !ret_val)                 /* kein Hardwarefehler und kein Abbruch */
      {
	 /*-- FAT und FAT-Kopie anlegen --------------------------------------*/

	 *( Mem_ptr+ 512+ 0)= LData.Media;                  /* 1. FAT anlegen */
	 *( Mem_ptr+ 512+ 1)= 0xFF;
	 *( Mem_ptr+ 512+ 2)= 0xFF;

	 memcpy( Mem_ptr+ ( ( WORD)( LData.FAT+ 1)<< 9), Mem_ptr+ 512, ( WORD)LData.FAT<< 9);

	 /*-- Bootsektor: fester Teil ----------------------------------------*/

	 memcpy( Mem_ptr, BootMaske, sizeof( BootMaske));
	 memcpy( Mem_ptr+ sizeof( BootMaske), BootMes, sizeof( BootMes));
	 memcpy( Mem_ptr+ sizeof( BootMaske)+ sizeof( BootMes), LW_change, sizeof( LW_change));
	 *( Mem_ptr+ 510)= 0x55;           /* Endekennzeichen des Bootsektors */
	 *( Mem_ptr+ 511)= 0xAA;

	 /*-- Bootsektor: variabler Teil--------------------------------------*/

	 GesamtSektoren= ( WORD)PData.Spuren *( WORD)PData.Sektoren *( WORD)PData.Seiten;
	 *( Mem_ptr+ 13)= LData.Cluster;                      /* Clustergre */
	 *( Mem_ptr+ 17)= LData.RootSize;       /* Anzahl Eintrge im Hauptv. */
	 *( Mem_ptr+ 19)= LO( GesamtSektoren);
	 *( Mem_ptr+ 20)= HI( GesamtSektoren);
	 *( Mem_ptr+ 21)= LData.Media;                    /* Media-Deskriptor */
	 *( Mem_ptr+ 22)= LData.FAT;                         /* Gre der FAT */
	 *( Mem_ptr+ 24)= PData.Sektoren;                /* Sektoren pro Spur */
	 *( Mem_ptr+ 26)= PData.Seiten;                  /* Anzahl der Seiten */
	 *( DWORD *)( Mem_ptr+ 39)= Datentraegernummer();

	 /*-- Boot-Sektor und FAT's schreiben --------------------------------*/

	 if( WriteTrack( Drive, 0, 0, 1, AktSector, Mem_ptr)) /* Fehler beim Schreiben? */
	 {
	    ErrorMsg( "Kann weder FAT's noch Bootsektor auf die Disk schreiben");
	    ret_val= -1;
	 }
	 else
	 {
	    /*-- Rootverzeichnis schreiben --------------------------------------*/

	    memset( Mem_ptr, 0, 512);                        /* Leerer Sektor */
	    AktTrack= 0;                                   /* Aktuelle Spur */
	    AktSide= 0;                                   /* Aktuelle Seite */

	    /*-- Anzahl der verbleibenden Sektoren ermitteln und schreiben ------*/

	    Anzahl= LData.RootSize* 32/ 512;
	    for( i= 0; ( i< Anzahl)&& !ret_val; i++)
	    {
	       if( ++AktSector> PData.Sektoren)                     /* Spur zu Ende? */
	       {
		  AktSector= 1;                               /* Weiter bei Sektor 1 */
		  if( ++AktSide== PData.Seiten)                   /* Schon 2. Seite? */
		  {
		     AktSide= 0;                               /* Wieder auf Seite 0 */
		     AktTrack++;
		  }
	       }
	       if( WriteTrack( Drive, AktSide, AktTrack, AktSector, 1, Mem_ptr)) /* Fehler? */
	       {
		  ErrorMsg( "Kann das Wurzelverzeichnis nicht auf die Disk schreiben");
		  ret_val= -1;
	       }
	    }
	 }
      }
      free( Mem_ptr);
   }
   else
   {
      ErrorMsg( KEIN_SPEICHER);
      ret_val= -1;
   }
   return( ret_val);
}

int _Format( BYTE Drive, BYTE Format, BYTE Verify, SpurenGraph SG, BYTE mode)
{
   PhysDataType PData;                     /* physikalische Formatparameter */
   LogDataType  LData;                          /* logische Formatparameter */
   void interrupt ( *AlteDDPT)();                   /* Zeiger auf alte DDPT */
   int ExitCode;

   GetFormatParameter( Format, &PData, &LData);
   DiskPrepare( Drive, PData.Spuren- 1, PData.Sektoren);
   AlteDDPT= getvect( 0x1E);                            /* Alte DDPT merken */
   setvect( 0x1E, ( void interrupt(*)())PData.DDPT);    /* Neue DDPT Setzen */
   ExitCode= PhysLogFormat( Drive, PData, LData, Verify, SG, mode);
   setvect( 0x1E, AlteDDPT);                      /* Alte DDPT restaurieren */
   return( ExitCode);                        /* !=0 -> Abbruch, ==0 -> O.K. */
}

int MakeFormat( int X, int Y, BYTE lw, BYTE format, BYTE verify, BYTE mode, BYTE info, char *Label)
{
   saveall sa;
   struct dfree dfree;
   struct fatinfo fatinfo;
   PhysDataType PData;
   SpurenGraph SpGra;
   char lw_zeichen[ MAXDRIVE], Msg[ 100], T1[ 15], T2[ 15], T3[ 15];
   int ret_val, rad_per_spur, rad, wink, wink_per_sec, X_kl_Anz= 150, Y_kl_Anz= 260;
   long freedisk, maxfree;

   PrintStatus( "Drcken Sie ESC zum Abbrechen");
   setcolor( EGA_LIGHTGRAY);
   setfillstyle( SOLID_FILL, EGA_LIGHTGRAY);
   ShowMouse( AUS);
   pieslice( X+ 35, Y+ 293, 0, 90, 240);
   ClearTextN( X+ 216, Y+ 52, 4);
   GetFormatParameter( format, &PData, NULL);
   if( mode== GROSSE_ANZ)
   {
      rad_per_spur= 240/ PData.Spuren;
      setcolor( EGA_DARKGRAY);
      for( rad= 0; rad<= 240; rad+= rad_per_spur)
	 arc( X+ 35, Y+ 293, 0, 90, rad);
      rad-= rad_per_spur;
      line( X+ 35, Y+ 293, X+ 35, Y+ 293- rad);
      line( X+ 35, Y+ 293, X+ 35+ rad, Y+ 293);
      wink_per_sec= 360/ PData.Sektoren;
      setfillstyle( EMPTY_FILL, EGA_RED);
      for( wink= 0; wink<= 90- wink_per_sec; wink+= wink_per_sec)
	 pieslice( X+ 35, Y+ 293, wink, wink+ wink_per_sec, rad);
      ShowMouse( AN);
      SpGra.x= X+ 35;
      SpGra.y= Y+ 293;
      SpGra.rad= rad;
      SpGra.rad_per_spur= rad_per_spur;
   }
   else
   {
      PCX_Window( &X_kl_Anz, &Y_kl_Anz, PCX_FORMATIEREN_2, &sa, SHADOW);
      ShowDrive( X_kl_Anz+ 283, Y_kl_Anz+ 41, Laufwerksart( lw));
      sprintf( lw_zeichen, "%c:", lw+ 'A');
      setcolor( EGA_BLACK);
      outtextxy( X_kl_Anz+ 287, Y_kl_Anz+ 56, lw_zeichen);
      ShowMouse( AN);
      SpGra.xbal= X_kl_Anz+ 61;
      SpGra.ybal= Y_kl_Anz+ 39;
   }
   ret_val= _Format( lw, format, verify, SpGra, mode);
   if( !ret_val)
   {
      Hinweis( "Formatieren wurde erfolgreich beendet");
      if( info== AN)
      {
	 getfat( lw+ 1, &fatinfo);
	 getdfree( lw+ 1, &dfree);
	 if( dfree.df_sclus!= 0xFFFF)
	 {
	    freedisk= ( long)dfree.df_avail* ( long)dfree.df_bsec* ( long)dfree.df_sclus;
	    maxfree= ( long)fatinfo.fi_sclus* ( long)fatinfo.fi_nclus* ( long)fatinfo.fi_bysec;
	    sprintf( Msg, "%9s Byte maximal\n"
			  "%9s Byte defekt\n"
			  "%9s Byte nutzbar\n"
			  " \n"
			  "%5.1f%% sind in Ordnung", Tausender_Gruppen( T1, maxfree), Tausender_Gruppen( T2, maxfree- freedisk), Tausender_Gruppen( T3, freedisk), (( float)freedisk* 100.0)/ ( float)maxfree);
	    ReadySound();
	    Info_Frage( 220, 230, Msg, INFO);
	 }
	 else
	    ErrorMsg( "Konnte freie Diskkapazitt nicht feststellen");
      }
      else
	 ReadySound();
      SetLabel( lw, Label);
   }
   if( mode!= GROSSE_ANZ)
   {
      ShowMouse( AUS);
      BigScreenRestore( &sa, X_kl_Anz, Y_kl_Anz);
      ShowMouse( AN);
   }
   return( ret_val);
}

int Get_DiskLW_with_Format( char Format)  /* liefert Laufwerk, das dieses Format (egal ob 3" od. 5") verarbeiten kann */
{
   int LW, lw, Anz, x_lw= 200, y_lw= 250;
   char msg[ 65];

   for( lw= 0, Anz= 0; lw< 26; lw++)
   {
      if( !ExistLaufwerk( lw)&& !( Laufwerksart( lw)& FLOPPY_CODE)&& !LW_work_Format( DriveSize( lw), Format))
      {
	 LW= lw;
	 Anz++;
      }
   }
   if( Anz> 0)
   {
      if( Anz> 1)
      {
	 if(( LW= LW_Auswahl( &x_lw, &y_lw, "Diskette einlegen, und dieses Laufwerk anwhlen", Format, DRIVES_WITH_FORMAT))< 0)
	    LW= -2;
      }
      else
      {
	 sprintf( msg, "Legen Sie eine Dis-\nkette in Laufwerk %c:\nund drcken Sie >OK<", LW+ 'A');
	 if( Info_Frage( 200, 230, msg, INFO))
	    LW= -2;
      }
   }
   else
   {
      Info_Frage( 200, 230, "Sie besitzen kein\nLaufwerk, das dieses\nFormat verarbeitet.", INFO);
      LW= -1;
   }
   return( LW);          /* 0=A, 1=B, ... ,-1= es gibt kein LW, -2= Abbruch */
}

void Formatieren( void)
{
   int ret= 0;
   char LW, Label[ 13]= "", Verify= AN, Mode= GROSSE_ANZ, Info= AN, zu_Format= Default_Format;
   void *arg_ptr[ 9];
   char *msg[]= { "Dieser Name wird dem Datentrger nach dem Formatieren gegeben",
		  "eine 360 KByte Diskette formatieren",
		  "eine 1.2 MByte Diskette formatieren",
		  "eine 720 KByte Diskette formatieren",
		  "eine 1.44 MByte Diskette formatieren",
		  "eine 2.88 MByte Diskette formatieren",
		  "berprft die Diskettenspuren auf physikalische Schden",
		  "zeigt whrend des Formatierens sehr wenig an (schneller)",
		  "freie Diskkapazitt, verlorende Bytes, ..." };
   WORD mauspos[]= { BUTTON|      FRAME| KEY,                   5,  27,   5,  21, ESC,
		     INPUT|       FRAME| KEY|            MSG, 300,  51, 137,  11, 'n',
		     RADIOBUTTON| FRAME| KEY|            MSG, 307,  90, DD_525, 'd',
		     RADIOBUTTON| FRAME| KEY|            MSG, 307, 121, HD_525, '5',
		     RADIOBUTTON| FRAME| KEY|            MSG, 307, 153, DD_35,  '3',
		     RADIOBUTTON| FRAME| KEY|            MSG, 307, 187, HD_35,  'h',
		     RADIOBUTTON| FRAME| KEY|            MSG, 307, 221, ED_35,  'e',
		     CHECKBOX|    FRAME| KEY|            MSG, 301, 248, 's',
		     CHECKBOX|    FRAME| KEY|            MSG, 301, 267, 'k',
		     CHECKBOX|    FRAME| KEY|            MSG, 301, 286, 'i',
		     BUTTON|      FRAME| KEY,                 277, 351, 320, 362, RETURN,
		     BUTTON|      FRAME| KEY| DEFBUTTON,      361, 435, 320, 362, 'a',
		     MOVEWINDOW };
   MAUSStruct MS= { DEFAULT, DEFAULT, 455, 383, 13, INIT, NULL, AN};

   arg_ptr[ 0]= Label;
   arg_ptr[ 1]= arg_ptr[ 2]= arg_ptr[ 3]= arg_ptr[ 4]= arg_ptr[ 5]= &zu_Format;
   arg_ptr[ 6]= &Verify;
   arg_ptr[ 7]= &Mode;
   arg_ptr[ 8]= &Info;
   MS.x= &formauswx;
   MS.y= &formauswy;
   MS.msg= msg;
   MS.mauspos= mauspos;
   MS.arg_ptr= arg_ptr;
   PCX_Window( MS.x, MS.y, PCX_FORMATIEREN_1, &MS.sa, SHADOW);
   do
   {
      switch( __CheckMousepos( &MS))
      {
	 case 0:                                                     /* ESC */
	 case 11:                                                /* Abbruch */
	    ret= 1;
	    break;
	 case 10:                                                 /* Return */
	    if(( LW= Get_DiskLW_with_Format( zu_Format))>= 0)
	       MakeFormat( *MS.x, *MS.y, LW, zu_Format, Verify, Mode, Info, Label);
	    break;
      }
   }while( !ret);
   ShowMouse( AUS);
   BigScreenRestore( &MS.sa, *MS.x, *MS.y);
   ShowMouse( AN);
}

int LW2makeLW1( BYTE lw1, BYTE lw2)
{
   switch( lw1)
   {
      case DD_525:
	 if(( lw2== DD_525)|| ( lw2== HD_525))
	    return( 0);
	 break;
      case HD_525:
	 if( lw2== HD_525)
	    return( 0);
	 break;
      case DD_35:
	 if(( lw2== DD_35)|| ( lw2== HD_35)|| ( lw2== ED_35))
	    return( 0);
	 break;
      case HD_35:
	 if(( lw2== HD_35)|| ( lw2== ED_35))
	    return( 0);
	 break;
      case ED_35:
	 if( lw2== ED_35)
	    return( 0);
	 break;
   }
   return( -1);
}

int LW_work_Format( BYTE lw_size, BYTE Format)
{
   switch( Format)
   {
      case DD_525:            /* kann von jedem Laufwerk verarbeitet werden */
	 return( 0);
      case HD_525:
	 if(( lw_size== HD_525)|| ( lw_size== HD_35)|| ( lw_size== ED_35))
	    return( 0);
	 break;
      case DD_35:
	 if(( lw_size== HD_525)|| ( lw_size== DD_35)|| ( lw_size== HD_35)|| ( lw_size== ED_35))
	    return( 0);
	 break;
      case HD_35:
	 if(( lw_size== HD_35)|| ( lw_size== ED_35))
	    return( 0);
	 break;
      case ED_35:
	 if( lw_size== ED_35)
	    return( 0);
	 break;
   }
   return( -1);
}

void Disk_Auffrischen_Pruefen( BYTE auff_puef)
{
   int status, ret= 0, lw= Default_DiskDrive, x_lw= 200, y_lw= 200;
   char tmp_array[ MAXDRIVE], Verify= Default_Verify;
   void *arg_ptr[ 1];
   char *Auff_msg[]= { "Die Spuren der Disk werden nach dem Beschreiben berprft" };
   WORD Auff_mauspos[]= { BUTTON|     FRAME| KEY,                   5,  27,   5,  21, ESC,
			  BUTTON2|    FRAME| KEY,                  22,  42,  45,  56, 'd',
			  BUTTON|     FRAME| KEY| DEFBUTTON,      200, 274, 259, 301, RETURN,
			  BUTTON|     FRAME| KEY,                 285, 359, 259, 301, 'a',
			  CHECKBOX|   FRAME| KEY|            MSG, 200, 196, 's',
			  MOVEWINDOW },
	Pruef_mauspos[]= { BUTTON|     FRAME| KEY,                   5,  27,   5,  21, ESC,
			   BUTTON2|    FRAME| KEY,                  22,  42,  45,  56, 'd',
			   BUTTON|     FRAME| KEY| DEFBUTTON,      200, 274, 199, 241, RETURN,
			   BUTTON|     FRAME| KEY,                 285, 359, 199, 241, 'a',
			   MOVEWINDOW };
   MAUSStruct MS= { DEFAULT, DEFAULT, 380, DEFAULT, DEFAULT, INIT, NULL, DEFAULT};

   if( auff_puef== AUFFRISCHEN)
   {
      arg_ptr[ 0]= &Verify;
      MS.x= &diskauff_X;
      MS.y= &diskauff_Y;
      MS.ylength= 320;
      MS.spotanz= 6;
      MS.statzeile= AN;
      MS.msg= Auff_msg;
      MS.arg_ptr= arg_ptr;
      MS.mauspos= Auff_mauspos;
      PCX_Window( MS.x, MS.y, PCX_DISKAUFFRISCHEN, &MS.sa, SHADOW);
   }
   else
   {
      MS.x= &diskpruef_X;
      MS.y= &diskpruef_Y;
      MS.ylength= 262;
      MS.spotanz= 5;
      MS.statzeile= AUS;
      MS.mauspos= Pruef_mauspos;
      PCX_Window( MS.x, MS.y, PCX_DISKPRUEFEN, &MS.sa, SHADOW);
   }
   do
   {
      ret= 0;
      ShowMouse( AUS);
      ShowDrive( *MS.x+ 22, *MS.y+ 45, Laufwerksart( lw));
      setcolor( EGA_BLACK);
      ClearTextN( *MS.x+ 47, *MS.y+ 48, 2);
      sprintf( tmp_array, "%c:", lw+ 'A');
      outtextxy( *MS.x+ 47, *MS.y+ 48, tmp_array);
      ShowMouse( AN);
      do
      {
	 switch( __CheckMousepos( &MS))
	 {
	    case 0:                                                  /* ESC */
	    case 3:                                              /* Abbruch */
	       ret= ABBRUCH;
	       break;
	    case 1:
	       if(( status= LW_Auswahl( &x_lw, &y_lw, "Laufwerk auswhlen", A_FLOPPY_525| A_FLOPPY_35, SPEZ_DRIVES))>= 0)
	       {
		  lw= status;
		  ret= NOCHMAL;
		  MS.statsp= REINIT;
	       }
	       break;
	    case 2:                                               /* Return */
	       if( !DiskReady( lw))
		  _Disk_auff_pruefen( *MS.x, *MS.y, auff_puef, lw, Verify);
	       break;
	 }
      }while( !ret);
   }while( ret!= ABBRUCH);
   ShowMouse( AUS);
   BigScreenRestore( &MS.sa, *MS.x, *MS.y);
   ShowMouse( AN);
}

void Work_Char( int X, int Y, char Mode)
{
   setcolor( EGA_BLACK);
   switch( Mode)
   {
      case FORMATIEREN:
      case SCHREIBEN:
	 line( X+ 5, Y+ 4, X+ 7, Y+ 4);
	 putpixel( X+ 6, Y+ 5, EGA_BLACK);
	 break;
      case UEBERPRUEFEN:
      case LESEN:
	 putpixel( X+ 6, Y+ 4, EGA_BLACK);
	 line( X+ 5, Y+ 5, X+ 7, Y+ 5);
	 break;
      case FERTIG:
      case IDENTISCH:
	 line( X+ 5, Y+ 4, X+ 7, Y+ 4);
	 line( X+ 6, Y+ 3, X+ 6, Y+ 5);
	 break;
      case DEFEKT:
      case VERSCHIEDEN:
	 line( X+ 5, Y+ 3, X+ 7, Y+ 5);
	 line( X+ 5, Y+ 5, X+ 7, Y+ 3);
	 break;
   }
}

void Work_Track( int X, int Y, int Seite, int Track, char Mode) /* 0-1, 0-79 */
{
   int Tx, Ty, rest;
   char FillColor[]= { EGA_BLUE,                             /* FORMATIEREN */
		       EGA_BROWN,                           /* UEBERPRUEFEN */
		       EGA_YELLOW,                             /* SCHREIBEN */
		       EGA_YELLOW,                                 /* LESEN */
		       EGA_LIGHTGREEN,                            /* FERTIG */
		       EGA_RED,                                   /* DEFEKT */
		       EGA_LIGHTGRAY,                               /* FREI */
		       EGA_LIGHTGREEN,                         /* IDENTISCH */
		       EGA_LIGHTGRAY };                      /* VERSCHIEDEN */

   Ty= Y+ (( rest= ( Track/ 10))* 13)+ 79;
   ( Seite) ? ( Tx= X+ (( Track- ( rest* 10))* 16)+ 201) : ( Tx= X+ (( Track- ( rest* 10))* 16)+ 23);
   setfillstyle( SOLID_FILL, FillColor[ Mode]);
   ShowMouse( AUS);
   bar( Tx, Ty, Tx+ 11, Ty+ 8);
   Work_Char( Tx, Ty, Mode);
   ShowMouse( AN);
}

int _Disk_auff_pruefen( int X, int Y, BYTE auff_puef, BYTE lw, BOOL Verify)
{
   PhysDataType PData;                     /* physikalische Formatparameter */
   LogDataType  LData;                          /* logische Formatparameter */
   void interrupt ( *AlteDDPT)();                   /* Zeiger auf alte DDPT */
   int ret_val= 0, status, Format, writelen;
   BYTE *mem_ptr, spur, seite;
   BOOL Pruefen= AN;
   char	*_format[]= { " 360 KB", " 1.2 MB", " 720 KB", " 1.44 MB", " 2.88 MB" };

   if((( Format= GetDiskSize( lw))>= DD_525)&& ( Format<= ED_35))
   {
      MOverTextxy( X+ 261, Y+ 46, _format[ Format- 1], 9);
      GetFormatParameter( Format, &PData, &LData);
      writelen= 512* PData.Sektoren;                   /* Sektoren pro Spur */
      if( !(( auff_puef== AUFFRISCHEN)&& (( mem_ptr= malloc( writelen))== NULL)))
      {
	 if( auff_puef== AUFFRISCHEN)
	 {
	    DiskPrepare( lw, PData.Spuren- 1, PData.Sektoren);
	    AlteDDPT= getvect( 0x1E);                   /* Alte DDPT merken */
	    setvect( 0x1E, ( void interrupt(*)())PData.DDPT);  /* Neue DDPT Setzen */
	 }
	 for( spur= 0; spur< 80; spur++)
	    for( seite= 0; seite< 2; seite++)
	       Work_Track( X, Y, seite, spur, FREI);
	 for( spur= 0; ( spur< PData.Spuren)&& !ret_val; spur++)
	 {
	    for( seite= 0; ( seite< PData.Seiten)&& !ret_val; seite++)
	    {
	       if( Break( 200, 275, "Soll das Bearbeiten\nder Diskette wirklich\nabgebrochen werden ?"))
		  ret_val= -1;
	       else
	       {
		  if( auff_puef== AUFFRISCHEN)
		  {
		     Work_Track( X, Y, seite, spur, LESEN);
		     status= ReadTrack( lw, seite, spur, 1, PData.Sektoren, mem_ptr);
		  }
		  else
		  {
		     Work_Track( X, Y, seite, spur, UEBERPRUEFEN);
		     if((( status= VerifyTrack( lw, seite, spur, PData.Sektoren, &Pruefen))== 0xBB)|| ( Pruefen== AUS)) /* Abbruch wegen Speichermangels */
		     {
			ret_val= -1;
			break;
		     }
		  }
		  if( !status&& ( auff_puef== AUFFRISCHEN))
		  {
		     Work_Track( X, Y, seite, spur, FORMATIEREN);
		     while((( status= FormatTrack( lw, seite, spur, PData.Sektoren))== 0x03)&& ( !( ret_val= Info_Frage( 100, 200, "Diese Diskette ist\nschreibgeschtzt. Ent-\nfernen Sie den\nSchreibschutz.", INFO))))
			;
		     if( !status)
		     {
			Work_Track( X, Y, seite, spur, SCHREIBEN);
			status= WriteTrack( lw, seite, spur, 1, PData.Sektoren, mem_ptr);
			if( !status&& ( Verify== AN))
			{
			   Work_Track( X, Y, seite, spur, UEBERPRUEFEN);
			   if(( status= VerifyTrack( lw, seite, spur, PData.Sektoren, &Verify))== 0xBB) /* Abbruch wegen Speichermangels */
			      ret_val= -1;
			}
		     }
		  }
		  if( status)
		  {
		     if( status== 0x80)
		     {
			ErrorMsg( "Laufwerk reagiert nicht (eventuell keine Disk im Laufwerk)");
			ret_val= -1;
		     }
		     else
			Work_Track( X, Y, seite, spur, DEFEKT);
		  }
		  else
		     Work_Track( X, Y, seite, spur, FERTIG);
	       }
	    }
	 }
	 if( auff_puef== AUFFRISCHEN)
	 {
	    setvect( 0x1E, AlteDDPT);             /* Alte DDPT restaurieren */
	    free( mem_ptr);
	 }
      }
      else
      {
	 ErrorMsg( KEIN_SPEICHER);
	 ret_val= -1;
      }
   }
   else
   {
      ErrorMsg( "Das Format der Quelldiskette wird nicht untersttzt");
      ret_val= -1;
   }
   if( ret_val== 0)
      ReadySound();
   return( ret_val);
}

int _Disk_loeschen( int X, int Y, int lw, BYTE verify, BYTE overwrite)
{
   PhysDataType PData;                     /* physikalische Formatparameter */
   int ret_val= 0, writelen, status, l, FAT_Beginn, Format;
   WORD Root_Sektoren;
   BYTE *mem_ptr, *next_FAT_ID, spur, seite, Anz_FATs, Sektoren_FAT, Media_ID;
   char	*_format[]= { " 360 KB", " 1.2 MB", " 720 KB", " 1.44 MB", " 2.88 MB" };

   if((( Format= GetDiskSize( lw))>= DD_525)&& ( Format<= ED_35))
   {
      MOverTextxy( X+ 261, Y+ 46, _format[ Format- 1], 9);
      GetFormatParameter( Format, &PData, NULL);
      writelen= ( WORD)PData.Sektoren<< 9;
      if(( mem_ptr= malloc( writelen))!= NULL)
      {
	 for( spur= 0; spur< 80; spur++)
	    for( seite= 0; seite< 2; seite++)
	       Work_Track( X, Y, seite, spur, FREI);
	 for( spur= 0; ( spur< PData.Spuren)&& !ret_val; spur++)
	 {
	    for( seite= 0; ( seite< PData.Seiten)&& !ret_val; seite++)
	    {
	       if( Break( 200, 275, "Soll das Bearbeiten\nder Diskette wirklich\nabgebrochen werden ?"))
		  ret_val= -1;
	       else
	       {
		  if(( spur== 0)&& ( seite== 0))
		  {
		     Work_Track( X, Y, seite, spur, LESEN);
		     if( !absread( lw, 1, 0L, mem_ptr))
		     {
			FAT_Beginn=   *( WORD *)( mem_ptr+ 0x0E);
			Anz_FATs=              *( mem_ptr+ 0x10);
			Media_ID=              *( mem_ptr+ 0x15);
			Sektoren_FAT= *( WORD *)( mem_ptr+ 0x16);
			if( !overwrite)
			{
			   Work_Track( X, Y, seite, spur, SCHREIBEN);
			   Root_Sektoren= *( WORD *)( mem_ptr+ 0x11)>> 4;
			   memset( mem_ptr, 0, Sektoren_FAT* 512);
			   *mem_ptr= Media_ID;
			   *( WORD *)( mem_ptr+ 1)= 0xFFFF;
			   for( l= 0; l< Anz_FATs; l++, FAT_Beginn+= Sektoren_FAT)
			   {
			      if(( status= abswrite( lw, Sektoren_FAT, FAT_Beginn, mem_ptr))!= 0)
				 break;
			   }
			   if( status== 0)
			   {
			      memset( mem_ptr, 0, ( WORD)Root_Sektoren<< 9);
			      status= abswrite( lw, Root_Sektoren, FAT_Beginn, mem_ptr);
			   }
			   if( status)
			      Work_Track( X, Y, seite, spur, DEFEKT);
			   else
			      Work_Track( X, Y, seite, spur, FERTIG);
			   ret_val= 1;
			   break;
			}
		     }
		     else
		     {
			Work_Track( X, Y, seite, spur, DEFEKT);
			ErrorMsg( "Konnte erste Spur nicht lesen. Fortfahren deshalb unmglich");
			ret_val= -1;
			break;
		     }
		     next_FAT_ID= mem_ptr+ ( ( WORD)FAT_Beginn<< 9);
		     memset( next_FAT_ID, 0, writelen- ( next_FAT_ID- mem_ptr));
		  }
		  else
		  {
		     memset( mem_ptr, 0, writelen);
		  }
		  for( ; Anz_FATs> 0; Anz_FATs--)
		  {
		     if( next_FAT_ID> ( mem_ptr+ writelen))
		     {
			next_FAT_ID-= writelen;
			break;
		     }
		     *next_FAT_ID= Media_ID;
		     *( WORD *)( next_FAT_ID+ 1)= 0xFFFF;
		     next_FAT_ID+= ( WORD)Sektoren_FAT<< 9;
		  }
		  Work_Track( X, Y, seite, spur, SCHREIBEN);
		  status= WriteTrack( lw, seite, spur, 1, PData.Sektoren, mem_ptr);
		  if( !status&& ( verify== AN))
		  {
		     Work_Track( X, Y, seite, spur, UEBERPRUEFEN);
		     if(( status= VerifyTrack( lw, seite, spur, PData.Sektoren, &verify))== 0xBB) /* Abbruch wegen Speichermangels */
			ret_val= -1;
		  }
		  if( status)
		  {
		     if( status== 0x80)
		     {
			ErrorMsg( "Laufwerk reagiert nicht (eventuell keine Disk im Laufwerk)");
			ret_val= -1;
		     }
		     else
			Work_Track( X, Y, seite, spur, DEFEKT);
		  }
		  else
		     Work_Track( X, Y, seite, spur, FERTIG);
	       }
	    }
	 }
	 free( mem_ptr);
      }
      else
      {
	 ErrorMsg( KEIN_SPEICHER);
	 ret_val= -1;
      }
   }
   else
   {
      ErrorMsg( "Das Format der Quelldiskette wird nicht untersttzt");
      ret_val= -1;
   }
   if( ret_val== 0)
      ReadySound();
   return( ret_val);
}

void Disk_Loeschen( void)
{
   int status, ret= 0, lw= Default_DiskDrive, x_lw= 200, y_lw= 200;
   char tmp_array[ 180], Verify= Default_Verify, Komplett= 0;
   void *arg_ptr[ 2];
   char *msg[]= { "Die Spuren der Disk werden nach dem Beschreiben berprft",
		  "Alle Spuren der Disk werden komplett mit NULL berschrieben" };
   WORD mauspos[]= { BUTTON|     FRAME| KEY,                   5,  27,   5,  21, ESC,
		     BUTTON2|    FRAME| KEY,                  22,  42,  45,  56, 'd',
		     CHECKBOX|   FRAME| KEY|            MSG, 200, 196, 's',
		     CHECKBOX|   FRAME| KEY|            MSG, 200, 215, 'i',
		     BUTTON|     FRAME| KEY| DEFBUTTON,      200, 274, 239, 281, RETURN,
		     BUTTON|     FRAME| KEY,                 285, 359, 239, 281, 'a',
		     MOVEWINDOW };
   MAUSStruct MS= { DEFAULT, DEFAULT, 380, 302, 7, INIT, NULL, AN};

   arg_ptr[ 0]= &Verify;
   arg_ptr[ 1]= &Komplett;
   MS.x= &diskloeschen_X;
   MS.y= &diskloeschen_Y;
   MS.msg= msg;
   MS.arg_ptr= arg_ptr;
   MS.mauspos= mauspos;
   PCX_Window( MS.x, MS.y, PCX_DISKLOESCHEN, &MS.sa, SHADOW);
   do
   {
      ret= 0;
      ShowMouse( AUS);
      ShowDrive( *MS.x+ 22, *MS.y+ 45, Laufwerksart( lw));
      setcolor( EGA_BLACK);
      ClearTextN( *MS.x+ 47, *MS.y+ 48, 2);
      sprintf( tmp_array, "%c:", lw+ 'A');
      outtextxy( *MS.x+ 47, *MS.y+ 48, tmp_array);
      ShowMouse( AN);
      do
      {
	 switch( __CheckMousepos( &MS))
	 {
	    case 0:                                                  /* ESC */
	    case 5:                                              /* Abbruch */
	       ret= ABBRUCH;
	       break;
	    case 1:
	       if(( status= LW_Auswahl( &x_lw, &y_lw, "Laufwerk auswhlen", A_FLOPPY_525| A_FLOPPY_35, SPEZ_DRIVES))>= 0)
	       {
		  lw= status;
		  ret= NOCHMAL;
		  MS.statsp= REINIT;
	       }
	       break;
	    case 4:                                               /* Return */
	       sprintf( tmp_array, "Soll das Laufwerk %c:\nwirklich komplett\ngelscht werden ?", lw+ 'A');
	       if( Info_Frage( 300, 250, tmp_array, FRAGE)== 0)
	       {
		  if( !DiskReady( lw))
		     _Disk_loeschen( *MS.x, *MS.y, lw, Verify, Komplett);
	       }
	       break;
	 }
      }while( !ret);
   }while( ret!= ABBRUCH);
   ShowMouse( AUS);
   BigScreenRestore( &MS.sa, *MS.x, *MS.y);
   ShowMouse( AN);
}

void DCopy_DComp( BYTE Copy_Comp)
{
   int status, ret= 0, Q_lw= Default_DiskDrive, Z_lw= Default_DiskDrive, x_lw= 200, y_lw= 200;
   char tmp_array[ MAXDRIVE], Format= AUS, DatNum= AN, Quick= AN, Verify= Default_Verify;
   void *arg_ptr[ 4];
   char *Copy_msg[]= { "Die Spuren der Zieldisk werden nach dem Beschreiben berprft",
		       "Die Sektoren der Zieldisk werden vor dem Beschreiben formatiert",
		       "Die Zieldisk bekommt eine neue Datentrgernummer",
		       "Es werden nur belegte Spuren der Quelldisk kopiert" },
	*Comp_msg[]= { "Die Datentrgernummer wird vom Vergleich ausgeschlossen",
		       "Es werden nur die belegten Spuren des Originals verglichen" };
   WORD Copy_mauspos[]= { BUTTON|   FRAME| KEY,                   5,  27,   5,  21, ESC,
			  BUTTON2|  FRAME| KEY,                  22,  42,  33,  44, 'q',
			  BUTTON2|  FRAME| KEY,                  22,  42,  53,  64, 'z',
			  BUTTON|   FRAME| KEY| DEFBUTTON,      200, 274, 279, 321, RETURN,
			  BUTTON|   FRAME| KEY,                 285, 359, 279, 321, 'a',
			  CHECKBOX| FRAME| KEY|            MSG, 200, 196, 's',
			  CHECKBOX| FRAME| KEY|            MSG, 200, 215, 'f',
			  CHECKBOX| FRAME| KEY|            MSG, 200, 234, 'd',
			  CHECKBOX| FRAME| KEY|            MSG, 200, 253, 'i',
			  MOVEWINDOW },
	Comp_mauspos[]= { BUTTON|   FRAME| KEY,                   5,  27,   5,  21, ESC,
			  BUTTON2|  FRAME| KEY,                  22,  42,  33,  44, '1',
			  BUTTON2|  FRAME| KEY,                  22,  42,  53,  64, '2',
			  BUTTON|   FRAME| KEY| DEFBUTTON,      200, 274, 259, 301, RETURN,
			  BUTTON|   FRAME| KEY,                 285, 359, 259, 301, 'a',
			  CHECKBOX| FRAME| KEY|            MSG, 200, 196, 'd',
			  CHECKBOX| FRAME| KEY|            MSG, 200, 215, 'i',
			  MOVEWINDOW };
   MAUSStruct MS= { DEFAULT, DEFAULT, 380, DEFAULT, DEFAULT, INIT, NULL, AN};

   if( Copy_Comp== KOPIE)
   {
      arg_ptr[ 0]= &Verify;
      arg_ptr[ 1]= &Format;
      arg_ptr[ 2]= &DatNum;
      arg_ptr[ 3]= &Quick;
      MS.x= &dcopy_X;
      MS.y= &dcopy_Y;
      MS.ylength= 340;
      MS.spotanz= 10;
      MS.msg= Copy_msg;
      MS.arg_ptr= arg_ptr;
      MS.mauspos= Copy_mauspos;
      PCX_Window( MS.x, MS.y, PCX_DISKKOPIEREN, &MS.sa, SHADOW);
   }
   else
   {
      arg_ptr[ 0]= &DatNum;
      arg_ptr[ 1]= &Quick;
      MS.x= &dcomp_X;
      MS.y= &dcomp_Y;
      MS.ylength= 320;
      MS.spotanz= 8;
      MS.msg= Comp_msg;
      MS.arg_ptr= arg_ptr;
      MS.mauspos= Comp_mauspos;
      PCX_Window( MS.x, MS.y, PCX_DISKVERGLEICHEN, &MS.sa, SHADOW);
   }
   do
   {
      ret= 0;
      ShowMouse( AUS);
      ShowDrive( *MS.x+ 22, *MS.y+ 33, Laufwerksart( Q_lw));
      ShowDrive( *MS.x+ 22, *MS.y+ 53, Laufwerksart( Z_lw));
      setcolor( EGA_BLACK);
      ClearTextN( *MS.x+ 47, *MS.y+ 36, 2);
      ClearTextN( *MS.x+ 47, *MS.y+ 56, 2);
      sprintf( tmp_array, "%c:", Q_lw+ 'A');
      outtextxy( *MS.x+ 47, *MS.y+ 36, tmp_array);
      sprintf( tmp_array, "%c:", Z_lw+ 'A');
      outtextxy( *MS.x+ 47, *MS.y+ 56, tmp_array);
      ShowMouse( AN);
      do
      {
	 switch( __CheckMousepos( &MS))
	 {
	    case 0:                                               /* ESC */
	    case 4:                                           /* Abbruch */
	       ret= ABBRUCH;
	       break;
	    case 1:
	       if(( status= LW_Auswahl( &x_lw, &y_lw, "Quellaufwerk auswhlen", A_FLOPPY_525| A_FLOPPY_35, SPEZ_DRIVES))>= 0)
	       {
		  Q_lw= status;
		  ret= NOCHMAL;
		  MS.statsp= REINIT;
	       }
	       break;
	    case 2:
	       if(( status= LW_Auswahl( &x_lw, &y_lw, "Ziellaufwerk auswhlen", A_FLOPPY_525| A_FLOPPY_35, SPEZ_DRIVES))>= 0)
	       {
		  Z_lw= status;
		  ret= NOCHMAL;
		  MS.statsp= REINIT;
	       }
	       break;
	    case 3:                                               /* Return */
	       if( !DiskReady( Q_lw))
		  DKopie_Vergleich( *MS.x, *MS.y, Q_lw, Z_lw, Copy_Comp, Format, DatNum, Quick, Verify);
	       break;
	 }
      }while( !ret);
   }while( ret!= ABBRUCH);
   ShowMouse( AUS);
   BigScreenRestore( &MS.sa, *MS.x, *MS.y);
   ShowMouse( AN);
}

#define FAT_FREI   0x00
#define FAT_DEFEKT 0x01
#define FAT_BELEGT 0x02

BYTE Make_FAT_Array( WORD FAT_Code, BYTE *Array_p)
{
   switch( FAT_Code)
   {
      case UNBENUTZT:
	 return( FAT_FREI);
      case FEHLERHAFT:
	 *Array_p|= FAT_DEFEKT;
	 return( FAT_DEFEKT);
   }
   *Array_p|= FAT_BELEGT;
   return( FAT_BELEGT);
}

int Disk_Copy_Comp_Read( BYTE Copy_Comp, int X, int Y, BYTE lw, BYTE seite, BYTE spur, BYTE *mem_ptr, BOOL Quick, BYTE *Quick_Seite_Spur[ 2][ 80], BYTE Sektoren, BYTE *Spur_ok)
{
   int status;
   BYTE Q_Sektor, *tmp_ptr;

   Work_Track( X, Y, seite, spur, LESEN);
   if(( Quick== AN)&& ( Quick_Seite_Spur[ seite][ spur]!= NULL)&& ( *Quick_Seite_Spur[ seite][ spur]& FAT_DEFEKT))
   {
      tmp_ptr= mem_ptr;
      for( Q_Sektor= 1; Q_Sektor<= Sektoren; Q_Sektor++, tmp_ptr+= 512)
      {
	 if(( Quick_Seite_Spur[ seite][ spur]!= NULL)&& ( *( Quick_Seite_Spur[ seite][ spur]+ Q_Sektor)== FAT_BELEGT))
	 {
	    if(( status= ReadTrack( lw, seite, spur, Q_Sektor, 1, tmp_ptr))== 0x80)
	       break;                                  /* LW reagiert nicht */
	    else
	    {
	       if( status)
	       {
		  memset( tmp_ptr, 0xF6, 512);
		  *Spur_ok= 0;
	       }
	    }
	 }
	 else
	    memset( tmp_ptr, 0xF6, 512);
      }
   }
   else
   {
      if((( status= ReadTrack( lw, seite, spur, 1, Sektoren, mem_ptr))!= 0x80)&& status)
      {
	 if( Copy_Comp== KOPIE)
	 {
	    tmp_ptr= mem_ptr;
	    for( Q_Sektor= 1; Q_Sektor<= Sektoren; Q_Sektor++, tmp_ptr+= 512)
	    {
	       if( ReadTrack( lw, seite, spur, Q_Sektor, 1, tmp_ptr))
	       {
		  memset( tmp_ptr, 0xF6, 512);
		  *Spur_ok= 0;
	       }
	    }
	 }
	 else
	    *Spur_ok= 0;
      }
   }
   return( status);
}

int DKopie_Vergleich( int X, int Y, BYTE Q_lw, BYTE Z_lw, BYTE Copy_Comp, BOOL Format, BOOL DatNum, BOOL Quick, BOOL Verify)         /* 0= A */
{
   FILE *tmp_File= NULL;
   PhysDataType PData;                     /* physikalische Formatparameter */
   LogDataType  LData;                          /* logische Formatparameter */
   struct dfree dfree;
   void interrupt ( *AlteDDPT)();                   /* Zeiger auf alte DDPT */
   int ret_val= 0, status, Q_Format, Z_Format, ok, writelen, spur, seite,
       XMS_handle= 0, write_words;
   WORD FAT_Code, Code_Merker;
   BYTE *mem_ptr, *Comp_ptr, *tmp_ptr, *FAT_ptr, Q_Spur, Q_Seite, Q_Sektor, Sektoren_pro_Cluster,
	Daten_ab_Sektor, Cluster_Code[ 1+ 36], Sekt_Cluster, Spur_ok,
	*Quick_Seite_Spur[ 2][ 80]= { NULL}; /* max. 80 Spuren auf 2 Seiten */
   BOOL HalfBYTE= 0, Sektor_OV= 0, Zielformat_nicht_identisch= 0, First= 1,
	_identisch= 1, Platte_frei= 0;
   char	*_format[]= { " 360 KB", " 1.2 MB", " 720 KB", " 1.44 MB", " 2.88 MB" },
	*Nochmal[]= { "Noch ein Duplikat der\nQuelldiskette anferti-\ngen ?",
		      "Noch eine Diskette mit\nder 1. Diskette ver-\ngleichen ?" };
   long XMS_offset= 0L,
	Freemem_Format[]= {  400000L,                             /* DD_525 */
			    1300000L,                             /* HD_525 */
			     800000L,                              /* DD_35 */
			    1600000L,                              /* HD_35 */
			    3100000L };                            /* ED_35 */

   if((( Q_Format= GetDiskSize( Q_lw))>= DD_525)&& ( Q_Format<= ED_35))
   {
      MOverTextxy( X+ 261, Y+ 46, _format[ Q_Format- 1], 9);
      getdfree( toupper( prgexe_path[ 0])- 64, &dfree);
      if( XMSTreiber)
	 XMS_handle= XMSGetMem( ( int)( Freemem_Format[ Q_Format- 1]/ 1024L));
      if( !XMS_handle)
	 Platte_frei= ((( long)dfree.df_avail* ( long)dfree.df_bsec* ( long)dfree.df_sclus)>= Freemem_Format[ Q_Format- 1]);
      if( XMS_handle| Platte_frei)
      {
	 if( !LW_work_Format( DriveSize( Z_lw), Q_Format))
	 {
	    if( !XMS_handle)
	       tmp_File= tmpfile();
	    if( XMS_handle|| ( tmp_File!= NULL))
	    {
	       GetFormatParameter( Q_Format, &PData, &LData);
	       writelen= 512* PData.Sektoren;          /* Sektoren pro Spur */
	       write_words= writelen>> 1;
	       if( !(( Copy_Comp== VERGLEICH)&& (( Comp_ptr= malloc( writelen))== NULL)))
	       {
		  if(( mem_ptr= malloc( writelen))!= NULL)
		  {
		     for( spur= 0; spur< 80; spur++)
			for( seite= 0; seite< 2; seite++)
			   Work_Track( X, Y, seite, spur, FREI);
		     for( spur= 0; ( spur< PData.Spuren)&& !ret_val; spur++)
		     {
			for( seite= 0; ( seite< PData.Seiten)&& !ret_val; seite++)
			{
			   if( Break( 200, 275, "Soll das Bearbeiten\nder Diskette wirklich\nabgebrochen werden ?"))
			      ret_val= -1;
			   else
			   {
			      Spur_ok= 1;
			      if((( Quick== AN)&& ( Quick_Seite_Spur[ seite][ spur]!= NULL)&& ( *Quick_Seite_Spur[ seite][ spur]& FAT_BELEGT))|| ( Quick== AUS)|| ( spur== 0))
			      {
				 status= Disk_Copy_Comp_Read( Copy_Comp, X, Y, Q_lw, seite, spur, mem_ptr, Quick, Quick_Seite_Spur, PData.Sektoren, &Spur_ok);
				 if( !Spur_ok)
				 {
				    Work_Track( X, Y, seite, spur, DEFEKT);
				    if( Copy_Comp== VERGLEICH)
				    {
				       Info_Frage( 100, 200, "Die 1. Diskette konnte\nnicht gelesen werden.\nEin Vergleich kann\ndeshalb nicht statt-\nfinden.", INFO);
				       ret_val= -1;
				       break;
				    }
				 }
				 if( status!= 0x80)
				 {
				    if( XMS_handle)
				    {
				       XMSCopy( 0, ( long)(( void far *)mem_ptr), XMS_handle, XMS_offset, write_words);
				       XMS_offset+= write_words<< 1;
				    }
				    else
				    {
				       if( fwrite( mem_ptr, 1, writelen, tmp_File)!= writelen)
				       {
					  ErrorMsg( WRITE_ERROR"TMP");
					  ret_val= -1;
				       }
				    }
				    if( !ret_val)            /* kein Fehler */
				    {
				       if(( Quick== AN)&& ( spur== 0)&& ( seite== 0)) /* Bootsektor mit FAT's*/
				       {
					  Sektoren_pro_Cluster= *( mem_ptr+ 0x0D);
					  Daten_ab_Sektor= *( mem_ptr+ 0x0E)+ ( *( mem_ptr+ 0x16)* *( mem_ptr+ 0x10))+ ( *( mem_ptr+ 0x11)>> 4);
					  FAT_ptr= mem_ptr+ 3+ ((( WORD)*( mem_ptr+ 0x0E)+ (( WORD)*( mem_ptr+ 0x0F)<< 8))<< 9);
					  Q_Spur= ( Daten_ab_Sektor/ PData.Sektoren)>> 1;
					  Q_Seite= ( Daten_ab_Sektor/ PData.Sektoren)& 1;
					  Q_Sektor= ( Daten_ab_Sektor+ 1)- (( Daten_ab_Sektor/ PData.Sektoren)* PData.Sektoren);
					  for( ; ( Q_Spur< PData.Spuren)&& !ret_val; Q_Spur++)
					  {
					     for( ; ( Q_Seite< PData.Seiten)&& !ret_val; Q_Seite++)
					     {
						if(( Quick_Seite_Spur[ Q_Seite][ Q_Spur]= farcalloc( PData.Sektoren+ 1, 1))!= NULL)
						{
						   for( ; Q_Sektor<= PData.Sektoren; Q_Sektor+= Sektoren_pro_Cluster)
						   {
						      if( Sektor_OV)
						      {
							 Sektor_OV= 0;
							 *( Quick_Seite_Spur[ Q_Seite][ Q_Spur]+ 1)= Make_FAT_Array( Code_Merker, Quick_Seite_Spur[ Q_Seite][ Q_Spur]);
							 Q_Sektor--;
						      }
						      else
						      {
							 if( !HalfBYTE)
							 {
							    FAT_Code= ( *( WORD *)( FAT_ptr++))& 0x0FFF;
							    HalfBYTE= 1;
							 }
							 else
							 {
							    FAT_Code= ( *( WORD *)FAT_ptr)>> 4;
							    FAT_ptr+= 2;
							    HalfBYTE= 0;
							 }
							 for( Sekt_Cluster= 0; Sekt_Cluster< Sektoren_pro_Cluster; Sekt_Cluster++)
							 {
							    if(( Q_Sektor+ Sekt_Cluster)<= PData.Sektoren)
							       *( Quick_Seite_Spur[ Q_Seite][ Q_Spur]+ Q_Sektor+ Sekt_Cluster)= Make_FAT_Array( FAT_Code, Quick_Seite_Spur[ Q_Seite][ Q_Spur]);
							    else
							    {
							       Sektor_OV= 1;
							       Code_Merker= FAT_Code;
							    }
							 }
						      }
						   }
						   Q_Sektor= 1;
						}
						else
						{
						   for( spur= 0; spur< Q_Spur; spur++)
						      for( seite= 0; seite< PData.Seiten; seite++)
							 free( Quick_Seite_Spur[ seite][ spur]);
						   if( Q_Seite== 1)
						      free( Quick_Seite_Spur[ 0][ Q_Spur]);
						   ErrorMsg( KEIN_SPEICHER" ('Quick' ausschalten)");
						   ret_val= -1;
						}
					     }
					     Q_Seite= 0;
					  }
				       }
				    }
				 }
				 else
				 {
				    ErrorMsg( "Laufwerk reagiert nicht (eventuell keine Disk im Laufwerk)");
				    ret_val= -1;
				 }
			      }
			      if( !ret_val&& Spur_ok)
				 Work_Track( X, Y, seite, spur, FERTIG);
			   }
			}
		     }
		     if( !ret_val)                /* kein Fehler beim Lesen */
		     {
			do
			{
			   ret_val= 0;             /* falls ==1 von Break() */
			   if( Q_lw== Z_lw)   /* Quell- und Ziellaufwerk identisch */
			      ok= Disk_Change( Q_lw);
			   else
			   {
			      if( !First)
				 ok= Disk_Change( Z_lw);
			      else
				 ok= First= 0;
			   }
			   if( !ok)
			   {
			      while((( Z_Format= GetDiskSize( Z_lw))== -1)&& ( !( ret_val= Info_Frage( 100, 200, "Das Laufwerk ist nicht\nbereit. Beheben Sie\nden Fehler und Drcken\nSie [OK].", INFO))))
				 ;
			      if( !ret_val)                    /* kein Abbruch */
			      {
				 if( Q_Format!= Z_Format)
				 {
				    if( Copy_Comp== KOPIE)
				       Zielformat_nicht_identisch= 1;
				    else
				    {
				       Info_Frage( 100, 200, "Quell- und Zielformat\nsind nicht identisch.", INFO);
				       goto Nochmal;
				    }
				 }
				 else
				    Zielformat_nicht_identisch= 0;
				 if( XMS_handle)
				    XMS_offset= 0L;
				 else
				    rewind( tmp_File);
				 for( spur= 0; spur< PData.Spuren; spur++)
				    for( seite= 0; seite< PData.Seiten; seite++)
				       Work_Track( X, Y, seite, spur, FREI);
				 if(( Copy_Comp== KOPIE)&& ( Zielformat_nicht_identisch|| ( Format== AN)))
				 {
				    DiskPrepare( Z_lw, PData.Spuren- 1, PData.Sektoren);
				    AlteDDPT= getvect( 0x1E);    /* Alte DDPT merken */
				    setvect( 0x1E, ( void interrupt(*)())PData.DDPT);  /* Neue DDPT Setzen */
				 }
				 for( spur= 0; ( spur< PData.Spuren)&& !ret_val; spur++)
				 {
				    for( seite= 0; ( seite< PData.Seiten)&& !ret_val; seite++)
				    {
				       if( Break( 200, 275, "Soll das Bearbeiten\nder Diskette wirklich\nabgebrochen werden ?"))
					  ret_val= 1;
				       else
				       {
					  if(( Copy_Comp== KOPIE)&& ( Zielformat_nicht_identisch|| ( Format== AN)))
					  {
					     Work_Track( X, Y, seite, spur, FORMATIEREN);
					     while((( status= FormatTrack( Z_lw, seite, spur, PData.Sektoren))== 0x03)&& ( !( ret_val= Info_Frage( 100, 200, "Diese Diskette ist\nschreibgeschtzt. Ent-\nfernen Sie den\nSchreibschutz.", INFO))))
						;
					  }
					  else
					     status= 0;
					  if( !ret_val)        /* kein Abbruch */
					  {
					     if(((( Quick== AN)&& ( Quick_Seite_Spur[ seite][ spur]!= NULL)&& ( *Quick_Seite_Spur[ seite][ spur]& FAT_BELEGT))|| ( Quick== AUS)|| ( spur== 0))&& !status)
					     {
						if( XMS_handle)
						{
						   XMSCopy( XMS_handle, XMS_offset, 0, ( long)(( void far *)mem_ptr), write_words);
						   XMS_offset+= write_words<< 1;
						}
						else
						{
						   if( fread( mem_ptr, 1, writelen, tmp_File)!= writelen)
						   {
						      ErrorMsg( READ_ERROR"TMP");
						      ret_val= -1;
						   }
						}
						if( !ret_val)     /* kein Fehler */
						{
						   if( Copy_Comp== KOPIE)
						   {
						      Work_Track( X, Y, seite, spur, SCHREIBEN);
						      if(( DatNum== AN)&& ( spur== 0)&& ( seite== 0))
							 *( DWORD *)( mem_ptr+ 39)= Datentraegernummer();
						      while((( status= WriteTrack( Z_lw, seite, spur, 1, PData.Sektoren, mem_ptr))== 0x03)&& ( !( ret_val= Info_Frage( 100, 200, "Diese Diskette ist\nschreibgeschtzt. Ent-\nfernen Sie den\nSchreibschutz.", INFO))))
							 ;
						      if( !ret_val&& ( Zielformat_nicht_identisch|| ( Verify== AN)))
						      {
							 Work_Track( X, Y, seite, spur, UEBERPRUEFEN);
							 if(( status= VerifyTrack( Z_lw, seite, spur, PData.Sektoren, &Verify))== 0xBB) /* Abbruch wegen Speichermangels */
							    ret_val= -1;
						      }
						   }
						   else
						   {
						      Spur_ok= 1;
						      if(( status= Disk_Copy_Comp_Read( Copy_Comp, X, Y, Z_lw, seite, spur, Comp_ptr, Quick, Quick_Seite_Spur, PData.Sektoren, &Spur_ok))== 0x80)
						      {
							 ErrorMsg( "Laufwerk reagiert nicht (eventuell keine Disk im Laufwerk)");
							 ret_val= -1;
						      }
						      else
						      {
							 if( !Spur_ok)
							    Work_Track( X, Y, seite, spur, DEFEKT);
							 else
							 {
							    if(( DatNum== AN)&& ( spur== 0)&& ( seite== 0)) /* Datentrgernummer ignorieren */
							       *( DWORD *)( Comp_ptr+ 39)= *( DWORD *)( mem_ptr+ 39);
							    if( !memcmp( mem_ptr, Comp_ptr, writelen))
							       Work_Track( X, Y, seite, spur, IDENTISCH);
							    else
							    {
							       Work_Track( X, Y, seite, spur, VERSCHIEDEN);
							       _identisch= 0;
							    }
							 }
						      }
						   }
						}
					     }
					     else
					     {
						if( Copy_Comp== KOPIE)
						{
						   if( Zielformat_nicht_identisch|| ( Format== AN))
						   {
						      Work_Track( X, Y, seite, spur, UEBERPRUEFEN);
						      if(( status= VerifyTrack( Z_lw, seite, spur, PData.Sektoren, &Verify))== 0xBB) /* Abbruch wegen Speichermangels */
							 ret_val= -1;
						   }
						}
						else
						   Work_Track( X, Y, seite, spur, FERTIG);
					     }
					     if(( Copy_Comp== KOPIE)&& !ret_val)
					     {
						if( status)
						{
						   Work_Track( X, Y, seite, spur, DEFEKT);
						   ErrorMsg( "Fehlerhafte Spur auf der Diskette");
						   ret_val= 1;
						}
						else
						   Work_Track( X, Y, seite, spur, FERTIG);
					     }
					  }
				       }
				    }
				 }
				 if( ret_val== 0)
				    ReadySound();
				 if( Copy_Comp== KOPIE)
				 {
				    if( Zielformat_nicht_identisch|| ( Format== AN))
				       setvect( 0x1E, AlteDDPT);   /* Alte DDPT restaurieren */
				 }
				 else
				 {
				    if( !ret_val)
				    {
				       if( _identisch)
					  Info_Frage( 100, 200, "Die eben bearbeitete\nDiskette ist mit der\nErsten identisch.", INFO);
				       else
					  Info_Frage( 100, 200, "Die eben bearbeitete\nDiskette ist keine\nKopie der Ersten.", INFO);
				    }
				 }
			      }
			   }
			   Nochmal:
			   ;
			}while( !ok&& ( ret_val>= 0)&& !Info_Frage( 100, 200, Nochmal[ Copy_Comp], FRAGE));
		     }
		     for( spur= 0; spur< PData.Spuren; spur++)
			for( seite= 0; seite< PData.Seiten; seite++)
			   if( Quick_Seite_Spur[ seite][ spur]!= NULL)
			      free( Quick_Seite_Spur[ seite][ spur]);
		     free( mem_ptr);
		  }
		  else
		  {
		     ErrorMsg( KEIN_SPEICHER);
		     ret_val= -1;
		  }
		  if( Copy_Comp== VERGLEICH)
		     free( Comp_ptr);
	       }
	       else
	       {
		  ErrorMsg( KEIN_SPEICHER);
		  ret_val= -1;
	       }
	       if( !XMS_handle)
		  fclose( tmp_File);
	    }
	    else
	    {
	       ErrorMsg( CREAT_ERROR"TMP");
	       ret_val= -1;
	    }
	 }
	 else
	 {
	    ErrorMsg( "Das zweite Laufwerk untersttzt das Format nicht");
	    ret_val= -1;
	 }
	 if( XMS_handle)
	    XMSFreeMem( XMS_handle);
      }
      else
      {
	 ErrorMsg( "Nicht genug freier XMS- oder Plattenspeicher vorhanden");
	 ret_val= -1;
      }
   }
   else
   {
      ErrorMsg( "Das Format der Quelldiskette wird nicht untersttzt");
      ret_val= -1;
   }
   return( ret_val);
}

void Prompt( DATWINStruct *l_DW, DATWINStruct *r_DW, char *path_tab_ptr_l[], char *path_tab_ptr_r[])
{
   SaveFWindow_struct l_SFW= { SFW_LEER};
   SaveFWindow_struct r_SFW= { SFW_LEER};
   char *C_ptr;

   if(( C_ptr= getenv( "COMSPEC"))!= NULL)
   {
      if( WriteStartBAT()== 0)
      {
	 SaveFilewindow( &l_SFW, l_DW, path_tab_ptr_l, SFW_PERM_PLATTE);
	 SaveFilewindow( &r_SFW, r_DW, path_tab_ptr_r, SFW_PERM_PLATTE);
	 saveSystem( "DB2_EINS.TMP");
	 Free_All_Resourcen();
	 printf( "  Geben Sie EXIT ein, um zu DESKTOP V"DESKTOP_VERSION" zurckzukehren ...");
	 if( execl( C_ptr, NULL)== -1)
	    exit( 0);
      }
   }
   else
      ErrorMsg( "Fehler beim Aufruf des Kommandoprozessors");
}