/*  INP_LINE.C  Input line
 *  Copyright (C) 1991-1998  Felix Ritter
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <dos.h>
#include <graphics.h>
#include <alloc.h>
#include <stdlib.h>
#include <conio.h>
#include <dir.h>
#include <string.h>
#include <bios.h>
#include "pal_op.h"
#include "filemgr.h"
#include "mouse_op.h"

#define INPUT_LINE_HEIGHT               16
#define INPUT_BUTTON_WIDTH              14
#define INPUT_TEXT_DIST_X               4
#define INPUT_TEXT_DIST_Y               5

#define INPUT_PULL_DOWN_MODE            0x8000
#define INPUT_PULLDOWN                  0x4000
#define INPUT_CHANGED                   0x0001
#define INPUT_ERROR                     0x8000

extern BOOL _InputInsert;

extern void *ButtonDown( int x1, int y1, int x2, int y2);
extern void ButtonUp( void *mem_ptr, int x1, int y1, int x2, int y2);

char     *textClipboard;                       /* global clipboard for text */
unsigned  textClipboardLen;                 /* number of chars in clipboard */
BOOL      validTextAtClipBoard= FALSE;        /* is text at clipboard valid */

BOOL  _InputInsert= FALSE;

void bar_unordered( int left, int top, int right, int bottom)
{
   bar( min( left, right), min( top, bottom), max( left, right)- 1, max( top, bottom));
}

BOOL inp_Scroll_Left( int textX, int textY, char **firstVisibleCharPtr, char *tmpTextBuffer, int maxCharsInLine, BOOL textMarked, char *textMarkedPtr, int textMarkedLen)
{
   void *image;

   if( *firstVisibleCharPtr> tmpTextBuffer)
   {
      if(( image= malloc( imagesize( textX, textY- 1, textX+ ( ( maxCharsInLine- 1)<< 3)- 1, textY+ 7)))!= NULL)
      {
	 ( *firstVisibleCharPtr)--;

	 ShowMouse( AUS);

	 getimage( textX, textY- 1, textX+ ( ( maxCharsInLine- 1)<< 3)- 1, textY+ 7, image);
	 putimage( textX+ 8, textY- 1, image, COPY_PUT);
	 free( image);

	 setfillstyle( SOLID_FILL, ( textMarked&& ( *firstVisibleCharPtr>= textMarkedPtr)&&
				   ( *firstVisibleCharPtr< textMarkedPtr+ textMarkedLen)) ? EGA_LIGHTGRAY : EGA_WHITE);
	 bar( textX, textY- 1, textX+ 7, textY+ 7);
	 OutTextN( textX, textY, *firstVisibleCharPtr, 1);

	 ShowMouse( AN);
      }
      else
      {
	 ErrorMsg( KEIN_SPEICHER);
	 return( FALSE);
      }

      delay( 30);

      return( TRUE);
   }
   return( FALSE);
}

BOOL inp_Scroll_Right( int textX, int textY, char **firstVisibleCharPtr, char *tmpTextBuffer, int maxCharsInLine, int maxCharsInBuffer, BOOL textMarked, char *textMarkedPtr, int textMarkedLen)
{
   int   len= strlen( tmpTextBuffer);
   void *image;

   if(( *firstVisibleCharPtr+ maxCharsInLine)< ( tmpTextBuffer+ len+ ( ( inputOverwrite&& ( len!= maxCharsInBuffer)) ? 1 : 0 )))
   {
      if(( image= malloc( imagesize( textX+ 8, textY- 1, textX+ ( maxCharsInLine<< 3)- 1, textY+ 7)))!= NULL)
      {
	 ( *firstVisibleCharPtr)++;

	 ShowMouse( AUS);

	 getimage( textX+ 8, textY- 1, textX+ ( maxCharsInLine<< 3)- 1, textY+ 7, image);
	 putimage( textX, textY- 1, image, COPY_PUT);
	 free( image);

	 setfillstyle( SOLID_FILL, ( textMarked&& ( ( *firstVisibleCharPtr+ maxCharsInLine- 1)>= textMarkedPtr)&&
				   ( ( *firstVisibleCharPtr+ maxCharsInLine- 1)< textMarkedPtr+ textMarkedLen)) ? EGA_LIGHTGRAY : EGA_WHITE);
	 bar( textX+ ( ( maxCharsInLine- 1)<< 3), textY- 1, textX+ ( ( maxCharsInLine- 1)<< 3)+ 7, textY+ 7);
	 OutTextN( textX+ ( ( maxCharsInLine- 1)<< 3), textY, *firstVisibleCharPtr+ maxCharsInLine- 1, 1);

	 ShowMouse( AN);
      }
      else
      {
	 ErrorMsg( KEIN_SPEICHER);
	 return( FALSE);
      }

      delay( 30);

      return( TRUE);
   }
   return( FALSE);
}

BOOL inp_CopyToClipboard( char *textMarkedPtr, int textMarkedLen, BOOL textMarked)
{
   if( textMarked)
   {
      if( validTextAtClipBoard)
	 free( textClipboard);
      if(( textClipboard= malloc( textMarkedLen))!= NULL)
      {
	 strncpy( textClipboard, textMarkedPtr, textMarkedLen);
	 textClipboardLen= textMarkedLen;
	 validTextAtClipBoard= TRUE;
      }
      else
      {
	 ErrorMsg( KEIN_SPEICHER);
	 validTextAtClipBoard= FALSE;
      }
      return( validTextAtClipBoard);
   }
   return( FALSE);
}

void inp_PasteFromClipboard( BOOL *textInverse, BOOL *viewChanged, char **curPosPtr, char *tmpTextBuffer, int maxCharsInBuffer, char *textMarkedPtr, int textMarkedLen, BOOL *textMarked)
{
   BOOL  canInsert= FALSE;
   int   i, l;
   char *tmpPtr;

   if( validTextAtClipBoard)
   {
      if( *textInverse)
      {
	 memset( tmpTextBuffer, '\0', maxCharsInBuffer);
	 *textInverse= FALSE;
	 *viewChanged= TRUE;
      }
      else
      {
	 if( *textMarked)
	 {
	    *curPosPtr= memmove( textMarkedPtr, textMarkedPtr+ textMarkedLen, strlen( textMarkedPtr+ textMarkedLen)+ 1);
	    *textMarked= FALSE;
	    *viewChanged= TRUE;
	 }
      }

      if( inputOverwrite)
      {
	 if(( *curPosPtr+ textClipboardLen)<= ( tmpTextBuffer+ maxCharsInBuffer))
	    canInsert= TRUE;
	 else
	    Hinweis( "der Inhalt der Zwischenablage pat nicht in die Zeile");
      }
      else
      {
	 l= strlen( *curPosPtr);
	 if(( *curPosPtr+ l+ textClipboardLen)<= ( tmpTextBuffer+ maxCharsInBuffer))
	 {
	    memmove( *curPosPtr+ textClipboardLen, *curPosPtr, l+ 1);
	    canInsert= TRUE;
	 }
	 else
	    Hinweis( "der Inhalt der Zwischenablage pat nicht in die Zeile");
      }

      if( canInsert)
      {
	 for( i= 0, tmpPtr= *curPosPtr; i< textClipboardLen; i++)
	    if( *( textClipboard+ i)== '\r')
	       i++;
	    else
	       *tmpPtr++= *( textClipboard+ i);

	 *viewChanged= TRUE;
      }
   }
   else
      Hinweis( "die Zwischenablage ist leer");
}

WORD _Input( int posX, int posY, int widthX, char *orgTextBuffer, int maxCharsInBuffer, WORD widgetType, BOOL ignoreCase)
{
   BOOL  textInverse,                         /* is the text color inversed */
	 textMarked= FALSE,                   /* is text in the line marked */
	 buttonDelayExceeded,             /* is time for autorepeat reached */
	 unMarkText,                      /* is the user unmarking the text */
	 viewChanged= FALSE,      /* has the view changed since last update */
	 cursorVisible;                            /* is the cursor visible */
   int   textX, textY,                                    /* text positions */
	 maxCharsInLine,                /* max. number of chars in the line */
	 textLenAtBegin,            /* number of chars in the line at begin */
	 textMarkedLen,                     /* number of chars to be marked */
	 leaveFunctionWith= 0,        /* leave the loop with a spez. status */
	 oldCurPos,                      /* stores the last cursor position */
	 keycode,                                    /* stores the key code */
	 i, l;
   WORD  ret_val= 0,                                 /* return value (Code) */
	 keyModifier;                           /* bitmask of modifier keys */
   char *tmpTextBuffer,                            /* char buffer for input */
	*curPosPtr,                    /* current position pointer (cursor) */
	*firstVisibleCharPtr,    /* pointer on the first char to be visible */
	*textMarkedPtr,                 /* pointer on the first marked char */
	*firstCurPtr,       /* pointer on char of the first cursor position */
	 markDirection,                /* indicate the direction of marking */
	 markDirectionStore,             /* stores the direction of marking */
	*tmpPtr;

   textX= posX+ INPUT_BUTTON_WIDTH+ INPUT_TEXT_DIST_X;
   textY= posY+ INPUT_TEXT_DIST_Y;
   maxCharsInLine= (( widthX- ( INPUT_BUTTON_WIDTH* 2))/ 8)- 1;

   /* allocate a \0 initialized temporary buffer */
   if(( tmpTextBuffer= calloc( maxCharsInBuffer+ 1, sizeof( char)))!= NULL)
   {
      curPosPtr= firstVisibleCharPtr= tmpTextBuffer;

      ShowMouse( AUS);
      WhiteClearN( textX, textY, maxCharsInLine);
      ShowMouse( AN);

      if( *orgTextBuffer!= '\0')         /* has the function got a string ? */
      {
	 strncpy( tmpTextBuffer, orgTextBuffer, maxCharsInBuffer);  /* end \0 exist */
	 textLenAtBegin= (( l= strlen( tmpTextBuffer))> maxCharsInLine) ? maxCharsInLine : l;

	 ShowMouse( AUS);
	 OutTextN( textX, textY, tmpTextBuffer, maxCharsInLine);
	 InputReverse( textX, textY, textLenAtBegin);
	 ShowMouse( AN);

	 textInverse= TRUE;
      }
      else
      {
	 textLenAtBegin= 0;

	 textInverse= FALSE;
      }

      do
      {
	 if( !_InputInsert)
	    MouseStat();
	 else
	    _InputInsert= FALSE;

	 if( MStat.buttons!= NOTHING)
	 {
	    if( textInverse)
	    {
	       ShowMouse( AUS);
	       InputReverse( textX, textY, textLenAtBegin);
	       ShowMouse( AN);
	       textInverse= FALSE;
	    }
	    /* mouse in the object ? */
	    if(( MStat.x>= posX)&& ( MStat.x<= posX+ widthX)&&
	       ( MStat.y>= posY)&& ( MStat.y<= posY+ INPUT_LINE_HEIGHT))
	    {
	       /* <- */
	       if(( MStat.x>= posX)&& ( MStat.x<= posX+ INPUT_BUTTON_WIDTH))
	       {
		  buttonDelayExceeded= FALSE;
		  tmpPtr= ButtonDown( posX, posY, posX+ INPUT_BUTTON_WIDTH, posY+ INPUT_LINE_HEIGHT);
		  do
		  {
		     LoschTbuf();
		     MouseStat();

		     inp_Scroll_Left( textX, textY, &firstVisibleCharPtr, tmpTextBuffer, maxCharsInLine, textMarked, textMarkedPtr, textMarkedLen);

		     if( !buttonDelayExceeded)
			if( WaitDelay( 600))
			   break;
		     buttonDelayExceeded= TRUE;
		  }while(( MStat.buttons!= NOTHING)|| TASTE_GEDRUECKT);
		  ButtonUp( tmpPtr, posX, posY, posX+ INPUT_BUTTON_WIDTH, posY+ INPUT_LINE_HEIGHT);
		  curPosPtr= firstVisibleCharPtr;
	       }
	       else
	       {
		  /* -> */
		  if(( MStat.x>= posX+ widthX- INPUT_BUTTON_WIDTH)&& ( MStat.x<= posX+ widthX))
		  {
		     buttonDelayExceeded= FALSE;
		     tmpPtr= ButtonDown( posX+ widthX- INPUT_BUTTON_WIDTH, posY, posX+ widthX, posY+ INPUT_LINE_HEIGHT);
		     do
		     {
			LoschTbuf();
			MouseStat();

			inp_Scroll_Right( textX, textY, &firstVisibleCharPtr, tmpTextBuffer, maxCharsInLine, maxCharsInBuffer, textMarked, textMarkedPtr, textMarkedLen);

			if( !buttonDelayExceeded)
			   if( WaitDelay( 600))
			      break;
			buttonDelayExceeded= TRUE;
		     }while(( MStat.buttons!= NOTHING)|| TASTE_GEDRUECKT);
		     ButtonUp( tmpPtr, posX+ widthX- INPUT_BUTTON_WIDTH, posY, posX+ widthX, posY+ INPUT_LINE_HEIGHT);

		     curPosPtr= firstVisibleCharPtr+ min( ( int)strlen( tmpTextBuffer), maxCharsInLine- ( ( inputOverwrite) ? 1 : 0 ));
		  }
		  else    /* mouse in the text area */
		  {
		     if( textMarked)
		     {
			ShowMouse( AUS);
			WhiteClearN( textX, textY, maxCharsInLine);
			OutTextN( textX, textY, firstVisibleCharPtr, maxCharsInLine);
			ShowMouse( AN);

			textMarked= FALSE;
		     }

		     oldCurPos= -1;
		     do
		     {
			l= strlen( firstVisibleCharPtr);

			if(( MStat.x>= textX)&&
			   ( MStat.x<= textX+ min( l, maxCharsInLine)* 8))
			{
			   i= ( MStat.x- textX+ 1)/ 8;
			}
			else
			{
			   if( MStat.x< textX)     /* left edge exceeded */
			   {
			      if( inp_Scroll_Left( textX, textY, &firstVisibleCharPtr, tmpTextBuffer, maxCharsInLine, textMarked, textMarkedPtr, textMarkedLen))
			      {
				 if( oldCurPos< ( maxCharsInLine- 1))
				    oldCurPos++;
			      }
			      i= 0;
			   }
			   else
			   {
			      if( inp_Scroll_Right( textX, textY, &firstVisibleCharPtr, tmpTextBuffer, maxCharsInLine, maxCharsInBuffer, textMarked, textMarkedPtr, textMarkedLen))
			      {
				 if( oldCurPos> 0)
				    oldCurPos--;
			      }
			      i= min( l, maxCharsInLine);
			   }
			}

			if( oldCurPos!= -1)           /* not the first loop */
			{
			   if( i!= oldCurPos)
			   {
			      curPosPtr= firstVisibleCharPtr+ i;

			      ShowMouse( AUS);

			      if( i> oldCurPos)
				 markDirection= RIGHT;
			      else
			      {
				 if( i< oldCurPos)
				    markDirection= LEFT;
				 else
				    markDirection= NOTHING;
			      }
			      if((( curPosPtr> firstCurPtr)&& ( firstCurPtr> firstVisibleCharPtr+ oldCurPos))||
				 (( curPosPtr< firstCurPtr)&& ( firstCurPtr< firstVisibleCharPtr+ oldCurPos)))
			      {
				 setfillstyle( SOLID_FILL, EGA_WHITE);
				 bar_unordered( textX+ ( oldCurPos<< 3), textY- 1, textX+ ( ( firstCurPtr- firstVisibleCharPtr)<< 3), textY+ 7);
				 setfillstyle( SOLID_FILL, EGA_LIGHTGRAY);
				 bar_unordered( textX+ ( ( firstCurPtr- firstVisibleCharPtr)<< 3), textY- 1, textX+ ( i<< 3), textY+ 7);

				 unMarkText= FALSE;
			      }
			      else
			      {
				 unMarkText= ((( markDirectionStore== RIGHT)&& ( markDirection== LEFT)&& ( curPosPtr>= firstCurPtr))||
					      (( markDirectionStore== LEFT)&& ( markDirection== RIGHT)&& ( curPosPtr<= firstCurPtr)));

				 setfillstyle( SOLID_FILL, ( unMarkText) ? EGA_WHITE : EGA_LIGHTGRAY);

				 bar_unordered( textX+ ( oldCurPos<< 3), textY- 1, textX+ ( i<< 3), textY+ 7);
			      }
			      OutTextN( textX+ ( min( oldCurPos, i)<< 3), textY, curPosPtr- max( i- oldCurPos, 0), abs( oldCurPos- i));

			      ShowMouse( AN);

			      textMarkedPtr= firstCurPtr- max( firstCurPtr- curPosPtr, 0);
			      textMarkedLen= abs( curPosPtr- firstCurPtr);
			      textMarked= ( curPosPtr!= firstCurPtr);

			      oldCurPos= i;
			      if( !unMarkText)
				 markDirectionStore= markDirection;
			   }
			}
			else                              /* the first loop */
			{
			   oldCurPos= i;
			   curPosPtr= firstCurPtr= firstVisibleCharPtr+ i;

			   if( Edit_X_Term&& ( MStat.buttons== RIGHT))
			      inp_PasteFromClipboard( &textInverse, &viewChanged, &curPosPtr, tmpTextBuffer, maxCharsInBuffer, textMarkedPtr, textMarkedLen, &textMarked);

			}

			if( inputOverwrite&&(( curPosPtr- firstVisibleCharPtr)== maxCharsInLine))
			   curPosPtr--;

		     }while( MouseStat()!= NOTHING);

		     if( Edit_X_Term)
			inp_CopyToClipboard( textMarkedPtr, textMarkedLen, textMarked);
		  }
	       }
	    }
	    else
	    {
	       leaveFunctionWith= 1;             /* mouse out of the object */
	       continue;
	    }
	 }
	 if( kbhit())
	 {
	    if( textInverse)
	    {
	       ShowMouse( AUS);
	       InputReverse( textX, textY, textLenAtBegin);
	       ShowMouse( AN);
	    }

	    switch( keycode= getch())
	    {
	       case BACKSPACE:
		  if( textInverse)
		  {
		     memset( tmpTextBuffer, '\0', maxCharsInBuffer);
		     textInverse= FALSE;
		     viewChanged= TRUE;
		  }
		  else
		  {
		     if( textMarked)
		     {
			curPosPtr= memmove( textMarkedPtr, textMarkedPtr+ textMarkedLen, strlen( textMarkedPtr+ textMarkedLen)+ 1);
			textMarked= FALSE;
			viewChanged= TRUE;
		     }
		     else
		     {
			if( curPosPtr> tmpTextBuffer)
			{
			   memmove( curPosPtr- 1, curPosPtr, strlen( curPosPtr)+ 1);
			   curPosPtr--;
			   viewChanged= TRUE;
			}
		     }
		  }
		  break;

	       case TAB:
	       case STRG_RETURN:
		  ungetch( keycode);
		  leaveFunctionWith= 1;
		  continue;

	       case RETURN:
		  leaveFunctionWith= 3;
		  continue;

	       case ESC:
		  textMarked= FALSE;
		  textInverse= TRUE;
		  viewChanged= TRUE;

		  curPosPtr= firstVisibleCharPtr= tmpTextBuffer;

		  if( *orgTextBuffer!= '\0')  /* has the function got a string ? */
		     *( strncpy( tmpTextBuffer, orgTextBuffer, maxCharsInBuffer)+ maxCharsInBuffer)= '\0';
		  else
		     *tmpTextBuffer= '\0';

		  break;

	       default:
		  if( textInverse)
		  {
		     memset( tmpTextBuffer, '\0', maxCharsInBuffer);
		     textInverse= FALSE;
		     viewChanged= TRUE;
		  }
		  else
		  {
		     if( textMarked)
		     {
			curPosPtr= memmove( textMarkedPtr, textMarkedPtr+ textMarkedLen, strlen( textMarkedPtr+ textMarkedLen)+ 1);
			textMarked= FALSE;
			viewChanged= TRUE;
		     }
		  }
		  if( ( curPosPtr+ strlen( curPosPtr))< ( tmpTextBuffer+ maxCharsInBuffer+ ( ( inputOverwrite) ? 1 : 0 )))
		  {
		     if( !inputOverwrite)
			memmove( curPosPtr+ 1, curPosPtr, strlen( curPosPtr)+ 1);
		     *curPosPtr= keycode;

		     if( curPosPtr< tmpTextBuffer+ maxCharsInBuffer- ( ( inputOverwrite) ? 1 : 0 ))
			curPosPtr++;
		     viewChanged= TRUE;
		  }
		  break;

	       case 0:                              /* erweiterter IBM-Code */
		  if(( keyModifier= _bios_keybrd( _NKEYBRD_SHIFTSTATUS))& SHIFT_PRESS)
		  {
		     if( !textMarked)
			firstCurPtr= curPosPtr;
		  }

		  switch( ( keycode= getch())| EXTENDED)
		  {
		     case STRG_TAB& STRG_FILTER:
			{
			   struct ffblk ffblk;
			   BOOL  fileType= FALSE;
			   int   done;
			   char *cpyBuffer, *lastSlash,
				attribut, filename[ sizeof( ffblk.ff_name)]= "";

			   switch( widgetType)
			   {
			      case FILEINPUT:
			      case FILEINPUTNOBOX:
			      case FILE_INPUT_TABLE:
				 fileType= TRUE;
			      case DIRINPUT:
			      case DIRINPUTNOBOX:
			      case DIR_INPUT_TABLE:
				 if(( cpyBuffer= calloc( maxCharsInBuffer+ sizeof( ffblk.ff_name)+ 1, sizeof( char)))!= NULL)
				 {
				    strcat( strncpy( cpyBuffer, tmpTextBuffer, curPosPtr- tmpTextBuffer), "*");
				    if(( ( tmpPtr= strrchr( cpyBuffer, '.'))< ( lastSlash= strrchr( cpyBuffer, '\\')))|| ( tmpPtr== NULL))
				       strcat( cpyBuffer, ".*");

				    if( (( tmpPtr= strrchr( cpyBuffer, ':'))!= NULL)&& ( tmpPtr> cpyBuffer)&& isalpha( *( tmpPtr- 1))&& ( *( tmpPtr+ 1)== '\\'))
				    {
						 /* Pointer to drive */
				       done= findfirst( --tmpPtr, &ffblk, FA_DIREC| FA_RDONLY| FA_HIDDEN| FA_SYSTEM| FA_ARCH);

				       if( !done)
					  i= ( fileType|| ( ffblk.ff_attrib& FA_DIREC)) ? 1 : 0;
				       else
					  i= 0;

				       while( !done)
				       {
					  if( i> 0)
					  {
					     if( filename[ 0]== '\0')
					     {
						strcpy( filename, ffblk.ff_name);
						attribut= ffblk.ff_attrib;
					     }
					     else
					     {
						for( l= 0; ( *( filename+ l)== *( ffblk.ff_name+ l))&& ( l< strlen( filename)); l++)
						   ;
						*( filename+ l)= '\0';

					     }
					  }

					  do
					  {
					     done= findnext( &ffblk);
					  }while( !done&& !fileType&& !( ffblk.ff_attrib& FA_DIREC));

					  if( !done)
					     i++;
				       }

				       if( i> 0)
				       {
					  strcpy( ++lastSlash, filename);

					  if( i== 1)
					  {
					     if(( *curPosPtr!= '\\')&& ( attribut& FA_DIREC))
						strcat( cpyBuffer, "\\");
					  }
					  else
					     Hinweis( "Mehr als ein Eintrag zutreffend");

					  l= strlen( cpyBuffer);

					  if( ( ( i= strlen( tmpTextBuffer))+ l- ( curPosPtr- tmpTextBuffer))<= maxCharsInBuffer)
					  {
					     memmove( tmpTextBuffer+ l- ( curPosPtr- tmpTextBuffer), tmpTextBuffer, i+ 1);
					     strncpy( tmpTextBuffer, cpyBuffer, l);
					     curPosPtr+= l- ( curPosPtr- tmpTextBuffer);

					     viewChanged= TRUE;
					  }
					  else
					     Hinweis( "Der Eintrag pat nicht in die Zeile");
				       }

				    }
				    else
				       ErrorMsg( "Kein Wurzelverzeichnis angegeben (X:\\)");

				    free( cpyBuffer);
				 }
				 else
				    ErrorMsg( KEIN_SPEICHER);


				 break;
			   }
			}
			break;

		     case SHIFT_TAB:
			textInverse= FALSE;

			extended_ungetch( keycode);
			leaveFunctionWith= 1;

			continue;

		     case CURSOR_DOWN:
			textInverse= FALSE;

			switch( widgetType)
			{
			   case INPUT_TABLE:
			   case FILE_INPUT_TABLE:
			   case DIR_INPUT_TABLE:
			      ret_val|= INPUT_PULLDOWN;
			      leaveFunctionWith= 2;
			      continue;
			}
			break;

		     case CURSOR_LEFT:
			textInverse= FALSE;

			if( curPosPtr> tmpTextBuffer)
			{
			   curPosPtr--;

			   if( keyModifier& SHIFT_PRESS)
			   {
			      textMarkedPtr= ( curPosPtr< firstCurPtr) ? curPosPtr : firstCurPtr;
			      textMarkedLen= abs( firstCurPtr- curPosPtr);
			      textMarked= ( firstCurPtr!= curPosPtr);
			   }
			   else
			   {
			      if( textMarked)
			      {
				 textMarked= FALSE;
				 viewChanged= TRUE;
			      }
			   }

			   if( curPosPtr< firstVisibleCharPtr)
			      inp_Scroll_Left( textX, textY, &firstVisibleCharPtr, tmpTextBuffer, maxCharsInLine, textMarked, textMarkedPtr, textMarkedLen);
			   else
			   {
			      if( keyModifier& SHIFT_PRESS)
			      {
				 ShowMouse( AUS);

				 setfillstyle( SOLID_FILL, ( curPosPtr< firstCurPtr) ? EGA_LIGHTGRAY : EGA_WHITE);

				 i= curPosPtr- firstVisibleCharPtr;
				 bar( textX+ ( i<< 3), textY- 1, textX+ (( i+ 1)<< 3)- 1, textY+ 7);
				 OutTextN( textX+ ( i<< 3), textY, curPosPtr, 1);

				 ShowMouse( AN);
			      }
			   }
			}
			break;

		     case CURSOR_RIGHT:
			textInverse= FALSE;

			if(( curPosPtr< tmpTextBuffer+ strlen( tmpTextBuffer))&&
			   ( curPosPtr< tmpTextBuffer+ maxCharsInBuffer- ( ( inputOverwrite) ? 1 : 0 )))
			{
			   curPosPtr++;

			   if( keyModifier& SHIFT_PRESS)
			   {
			      textMarkedPtr= ( curPosPtr< firstCurPtr) ? curPosPtr : firstCurPtr;
			      textMarkedLen= abs( firstCurPtr- curPosPtr);
			      textMarked= ( firstCurPtr!= curPosPtr);
			   }
			   else
			   {
			      if( textMarked)
			      {
				 textMarked= FALSE;
				 viewChanged= TRUE;
			      }
			   }

			   if( curPosPtr> firstVisibleCharPtr+ maxCharsInLine- ( ( inputOverwrite) ? 1 : 0 ))
			      inp_Scroll_Right( textX, textY, &firstVisibleCharPtr, tmpTextBuffer, maxCharsInLine, maxCharsInBuffer, textMarked, textMarkedPtr, textMarkedLen);
			   else
			   {
			      if( keyModifier& SHIFT_PRESS)
			      {
				 ShowMouse( AUS);

				 setfillstyle( SOLID_FILL, ( curPosPtr> firstCurPtr) ? EGA_LIGHTGRAY : EGA_WHITE);

				 i= ( curPosPtr- 1)- firstVisibleCharPtr;
				 bar( textX+ ( i<< 3), textY- 1, textX+ (( i+ 1)<< 3)- 1, textY+ 7);
				 OutTextN( textX+ ( i<< 3), textY, curPosPtr- 1, 1);

				 ShowMouse( AN);
			      }
			   }
			}

			break;

		     case DELETE:
			if( textInverse)
			{
			   memset( tmpTextBuffer, '\0', maxCharsInBuffer);
			   textInverse= FALSE;
			   viewChanged= TRUE;
			}
			else
			{
			   if( textMarked)
			   {
			      curPosPtr= memmove( textMarkedPtr, textMarkedPtr+ textMarkedLen, strlen( textMarkedPtr+ textMarkedLen)+ 1);
			      textMarked= FALSE;
			      viewChanged= TRUE;
			   }
			   else
			   {
			      if( curPosPtr< ( tmpTextBuffer+ strlen( tmpTextBuffer)))
			      {
				 memmove( curPosPtr, curPosPtr+ 1, strlen( curPosPtr+ 1)+ 1);
				 viewChanged= TRUE;
			      }
			   }
			}
			break;

		     case STRG_DELETE& STRG_FILTER:
		     case STRG_INSERT& STRG_FILTER:
			textInverse= FALSE;

			if( inp_CopyToClipboard( textMarkedPtr, textMarkedLen, textMarked))
			{
			   if( keycode== ( STRG_DELETE& STRG_FILTER))
			   {
			      curPosPtr= memmove( textMarkedPtr, textMarkedPtr+ textMarkedLen, strlen( textMarkedPtr+ textMarkedLen)+ 1);
			      textMarked= FALSE;
			      viewChanged= TRUE;
			   }
			}

			break;

		     case INSERT:
			if( keyModifier& SHIFT_PRESS)
			{
			   inp_PasteFromClipboard( &textInverse, &viewChanged, &curPosPtr, tmpTextBuffer, maxCharsInBuffer, textMarkedPtr, textMarkedLen, &textMarked);
			}
			else
			{
			   if( textInverse)
			   {
			      ShowMouse( AUS);
			      InputReverse( textX, textY, textLenAtBegin);
			      ShowMouse( AN);
			   }
			   if((( inputOverwrite^= TRUE)== TRUE)&& ( curPosPtr>= tmpTextBuffer+ maxCharsInBuffer))
			      curPosPtr--;
			}
			break;

		     case HOME:
			textInverse= FALSE;

			curPosPtr= tmpTextBuffer;

			if( keyModifier& SHIFT_PRESS)
			{
			   textMarkedPtr= ( curPosPtr< firstCurPtr) ? curPosPtr : firstCurPtr;
			   textMarkedLen= abs( firstCurPtr- curPosPtr);
			   textMarked= ( firstCurPtr!= curPosPtr);

			   viewChanged= TRUE;
			}
			else
			{
			   if( textMarked)
			   {
			      textMarked= FALSE;
			      viewChanged= TRUE;
			   }
			}

			break;

		     case END:
			textInverse= FALSE;

			l= strlen( tmpTextBuffer);
			curPosPtr= tmpTextBuffer+ l- ( ( inputOverwrite&& ( l== maxCharsInBuffer)) ? 1 : 0 );

			if( keyModifier& SHIFT_PRESS)
			{
			   textMarkedPtr= ( curPosPtr< firstCurPtr) ? curPosPtr : firstCurPtr;
			   textMarkedLen= abs( firstCurPtr- curPosPtr);
			   textMarked= ( firstCurPtr!= curPosPtr);

			   viewChanged= TRUE;
			}
			else
			{
			   if( textMarked)
			   {
			      textMarked= FALSE;
			      viewChanged= TRUE;
			   }
			}

			break;
		  }
		  break;

	    }

	    if( curPosPtr< firstVisibleCharPtr)
	    {
	       firstVisibleCharPtr= curPosPtr;
	       viewChanged= TRUE;
	    }
	    if( curPosPtr> firstVisibleCharPtr+ maxCharsInLine- ( ( inputOverwrite) ? 1 : 0 ))
	    {
	       firstVisibleCharPtr= curPosPtr- ( maxCharsInLine- ( ( inputOverwrite) ? 1 : 0 ));
	       viewChanged= TRUE;
	    }

	 }

	 if( viewChanged)
	 {
	    ShowMouse( AUS);

	    WhiteClearN( textX, textY, maxCharsInLine);
	    if( textMarked)
	    {
	       if((( firstVisibleCharPtr>= textMarkedPtr)|| ( firstVisibleCharPtr+ maxCharsInLine> textMarkedPtr))&&
		   ( firstVisibleCharPtr< textMarkedPtr+ textMarkedLen))
	       {
		  setfillstyle( SOLID_FILL, EGA_LIGHTGRAY);

		  i= max( textMarkedPtr- firstVisibleCharPtr, 0);
		  bar( textX+ ( i<< 3), textY- 1, textX+ ( i<< 3)+ ( min( ( textMarkedPtr+ textMarkedLen)- firstVisibleCharPtr, min( ( int)strlen( firstVisibleCharPtr), maxCharsInLine)- i)<< 3)- 1, textY+ 7);
	       }
	    }
	    OutTextN( textX, textY, firstVisibleCharPtr, maxCharsInLine);

	    if( keycode== ESC)
	       InputReverse( textX, textY, textLenAtBegin);

	    ShowMouse( AN);

	    viewChanged= FALSE;
	 }

	 setcolor( 0x0F);
	 setwritemode( XOR_PUT);

	 for( l= 0, cursorVisible= FALSE; ( l== 0)|| cursorVisible; cursorVisible^= TRUE)
	 {
	    Clock();

	    ShowMouse( AUS);

	    if( inputOverwrite)
	    {
	       for( i= 0; i< 8; i++)
		  line( textX+ ( ( curPosPtr- firstVisibleCharPtr)<< 3)+ i, textY- 1, textX+ ( ( curPosPtr- firstVisibleCharPtr)<< 3)+ i, textY+ 7);
	    }
	    else
	    {
	       line( textX+ ( ( curPosPtr- firstVisibleCharPtr)<< 3)- 1, textY- 1, textX+ ( ( curPosPtr- firstVisibleCharPtr)<< 3)- 1, textY+ 7);
	       line( textX+ ( ( curPosPtr- firstVisibleCharPtr)<< 3)   , textY- 1, textX+ ( ( curPosPtr- firstVisibleCharPtr)<< 3),    textY+ 7);
	    }

	    ShowMouse( AN);

	    for( i= 0; i< 150; i++)
	    {
	       delay( 1);

	       if(( MouseStat()!= NOTHING)|| kbhit())
	       {
		  l= 1;
		  break;
	       }
	    }
	 }
	 setwritemode( COPY_PUT);

      }while( leaveFunctionWith== 0);

      if( ignoreCase)
      {
	 strupr( tmpTextBuffer);
	 textMarked= TRUE;
      }
      i= strcmp( orgTextBuffer, tmpTextBuffer);

      if( textMarked)
      {
	 ShowMouse( AUS);
	 WhiteClearN( textX, textY, maxCharsInLine);
	 OutTextN( textX, textY, firstVisibleCharPtr, maxCharsInLine);
	 ShowMouse( AN);

	 textMarked= FALSE;
      }

      if(( i!= 0)&& (( leaveFunctionWith== 1)|| ( leaveFunctionWith== 3)))       // ret== 3 -> RETURN
	 strcpy( orgTextBuffer, tmpTextBuffer);

      free( tmpTextBuffer);

      if( leaveFunctionWith== 3)
	 ret_val|= FUNC_RETURN;

      if( i)
	 ret_val|= INPUT_CHANGED;
   }
   else
   {
      ErrorMsg( KEIN_SPEICHER);
      ret_val|= INPUT_ERROR;
   }

   return( ret_val);         /* |FEHLER, |INPUT_VERAENDERT, |INPUT_PULLDOWN */
}
