/*  SCRSAVER.C  Screen saver
 *  Copyright (C) 1991-1998  Felix Ritter
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdlib.h>
#include <dos.h>
#include <graphics.h>
#include <time.h>
#include <stdlib.h>
#include <conio.h>
#include <alloc.h>
#include "pal_op.h"
#include "filemgr.h"
#include "mouse_op.h"

#define MAX_FUSES   60

typedef struct FUSESTR
	{
	   int x1, y1, x2, y2, drawn;
	}FUSE;

FUSE fuses[ MAX_FUSES];

static int _current= 0;
int dx1, dy1, dx2, dy2, xextent, yextent, fusecolor;
extern char no_Anwendungen_flag;

void InitFuses( void)
{
   int i;

   yextent= 479;
   xextent= 639;
   fusecolor= 1;
   setcolor( fusecolor);
   for( i= 0; i< MAX_FUSES; i++)
      fuses[ i].drawn= FALSE;
   fuses[ MAX_FUSES- 1].x1= xextent/ 2;
   fuses[ MAX_FUSES- 1].x2= xextent/ 2- 50;
   fuses[ MAX_FUSES- 1].y1= yextent/ 2;
   fuses[ MAX_FUSES- 1].y2= yextent/ 2- 50;
   dx1= 10;
   dy1= 10;
   dx2= -10;
   dy2= -10;
}

void DrawFuse( FUSE *fuse)
{
   line( fuse->x1, fuse->y1, fuse->x2, fuse->y2);
}

int MyRand( void)
{
   return( rand()/ 3277);
}

void MoveFuse( FUSE *previous, FUSE *tomove)
{
   tomove->x1= previous->x1+ dx1;
   tomove->x2= previous->x2+ dx2;
   tomove->y1= previous->y1+ dy1;
   tomove->y2= previous->y2+ dy2;
   if( tomove->x1> xextent)
      dx1= -MyRand();
   if( tomove->x1< 0)
      dx1= MyRand();
   if( tomove->x2> xextent)
      dx2= -MyRand();
   if( tomove->x2< 0)
      dx2= MyRand();
   if( tomove->y1> yextent)
      dy1= -MyRand();
   if( tomove->y1< 0)
      dy1= MyRand();
   if( tomove->y2> yextent)
      dy2= -MyRand();
   if( tomove->y2< 0)
      dy2= MyRand();
}

void ReDoLines( void)
{
   int i;

   setcolor( EGA_BLACK);
   for( i= 0; i< MAX_FUSES; i++)
   {
      if( fuses[ i].drawn)
      {
	 DrawFuse( &fuses[ i]);
	 fuses[ i].drawn= FALSE;
      }
   }
}

void DoFuses( void)
{
   if( fuses[ _current].drawn)
      DrawFuse( &fuses[ _current]);
   if( !_current)
      MoveFuse( &fuses[ MAX_FUSES- 1], &fuses[ 0]);
   else
      MoveFuse( &fuses[ _current- 1], &fuses[ _current]);
   DrawFuse( &fuses[ _current]);
   fuses[ _current].drawn= TRUE;
   _current= ++_current% MAX_FUSES;
}

static void ClearScreen( void)
{
   int i;

   setcolor( EGA_BLACK);
   for( i= 0; i< 321; i++)
      rectangle( 320- i, 240- i, 320+ i, 240+ i);
}

void Fuse( void)
{
   int l= 1;

   ClearScreen();
   InitFuses();
   do
   {
      if( l>= MAX_FUSES)
      {
	 ReDoLines();
	 l= 1;
	 setcolor( fusecolor);
	 if( ++fusecolor> 15)
	    fusecolor= 1;
      }
      else
	 l++;
      DoFuses();
      delay( 3);
   }while( !MouseMove()&& ( MouseStat()!= LEFT)&& !kbhit());
   LoschTbuf();
}

#define MOVE_DELAY  3
#define NEXT_DELAY  90

void DrawBlack( int X, int Y)
{
   setfillstyle( SOLID_FILL, EGA_BLACK);
   bar( X* 40+ 1, Y* 40+ 1, X* 40+ 39, Y* 40+ 39);
}

void MoveBlack( int *akt_X, int *akt_Y, void *mem_ptr)
{
   int i, to_X, to_Y;

   to_X= *akt_X;
   to_Y= *akt_Y;
   if( random( 2)== 0)
   {
      if( *akt_X== 0)
	 to_X= *akt_X+ 1;
      else
      {
	 if( *akt_X== 15)
	    to_X= *akt_X- 1;
	 else
	    to_X= *akt_X+ ( ( random( 2)== 0) ? ( -1) : ( 1));
      }
   }
   else
   {
      if( *akt_Y== 0)
	 to_Y= *akt_Y+ 1;
      else
      {
	 if( *akt_Y== 11)
	    to_Y= *akt_Y- 1;
	 else
	    to_Y= *akt_Y+ ( ( random( 2)== 0) ? ( -1) : ( 1));
      }
   }
   if( to_X< *akt_X)
   {
      for( i= 0; i< 40; i+= 2)
      {
	 getimage( to_X* 40+  1+ i, to_Y* 40+  1, to_X* 40+ 39+ i, to_Y* 40+ 39, mem_ptr);
	      bar( to_X* 40+  1+ i, to_Y* 40+  1, to_X* 40+  2+ i, to_Y* 40+ 39);
	 putimage( to_X* 40+  3+ i, to_Y* 40+  1, mem_ptr, COPY_PUT);
	 delay( MOVE_DELAY);
      }
   }
   else
   {
      if( to_X> *akt_X)
      {
	 for( i= 0; i< 40; i+= 2)
	 {
	    getimage( to_X* 40+  1- i, to_Y* 40+  1, to_X* 40+ 39- i, to_Y* 40+ 39, mem_ptr);
		 bar( to_X* 40+ 38- i, to_Y* 40+  1, to_X* 40+ 39- i, to_Y* 40+ 39);
	    putimage( to_X* 40+ -1- i, to_Y* 40+  1, mem_ptr, COPY_PUT);
	    delay( MOVE_DELAY);
	 }
      }
      else
      {
	 if( to_Y< *akt_Y)
	 {
	    for( i= 0; i< 40; i+= 2)
	    {
	       getimage( to_X* 40+  1, to_Y* 40+  1+ i, to_X* 40+ 39, to_Y* 40+ 39+ i, mem_ptr);
		    bar( to_X* 40+  1, to_Y* 40+  1+ i, to_X* 40+ 39, to_Y* 40+  2+ i);
	       putimage( to_X* 40+  1, to_Y* 40+  3+ i, mem_ptr, COPY_PUT);
	       delay( MOVE_DELAY);
	    }
	 }
	 else
	 {
	    for( i= 0; i< 40; i+= 2)
	    {
	       getimage( to_X* 40+  1, to_Y* 40+  1- i, to_X* 40+ 39, to_Y* 40+ 39- i, mem_ptr);
		    bar( to_X* 40+  1, to_Y* 40+ 38- i, to_X* 40+ 39, to_Y* 40+ 39- i);
	       putimage( to_X* 40+  1, to_Y* 40+ -1- i, mem_ptr, COPY_PUT);
	       delay( MOVE_DELAY);
	    }
	 }
      }
   }
   *akt_X= to_X;
   *akt_Y= to_Y;
}

void Puzzle( void)
{
   time_t t;
   void *mem_ptr;
   int i, akt_X= 0, akt_Y= 0;

   if(( mem_ptr= malloc( imagesize( 1, 1, 39, 39)))!= NULL)
   {
      srand( ( unsigned)time( &t));
      setcolor( EGA_BLACK);
      for( i= 0; i< 640; i+= 40)
	 line( i, 0, i, 479);
      for( i= 0; i< 480; i+= 40)
	 line( 0, i, 639, i);
      DrawBlack( akt_X, akt_Y);
      while( !MouseMove()&& ( MouseStat()!= LEFT)&& !kbhit())
      {
	 delay( NEXT_DELAY);
	 MoveBlack( &akt_X, &akt_Y, mem_ptr);
      }
      LoschTbuf();
      free( mem_ptr);
   }
   else
   {
      ErrorMsg( KEIN_SPEICHER);
      Fuse();
   }
}

void ScreenSaver( void)
{
   saveall sa;

   ShowMouse( AUS);
   SaveAll( &sa);
   MouseMove();
   if( bildschirmschoner== PUZZLE_SCHONER)
      Puzzle();
   else
      Fuse();
   RestoreAll( &sa);
   ShowMouse( AN);
   screensp= 0;
}