/*  MAKE_IDB.C  Program that generates the installation data base
 *  Copyright (C) 1991-1998  Felix Ritter
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <assert.h>
#include <io.h>
#include <fcntl.h>
#include <string.h>
#include <stdio.h>

#define HGRP_ID           0
#define INST_MAXGRUPPEN   17
#define INST_MAXPROGRAMME 50
#define INST_DEFAULT_DIR  0
#define INST_PRG_DIR      1
#define ICO_INTERN        ""

typedef unsigned char BYTE;
typedef unsigned      WORD;

typedef struct
	{
	   char *PRG_name,           /* Name des Programm (max. 16 Zeichen) */
		*PRG_file,                           /* Name der Startdatei */
		*ICO_file;  /* Name der Icondatei (ICO_INTERN fr internes) */
	   BYTE Q_workdir,        /* entw. INST_DEFAULT_DIR o. INST_PRG_DIR */
		GRP_offset;          /* Offset in die Gruppenauswahltabelle */
	}PRG_struct;

int main( void)
{
   int ret_val= 0, handle, i;
   WORD Anz_GRP, Anz_PRG, Len;
   BYTE name_len, file_len, ico_len;

   /* WICHTIG: Offset: 0 ist immer der Hauptgruppe vorbehalten !!! */

   char *GruppenTAB[]= { "Hauptgruppe",                       /* Offset:  0 */
			 "Textverarbeitung",                  /* Offset:  1 */
			 "Programmieren",                     /* Offset:  2 */
			 "Grafik",                            /* Offset:  3 */
			 "Datenbanken",                       /* Offset:  4 */
			 "Hilfsprogramme",                    /* Offset:  5 */
			 "Utilitys",                          /* Offset:  6 */
			 "Tab-Kalkulation",                   /* Offset:  7 */
			 "Spiele",                            /* Offset:  8 */
			 "Multimedia",                        /* Offset:  9 */
			 "Dateiverwaltung",                   /* Offset: 10 */
			 "Lexikon",                           /* Offset: 11 */
			 "Virenkiller",                       /* Offset: 12 */
			 "DTP",                               /* Offset: 13 */
			 "CAD" };                             /* Offset: 14 */

   PRG_struct PRG[]= { { "Word fr Windows", "winword.exe",  ICO_INTERN,     INST_PRG_DIR,      1},
		       { "Ami Pro",          "amipro.exe",   ICO_INTERN,     INST_PRG_DIR,      1},
		       { "Word fr DOS",     "word.exe",     "word.ico",     INST_PRG_DIR,      1},
		       { "Windows Write",    "write.exe",    ICO_INTERN,     INST_PRG_DIR,      1},
		       { "Borland C++",      "bc.exe",       "cpp.ico",      INST_PRG_DIR,      2},
		       { "Turbo Pascal",     "turbo.exe",    "pascal.ico",   INST_PRG_DIR,      2},
		       { "WINTurbo C++",     "tcw.exe",      ICO_INTERN,     INST_PRG_DIR,      2},
		       { "Workshop",         "workshop.exe", ICO_INTERN,     INST_PRG_DIR,      2},
		       { "QBasic",           "qbasic.exe",   "basic.ico",    INST_PRG_DIR,      2},
		       { "Coreldraw",        "coreldrw.exe", ICO_INTERN,     INST_PRG_DIR,      3},
		       { "Paintbrush",       "pbrush.exe",   ICO_INTERN,     INST_PRG_DIR,      3},
		       { "GrafikWorkShop",   "gws.exe",      "paint.ico",    INST_PRG_DIR,      3},
		       { "DBASE",            "dbase.exe",    "tab_kalk.ico", INST_PRG_DIR,      4},
		       { "Speeddisk",        "speedisk.exe", "harddisk.ico", INST_PRG_DIR,      5},
		       { "Diskdoktor",       "ndd.exe",      "harddisk.ico", INST_PRG_DIR,      5},
		       { "Excel",            "excel.exe",    ICO_INTERN,     INST_PRG_DIR,      7},
		       { "Commanche",        "comanche.exe", "joystick.ico", INST_PRG_DIR,      8},
		       { "Lemmings 2",       "l2.exe",       "joystick.ico", INST_PRG_DIR,      8},
		       { "Dynablaster",      "dyna.exe",     "dyna.ico",     INST_PRG_DIR,      8},
		       { "Norton Commander", "nc.exe",       "disk.ico",     INST_DEFAULT_DIR, 10},
		       { "PC-Tools",         "pctools.exe",  "disk.ico",     INST_DEFAULT_DIR, 10},
		       { "Beckertools",      "bktools?.exe", ICO_INTERN,     INST_PRG_DIR,     10},
		       { "DOS-Shell",        "dosshell.com", "disk.ico",     INST_DEFAULT_DIR, 10},
		       { "PC-Globe",         "pcglobe.exe",  "erde.ico",     INST_PRG_DIR,     11},
		       { "TNT-Virus",        "tntvirus.exe", "virus.ico",    INST_PRG_DIR,     12},
		       { "Pagemaker",        "pm?.exe",      ICO_INTERN,     INST_PRG_DIR,     13},
		       { "MS-Windows",       "win.com",      "windows.ico",  INST_PRG_DIR,     HGRP_ID}
		     };
   assert( ( Anz_PRG= sizeof( PRG)/ sizeof( PRG_struct))<= INST_MAXPROGRAMME);
   assert( ( Anz_GRP= sizeof( GruppenTAB)/ sizeof( char *))<= INST_MAXGRUPPEN);
   if(( handle= _creat( "INSTALL.DAT", 0))!= -1)
   {
      if(( _write( handle, &Anz_GRP, sizeof( WORD))!= -1)&& ( _write( handle, &Anz_PRG, sizeof( WORD))!= -1))
      {
	 for( i= 0; i< Anz_GRP; i++)
	 {
	    Len= strlen( GruppenTAB[ i])+ 2;
	    if(( _write( handle, &( BYTE)Len, sizeof( BYTE))== -1)|| ( _write( handle, GruppenTAB[ i], Len- 1)== -1))
	    {
	       puts( "Schreibfehler !");
	       ret_val= -1;
	       break;
	    }
	 }
	 if( !ret_val)                                       /* kein Fehler */
	 {
	    for( i= 0; i< Anz_PRG; i++)
	    {
	       Len= 7+ ( name_len= strlen( ( PRG[ i]).PRG_name)+ 1)+ ( file_len= strlen( ( PRG[ i]).PRG_file)+ 1)+ ( ico_len= strlen( ( PRG[ i]).ICO_file)+ 1);
	       if(( _write( handle, &Len, sizeof( WORD))== -1)|| ( _write( handle, &( PRG[ i]).Q_workdir, sizeof( BYTE))== -1)|| ( _write( handle, &( PRG[ i]).GRP_offset, sizeof( BYTE))== -1)|| ( _write( handle, &name_len, sizeof( BYTE))== -1)|| ( _write( handle, &file_len, sizeof( BYTE))== -1)|| ( _write( handle, &ico_len, sizeof( BYTE))== -1)|| ( _write( handle, ( PRG[ i]).PRG_name, name_len)== -1)|| ( _write( handle, strupr( ( PRG[ i]).PRG_file), file_len)== -1)|| ( _write( handle, strupr( ( PRG[ i]).ICO_file), ico_len)== -1))
	       {
		  puts( "Schreibfehler !");
		  ret_val= -1;
		  break;
	       }
	    }
	 }
      }
      _close( handle);
   }
   else
      puts( "Kann die Datei nicht erzeugen !");
   return( ret_val);
}