/////////////////////////////////////////////////////////////////////
////                                                             ////
////  ADD_SUB24_R                                                ////
////  Registered Add/Subtract Unit 24 bit wide                   ////
////                                                             ////
////  Author: Rudolf Usselmann                                   ////
////          russelmann@hotmail.com                             ////
////                                                             ////
/////////////////////////////////////////////////////////////////////
////                                                             ////
//// Copyright (C) 2000 Rudolf Usselmann                         ////
////                    russelmann@hotmail.com                   ////
////                                                             ////
//// This source file may be used and distributed without        ////
//// restriction provided that this copyright statement is not   ////
//// removed from the file and that any derivative work contains ////
//// the original copyright notice and the associated disclaimer.////
////                                                             ////
//// THIS SOURCE FILE IS PROVIDED "AS IS" AND WITHOUT ANY        ////
//// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT           ////
//// LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND   ////
//// FITNESS FOR A PARTICULAR PURPOSE.                           ////
////                                                             ////
/////////////////////////////////////////////////////////////////////


`timescale 1ns / 10ps

module add_sub24_r(clk, add, opa, opb, sum);
input		clk;
input		add;
input	[23:0]	opa, opb;
output	[24:0]	sum;

reg	[24:0]	sum;
wire	[23:0]	sum_d;	// Sum
wire		co_d;	// Carry

////////////////////////////////////////////////////////////////////////
//
// Add/Sub
//

assign {co_d, sum_d} = add ? (opa + opb) : (opa - opb);

always @(posedge clk)
	sum <= #1 {co_d, sum_d};

endmodule

