/////////////////////////////////////////////////////////////////////
////                                                             ////
////  NORM                                                       ////
////  Floating Point Normalisation Unit                          ////
////                                                             ////
////  Author: Rudolf Usselmann                                   ////
////          russelmann@hotmail.com                             ////
////                                                             ////
/////////////////////////////////////////////////////////////////////
////                                                             ////
//// Copyright (C) 2000 Rudolf Usselmann                         ////
////                    russelmann@hotmail.com                   ////
////                                                             ////
//// This source file may be used and distributed without        ////
//// restriction provided that this copyright statement is not   ////
//// removed from the file and that any derivative work contains ////
//// the original copyright notice and the associated disclaimer.////
////                                                             ////
//// THIS SOURCE FILE IS PROVIDED "AS IS" AND WITHOUT ANY        ////
//// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT           ////
//// LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND   ////
//// FITNESS FOR A PARTICULAR PURPOSE.                           ////
////                                                             ////
/////////////////////////////////////////////////////////////////////


`timescale 1ns / 10ps

module norm( clk, fract_in, exp_in, out);
input		clk;
input	[24:0]	fract_in;
input	[7:0]	exp_in;
output	[30:0]	out;

////////////////////////////////////////////////////////////////////////
//
// Local Wires and registers
//

reg	[5:0]	exp_adj;
reg	[24:0]	fract_out;
wire	[7:0]	exp_out;
wire	[30:0]	out;

////////////////////////////////////////////////////////////////////////
//
// Normalize Result
//

// Count Number of zeros in fract_in from msb to lsb and adjust
// output so there are no leading zeros

always @(fract_in)
   casex(fract_in)	// synopsys full_case parallel_case
	25'b1_????_????_????_????_????_????: fract_out = fract_in;
							// RHS is basically a Shift Right
	25'b0_1???_????_????_????_????_????: fract_out = {fract_in[23:0], 01'b0};
	25'b0_01??_????_????_????_????_????: fract_out = {fract_in[22:0], 02'b0};
	25'b0_001?_????_????_????_????_????: fract_out = {fract_in[21:0], 03'b0};
	25'b0_0001_????_????_????_????_????: fract_out = {fract_in[20:0], 04'b0};
	
	25'b0_0000_1???_????_????_????_????: fract_out = {fract_in[19:0], 05'b0};
	25'b0_0000_01??_????_????_????_????: fract_out = {fract_in[18:0], 06'b0};
	25'b0_0000_001?_????_????_????_????: fract_out = {fract_in[17:0], 07'b0};
	25'b0_0000_0001_????_????_????_????: fract_out = {fract_in[16:0], 08'b0};
	
	25'b0_0000_0000_1???_????_????_????: fract_out = {fract_in[15:0], 09'b0};
	25'b0_0000_0000_01??_????_????_????: fract_out = {fract_in[14:0], 10'b0};
	25'b0_0000_0000_001?_????_????_????: fract_out = {fract_in[13:0], 11'b0};
	25'b0_0000_0000_0001_????_????_????: fract_out = {fract_in[12:0], 12'b0};

	25'b0_0000_0000_0000_1???_????_????: fract_out = {fract_in[11:0], 13'b0};
	25'b0_0000_0000_0000_01??_????_????: fract_out = {fract_in[10:0], 14'b0};
	25'b0_0000_0000_0000_001?_????_????: fract_out = {fract_in[09:0], 15'b0};
	25'b0_0000_0000_0000_0001_????_????: fract_out = {fract_in[08:0], 16'b0};

	25'b0_0000_0000_0000_0000_1???_????: fract_out = {fract_in[07:0], 17'b0};
	25'b0_0000_0000_0000_0000_01??_????: fract_out = {fract_in[06:0], 18'b0};
	25'b0_0000_0000_0000_0000_001?_????: fract_out = {fract_in[05:0], 19'b0};
	25'b0_0000_0000_0000_0000_0001_????: fract_out = {fract_in[04:0], 20'b0};

	25'b0_0000_0000_0000_0000_0000_1???: fract_out = {fract_in[03:0], 21'b0};
	25'b0_0000_0000_0000_0000_0000_01??: fract_out = {fract_in[02:0], 22'b0};
	25'b0_0000_0000_0000_0000_0000_001?: fract_out = {fract_in[01:0], 23'b0};
	25'b0_0000_0000_0000_0000_0000_0001: fract_out = {fract_in[0000], 24'b0};
   endcase

// Determine how much to add to exp_out
always @(fract_in)
   casex(fract_in)	// synopsys full_case parallel_case
	25'b1_????_????_????_????_????_????: exp_adj =  1;
	
	25'b0_1???_????_????_????_????_????: exp_adj =  0;
	25'b0_01??_????_????_????_????_????: exp_adj = -1;
	25'b0_001?_????_????_????_????_????: exp_adj = -2;
	25'b0_0001_????_????_????_????_????: exp_adj = -3;

	25'b0_0000_1???_????_????_????_????: exp_adj = -4;
	25'b0_0000_01??_????_????_????_????: exp_adj = -5;
	25'b0_0000_001?_????_????_????_????: exp_adj = -6;
	25'b0_0000_0001_????_????_????_????: exp_adj = -7;
	
	25'b0_0000_0000_1???_????_????_????: exp_adj = -8;
	25'b0_0000_0000_01??_????_????_????: exp_adj = -9;
	25'b0_0000_0000_001?_????_????_????: exp_adj = -10;
	25'b0_0000_0000_0001_????_????_????: exp_adj = -11;

	25'b0_0000_0000_0000_1???_????_????: exp_adj = -12;
	25'b0_0000_0000_0000_01??_????_????: exp_adj = -13;
	25'b0_0000_0000_0000_001?_????_????: exp_adj = -14;
	25'b0_0000_0000_0000_0001_????_????: exp_adj = -15;

	25'b0_0000_0000_0000_0000_1???_????: exp_adj = -16;
	25'b0_0000_0000_0000_0000_01??_????: exp_adj = -17;
	25'b0_0000_0000_0000_0000_001?_????: exp_adj = -18;
	25'b0_0000_0000_0000_0000_0001_????: exp_adj = -19;

	25'b0_0000_0000_0000_0000_0000_1???: exp_adj = -20;
	25'b0_0000_0000_0000_0000_0000_01??: exp_adj = -21;
	25'b0_0000_0000_0000_0000_0000_001?: exp_adj = -22;
	25'b0_0000_0000_0000_0000_0000_0001: exp_adj = -23;
	25'b0_0000_0000_0000_0000_0000_0000: exp_adj = 0;
   endcase

assign exp_out = exp_in + {exp_adj[5], exp_adj[5], exp_adj};

assign	out = {exp_out[7:0], fract_out[23:1]};

endmodule

