/////////////////////////////////////////////////////////////////////
////                                                             ////
////  FASU                                                       ////
////  Floating point Add/Subtract Unit (Single precision)        ////
////                                                             ////
////  TEST BENCH                                                 ////
////                                                             ////
////  Author: Rudolf Usselmann                                   ////
////          russelmann@hotmail.com                             ////
////                                                             ////
/////////////////////////////////////////////////////////////////////
////                                                             ////
//// Copyright (C) 2000 Rudolf Usselmann                         ////
////                    russelmann@hotmail.com                   ////
////                                                             ////
//// This source file may be used and distributed without        ////
//// restriction provided that this copyright statement is not   ////
//// removed from the file and that any derivative work contains ////
//// the original copyright notice and the associated disclaimer.////
////                                                             ////
//// THIS SOURCE FILE IS PROVIDED "AS IS" AND WITHOUT ANY        ////
//// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT           ////
//// LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTIBILITY AND   ////
//// FITNESS FOR A PARTICULAR PURPOSE.                           ////
////                                                             ////
/////////////////////////////////////////////////////////////////////


`timescale 1ns / 10ps

module test;

reg		clk;
reg	[31:0]	opa;
reg	[31:0]	opb;
wire	[31:0]	sum;
wire		inf, nan;

reg		add;
reg	[31:0]	exp, exp1, exp2, exp3, exp4;
reg	[31:0]	opa1, opa2, opa3, opa4;
reg	[31:0]	opb1, opb2, opb3, opb4;
reg		add1, add2, add3, add4;
reg		start, s1, s2, s3, s4;

always #50 clk = ~clk;

initial
   begin
        $display ("\n\nFloating Point Add/Subtract Unit Version 1.0\n\n");

	clk = 0;
	add = 1;	// 1 = Add, 0 = Sub
	start = 0;
	s1 = 0;
	s2 = 0;
	s3 = 0;
	s4 = 0;
	@(posedge clk);


	$display("Operation Add ...");
	
	@(posedge clk);
	#1;
	start = 1;
	opa = {1'b0, 8'h87, 23'b0110_0100_1001_0000_0000_000};
	opb = {1'b0, 8'h7b, 23'h0000};
	exp = 32'h43b25000;

	@(posedge clk);
	#1;
	opa = {1'b0, 8'h7b, 23'h0000};
	opb = {1'b0, 8'h87, 23'b0110_0100_1001_0000_0000_000};
	exp = 32'h43b25000;
	
	@(posedge clk);
	#1;
	add = 1;	// 1 = Add, 0 = Sub
	$display("\n\nOperation Add ...");
	
	opa = {1'b0, 8'h81, 23'h60_0000};	// 7
	opb = {1'b0, 8'h81, 23'h20_0000};	// 5
	exp = 32'h41400000;


	@(posedge clk);
	#1;
	opb = {1'b0, 8'h82, 23'h10_0000};	// 9
	exp = 32'h41800000;

	@(posedge clk);
	#1;
	opb = {1'b1, 8'h81, 23'h20_0000};	// -5
	exp = 32'h40000000;

	@(posedge clk);
	#1;
	opb = {1'b1, 8'h82, 23'h10_0000};	// -9
	exp = 32'hc0000000;

	@(posedge clk);
	#1;
	opa = {1'b1, 8'h81, 23'h60_0000};	// -7
	opb = {1'b0, 8'h81, 23'h20_0000};	// 5
	exp = 32'hc0000000;

	@(posedge clk);
	#1;
	opb = {1'b0, 8'h82, 23'h10_0000};	// 9
	exp = 32'h40000000;

	@(posedge clk);
	#1;
	opb = {1'b1, 8'h81, 23'h20_0000};	// -5
	exp = 32'hc1400000;

	@(posedge clk);
	#1;
	opb = {1'b1, 8'h82, 23'h10_0000};	// -9
	exp = 32'hc1800000;

	@(posedge clk);
	#1;
	add = 0;	// 1 = Add, 0 = Sub
	$display("\n\nOperation Sub ...\n");

	opa = {1'b0, 8'h81, 23'h60_0000};	// 7
	opb = {1'b0, 8'h81, 23'h20_0000};	// 5
	exp = 32'h40000000;

	@(posedge clk);
	#1;
	opb = {1'b0, 8'h82, 23'h10_0000};	// 9
	exp = 32'hc0000000;

	@(posedge clk);
	#1;
	opb = {1'b1, 8'h81, 23'h20_0000};	// -5
	exp = 32'h41400000;

	@(posedge clk);
	#1;
	opb = {1'b1, 8'h82, 23'h10_0000};	// -9
	exp = 32'h41800000;

	@(posedge clk);
	#1;
	opa = {1'b1, 8'h81, 23'h60_0000};	// -7
	opb = {1'b0, 8'h81, 23'h20_0000};	// 5
	exp = 32'hc1400000;

	@(posedge clk);
	#1;
	opb = {1'b0, 8'h82, 23'h10_0000};	// 9
	exp = 32'hc1800000;

	@(posedge clk);
	#1;
	opb = {1'b1, 8'h81, 23'h20_0000};	// -5
	exp = 32'hc0000000;

	@(posedge clk);
	#1;
	opb = {1'b1, 8'h82, 23'h10_0000};	// -9
	exp = 32'h40000000;


	$display("Testing Zero ...\n");
	@(posedge clk);
	#1;
	add = 1;				// 1 = Add, 0 = Sub
	opa = {1'b0, 8'h81, 23'h60_0000};	// 7
	opb = {1'b0, 8'h00, 23'h00_0000};	// 0
	exp = {1'b0, 8'h81, 23'h60_0000};	// 7

	@(posedge clk);
	#1;
	opa = {1'b0, 8'h81, 23'h60_0000};	// 7
	opb = {1'b1, 8'h00, 23'h00_0000};	// -0
	exp = {1'b0, 8'h81, 23'h60_0000};	// 7

	@(posedge clk);
	#1;
	add = 0;				// 1 = Add, 0 = Sub
	opa = {1'b0, 8'h81, 23'h60_0000};	// 7
	opb = {1'b0, 8'h00, 23'h00_0000};	// 0
	exp = {1'b0, 8'h81, 23'h60_0000};	// 7

	@(posedge clk);
	#1;
	opa = {1'b0, 8'h81, 23'h60_0000};	// 7
	opb = {1'b1, 8'h00, 23'h00_0000};	// -0
	exp = {1'b0, 8'h81, 23'h60_0000};	// 7

	@(posedge clk);
	#1;
	add = 1;				// 1 = Add, 0 = Sub
	opb = {1'b0, 8'h81, 23'h60_0000};	// 7
	opa = {1'b0, 8'h00, 23'h00_0000};	// 0
	exp = {1'b0, 8'h81, 23'h60_0000};	// 7

	@(posedge clk);
	#1;
	opb = {1'b0, 8'h81, 23'h60_0000};	// 7
	opa = {1'b1, 8'h00, 23'h00_0000};	// -0
	exp = {1'b0, 8'h81, 23'h60_0000};	// 7

	@(posedge clk);
	#1;
	add = 0;				// 1 = Add, 0 = Sub
	opb = {1'b0, 8'h81, 23'h60_0000};	// 7
	opa = {1'b0, 8'h00, 23'h00_0000};	// 0
	exp = {1'b1, 8'h81, 23'h60_0000};	// -7

	@(posedge clk);
	#1;
	opb = {1'b0, 8'h81, 23'h60_0000};	// 7
	opa = {1'b1, 8'h00, 23'h00_0000};	// -0
	exp = {1'b1, 8'h81, 23'h60_0000};	// -7


	@(posedge clk);
	#1;
	$display("Testing INF ...\n");
	add = 1;				// 1 = Add, 0 = Sub
	//opa = {1'b0, 8'h81, 23'h60_0000};	// 7
	//opb = {1'b0, 8'h81, 23'h20_0000};	// 5
	//exp = 32'h41400000;			// 12

	opa = {1'b0, 8'h81, 23'h7f_00ff};	// 7
	opb = {1'b0, 8'hff, 23'h00_0000};	// INF
	exp = 32'h7f800000;			// INF


	@(posedge clk);
	#1;
	opb = {1'b0, 8'h81, 23'h7f_00ff};	// 7
	opa = {1'b0, 8'hff, 23'h00_0000};	// INF
	exp = 32'h7f800000;			// INF

	@(posedge clk);
	#1;
	opa = {1'b0, 8'h40, 23'h7f_00ff};	// 7
	opb = {1'b0, 8'hff, 23'h00_0000};	// INF
	exp = 32'h7f800000;			// INF


	@(posedge clk);
	#1;
	opb = {1'b0, 8'h40, 23'h7f_00ff};	// 7
	opa = {1'b0, 8'hff, 23'h00_0000};	// INF
	exp = 32'h7f800000;			// INF

	@(posedge clk);
	#1;
	add = 0;				// 1 = Add, 0 = Sub
	opa = {1'b0, 8'h81, 23'h7f_00ff};	// 7
	opb = {1'b0, 8'hff, 23'h00_0000};	// INF
	exp = 32'hff800000;			// -INF


	@(posedge clk);
	#1;
	opa = {1'b0, 8'hff, 23'h00_0000};	// INF
	opb = {1'b0, 8'h81, 23'h7f_00ff};	// 7
	exp = 32'h7f800000;			// INF

	@(posedge clk);
	#1;
	opa = {1'b0, 8'h40, 23'h7f_00ff};	// 7
	opb = {1'b0, 8'hff, 23'h00_0000};	// INF
	exp = 32'hff800000;			// -INF


	@(posedge clk);
	#1;
	opb = {1'b0, 8'h40, 23'h7f_00ff};	// 7
	opa = {1'b0, 8'hff, 23'h00_0000};	// INF
	exp = 32'h7f800000;			// INF


	@(posedge clk);
	#1;
	$display("Testing NAN ...\n");
	add = 1;				// 1 = Add, 0 = Sub
	//opa = {1'b0, 8'h81, 23'h60_0000};	// 7
	//opb = {1'b0, 8'h81, 23'h20_0000};	// 5
	//exp = 32'h41400000;			// 12

	opa = {1'b0, 8'h81, 23'h7f_00ff};	// 7
	opb = {1'b0, 8'hff, 23'h00_0001};	// NAN
	exp = 32'h7f800001;			// NAN


	@(posedge clk);
	#1;
	opb = {1'b0, 8'h81, 23'h7f_00ff};	// 7
	opa = {1'b0, 8'hff, 23'h00_0001};	// NAN
	exp = 32'h7f800001;			// NAN

	@(posedge clk);
	#1;
	opa = {1'b0, 8'h40, 23'h7f_00ff};	// 7
	opb = {1'b0, 8'hff, 23'h00_0001};	// NAN
	exp = 32'h7f800001;			// NAN


	@(posedge clk);
	#1;
	opb = {1'b0, 8'h40, 23'h7f_00ff};	// 7
	opa = {1'b0, 8'hff, 23'h00_0001};	// NAN
	exp = 32'h7f800001;			// NAN


	@(posedge clk);
	#1;
	add = 0;				// 1 = Add, 0 = Sub
	opa = {1'b0, 8'h81, 23'h7f_00ff};	// 7
	opb = {1'b0, 8'hff, 23'h00_0001};	// NAN
	exp = 32'hff800001;			// -NAN


	@(posedge clk);
	#1;
	opa = {1'b0, 8'hff, 23'h00_0001};	// NAN
	opb = {1'b0, 8'h81, 23'h7f_00ff};	// 7
	exp = 32'h7f800001;			// NAN

	@(posedge clk);
	#1;
	opa = {1'b0, 8'h40, 23'h7f_00ff};	// 7
	opb = {1'b0, 8'hff, 23'h00_0001};	// NAN
	exp = 32'hff800001;			// -NAN


	@(posedge clk);
	#1;
	opb = {1'b0, 8'h40, 23'h7f_00ff};	// 7
	opa = {1'b0, 8'hff, 23'h00_0001};	// NAN
	exp = 32'h7f800001;			// NAN






	repeat (6)	@(posedge clk);
	$display("\n\n");
	
	//$dumpflush; 
	$finish;
   end

always @(posedge clk)
   begin
   	
   	s1 <= #1 start;
   	s2 <= #1 s1;
   	s3 <= #1 s2;
   	s4 <= #1 s3;



	exp1 <= #1 exp;
	exp2 <= #1 exp1;
	exp3 <= #1 exp2;
	exp4 <= #1 exp3;

	opa1 <= #1 opa;
	opa2 <= #1 opa1;
	opa3 <= #1 opa2;
	opa4 <= #1 opa3;

	opb1 <= #1 opb;
	opb2 <= #1 opb1;
	opb3 <= #1 opb2;
	opb4 <= #1 opb3;

	add1 <= #1 add;
	add2 <= #1 add1;
	add3 <= #1 add2;
	add4 <= #1 add3;

	#3;
	if(( exp4 !== sum ) & s4 )
	   begin
		$display("%t: ERROR: output mismatch. Expected %h, Got %h",$time,exp4,sum);
		$write("opa:\t");	disp_fp(opa4);
		if(add4)		$display("\t+");
		else			$display("\t-");
		$write("opb:\t");	disp_fp(opb4);
		$write("EXP:\t");	disp_fp(exp4);
		$write("GOT:\t");	disp_fp(sum);
		
		$display("\n");
	   end
   end

fasu u0(clk, add, opa, opb, sum);

task disp_fp;
input [31:0] fp;

reg [63:0]	x;

begin

$write("(%h %h %h) ",fp[31], fp[30:23], fp[22:0]);
 
x[51:0] = {fp[22:0], 29'h0};
x[63] = fp[31];
x[62] = fp[30];
x[61:59] = {fp[29], fp[29], fp[29]};
x[58:52] = fp[29:23];

$display("\t%f",$bitstoreal(x));
end

endtask

endmodule


























