/////////////////////////////////////////////////////////////////////
////                                                             ////
////  EXCEPT                                                     ////
////  Floating Point Exception Unit                              ////
////                                                             ////
////  Author: Rudolf Usselmann                                   ////
////          russelmann@hotmail.com                             ////
////                                                             ////
/////////////////////////////////////////////////////////////////////
////                                                             ////
//// Copyright (C) 2000 Rudolf Usselmann                         ////
////                    russelmann@hotmail.com                   ////
////                                                             ////
//// This source file may be used and distributed without        ////
//// restriction provided that this copyright statement is not   ////
//// removed from the file and that any derivative work contains ////
//// the original copyright notice and the associated disclaimer.////
////                                                             ////
//// THIS SOURCE FILE IS PROVIDED "AS IS" AND WITHOUT ANY        ////
//// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT           ////
//// LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND   ////
//// FITNESS FOR A PARTICULAR PURPOSE.                           ////
////                                                             ////
/////////////////////////////////////////////////////////////////////


`timescale 1ns / 10ps


module except(clk, opa, opb, inf, nan);
input		clk;
input	[31:0]	opa, opb;
output		inf, nan;


////////////////////////////////////////////////////////////////////////
//
// Local Wires and registers
//

wire	[7:0]	expa, expb;		// alias to opX exponenet
wire	[22:0]	fracta, fractb;		// alias to opX fraction
reg		infa_e_r, infa_f_r;
reg		infb_e_r, infb_f_r;
reg		inf, nan;		// Output registers

////////////////////////////////////////////////////////////////////////
//
// Aliases
//

assign   expa = opa[30:23];
assign   expb = opb[30:23];
assign fracta = opa[22:0];
assign fractb = opb[22:0];

////////////////////////////////////////////////////////////////////////
//
// Determine if any of the input operators is a INF or NAN
//

always @(posedge clk)
	infa_e_r <= #1 (expa == 8'hff);

always @(posedge clk)
	infa_f_r <= #1 (fracta == 23'h0000);

always @(posedge clk)
	infb_e_r <= #1 (expb == 8'hff);

always @(posedge clk)
	infb_f_r <= #1 (fractb == 23'h0000);

always @(posedge clk)
	inf <= #1 (infa_e_r & infa_f_r) | (infb_e_r & infb_f_r);

always @(posedge clk)
	nan <= #1 (infa_e_r & !infa_f_r) | (infb_e_r & !infb_f_r);
	
endmodule

