/////////////////////////////////////////////////////////////////////
////                                                             ////
////  FMUL                                                       ////
////  Floating point Multiply Unit (Single precision)            ////
////                                                             ////
////  TEST BENCH                                                 ////
////                                                             ////
////  Author: Rudolf Usselmann                                   ////
////          russelmann@hotmail.com                             ////
////                                                             ////
/////////////////////////////////////////////////////////////////////
////                                                             ////
//// Copyright (C) 2000 Rudolf Usselmann                         ////
////                    russelmann@hotmail.com                   ////
////                                                             ////
//// This source file may be used and distributed without        ////
//// restriction provided that this copyright statement is not   ////
//// removed from the file and that any derivative work contains ////
//// the original copyright notice and the associated disclaimer.////
////                                                             ////
//// THIS SOURCE FILE IS PROVIDED "AS IS" AND WITHOUT ANY        ////
//// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT           ////
//// LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTIBILITY AND   ////
//// FITNESS FOR A PARTICULAR PURPOSE.                           ////
////                                                             ////
/////////////////////////////////////////////////////////////////////


`timescale 1ns / 10ps

module test;

reg		clk;
reg	[31:0]	opa;
reg	[31:0]	opb;
wire	[31:0]	sum;
wire		inf, nan;

reg		add;
reg	[31:0]	exp, exp1, exp2, exp3, exp4;
reg	[31:0]	opa1, opa2, opa3, opa4;
reg	[31:0]	opb1, opb2, opb3, opb4;
reg		add1, add2, add3, add4;
reg		start, s1, s2, s3, s4;

always #50 clk = ~clk;

initial
   begin
        $display ("\n\nFloating Point Multiply Unit Version 1.0\n\n");

	clk = 0;

	start = 0;
	s1 = 0;
	s2 = 0;
	s3 = 0;
	s4 = 0;
	
	@(posedge clk);

	$display("Operation MUL ...");
	
	@(posedge clk);
	#1;
	start = 1;
	opa = {1'b0, 8'h87, 23'b0110_0100_1001_0000_0000_000};
	opb = {1'b0, 8'h7b, 23'h0000};
	exp = {1'b0, 8'h83, 23'h324800};

	@(posedge clk);
	#1;
	opa = {1'b0, 8'h7b, 23'h0000};
	opb = {1'b0, 8'h87, 23'b0110_0100_1001_0000_0000_000};
	exp = {1'b0, 8'h83, 23'h324800};
	
	@(posedge clk);
	#1;

	
	opa = {1'b0, 8'h80, 23'h60_0000};	// 3.5
	opb = {1'b0, 8'h7e, 23'h40_0000};	// 0.75
	exp = {1'b0, 8'h80, 23'h280000};


	@(posedge clk);
	#1;

	
	opa = {1'b0, 8'h81, 23'h60_0000};	// 7
	opb = {1'b0, 8'h81, 23'h20_0000};	// 5
	exp = 32'h420c0000;


	@(posedge clk);
	#1;
	opb = {1'b0, 8'h82, 23'h10_0000};	// 9
	exp = 32'h427c0000;

	@(posedge clk);
	#1;
	opb = {1'b1, 8'h81, 23'h20_0000};	// -5
	exp = 32'hc20c0000;

	@(posedge clk);
	#1;
	opb = {1'b1, 8'h82, 23'h10_0000};	// -9
	exp = 32'hc27c0000;

	@(posedge clk);
	#1;
	opa = {1'b1, 8'h81, 23'h60_0000};	// -7
	opb = {1'b0, 8'h81, 23'h20_0000};	// 5
	exp = 32'hc20c0000;

	@(posedge clk);
	#1;
	opb = {1'b0, 8'h82, 23'h10_0000};	// 9
	exp = 32'hc27c0000;

	@(posedge clk);
	#1;
	opb = {1'b1, 8'h81, 23'h20_0000};	// -5
	exp = 32'h420c0000;

	@(posedge clk);
	#1;
	opb = {1'b1, 8'h82, 23'h10_0000};	// -9
	exp = 32'h427c0000;

	@(posedge clk);
	#1;


	repeat (6)	@(posedge clk);
	$display("\n\n");
	
	//$dumpflush; 
	$finish;
   end

always @(posedge clk)
   begin
   	
   	s1 <= #1 start;
   	s2 <= #1 s1;
   	s3 <= #1 s2;
   	s4 <= #1 s3;

	exp1 <= #1 exp;
	exp2 <= #1 exp1;
	exp3 <= #1 exp2;
	exp4 <= #1 exp3;

	opa1 <= #1 opa;
	opa2 <= #1 opa1;
	opa3 <= #1 opa2;
	opa4 <= #1 opa3;

	opb1 <= #1 opb;
	opb2 <= #1 opb1;
	opb3 <= #1 opb2;
	opb4 <= #1 opb3;
	
	#3;
	if((exp4 !== sum) & s4 )
	   begin
		$display("%t: ERROR: output mismatch. Expected %h, Got %h",$time,exp4,sum);
		$write("opa:\t");	disp_fp(opa4);
		$display("\t*");
		$write("opb:\t");	disp_fp(opb4);

		$write("EXP:\t");	disp_fp(exp4);
		$write("GOT:\t");	disp_fp(sum);

		$display("\n");
	   end

   end

fmul u0(clk, opa, opb, sum);




task disp_fp;
input [31:0] fp;

reg [63:0]	x;

begin

$write("(%h %h %h) ",fp[31], fp[30:23], fp[22:0]);
 
x[51:0] = {fp[22:0], 29'h0};
x[63] = fp[31];
x[62] = fp[30];
x[61:59] = {fp[29], fp[29], fp[29]};
x[58:52] = fp[29:23];

$display("\t%f",$bitstoreal(x));
end

endtask


endmodule


























