--==========================================================================--
-- Design units : 10/100 Ethernet MAC - CRC-32 package
--
-- File name    : eth_crc32_4.vhd
--
-- Purpose      : This package contains a CRC-32 function to calculate the
--                Frame-Check-Sequence field of an Ethernet frame.
--
-- Note         : 4-bit-wide data input with first serial data bit = data(0).
--
-- Limitations  : None
--
-- Errors       : None known
--
-- Library      : EthMAC_Lib
--
-- Dependencies : None
--
-- Author       : Maik Boden (boden@ite.inf.tu-dresden.de)
--                Dresden University of Technology
--                Department of Information Science
--                Institute of Computer Engineering
--
-- Simulator    : VHDL Simili 1.4 Beta, Windows NT 4.0
------------------------------------------------------------------------------
-- Revision list
-- Version  Author  Date        Changes
-- 0.1      MB      2000-11-01  Initial revision
--==========================================================================--

library IEEE;
use IEEE.Std_Logic_1164.all;
library EthMAC_Lib;

package Eth_CRC32_4 is

  ----------------------------------------------------------------------------
  -- This CRC-32 function uses the polynominal x^32 + x^26 + x^23 + x^22
  -- + x^16 + x^12 + x^11 + x^10 + x^8 + x^7 + x^5 + x^4 + x^2 + x^1 + x^0.
  -- Input is 4 bit wide and first serial data bit is data(0).
  ----------------------------------------------------------------------------
  function nextCRC32_4(
      crc:  Std_ULogic_Vector(31 downto 0);
      data: Std_ULogic_Vector(3 downto 0)
    ) return Std_ULogic_Vector;

end Eth_CRC32_4;

--==========================================================================--

library IEEE;
use IEEE.Std_Logic_1164.all;

package body Eth_CRC32_4 is

  ----------------------------------------------------------------------------
  -- This CRC-32 function uses the polynominal x^32 + x^26 + x^23 + x^22
  -- + x^16 + x^12 + x^11 + x^10 + x^8 + x^7 + x^5 + x^4 + x^2 + x^1 + x^0.
  -- Input is 4 bit wide and first serial data bit is data(0).
  ----------------------------------------------------------------------------
  function nextCRC32_4(
      crc:  Std_ULogic_Vector(31 downto 0);
      data: Std_ULogic_Vector(3 downto 0)
    ) return Std_ULogic_Vector is
  
    variable newCrc: Std_ULogic_Vector(31 downto 0);
  
  begin
    newCrc(0)  := data(3) xor crc(28);
    newCrc(1)  := data(2) xor data(3) xor crc(28) xor crc(29);
    newCrc(2)  := data(1) xor data(2) xor data(3)
                  xor crc(28) xor crc(29) xor crc(30);
    newCrc(3)  := data(0) xor data(1) xor data(2)
                  xor crc(29) xor crc(30) xor crc(31);
    newCrc(4)  := data(0) xor data(1) xor data(3) xor crc(0)
                  xor crc(28) xor crc(30) xor crc(31);
    newCrc(5)  := data(0) xor data(2) xor data(3) xor crc(1)
                  xor crc(28) xor crc(29) xor crc(31);
    newCrc(6)  := data(1) xor data(2) xor crc(2) xor crc(29) xor crc(30);
    newCrc(7)  := data(0) xor data(1) xor data(3) xor crc(3)
                  xor crc(28) xor crc(30) xor crc(31);
    newCrc(8)  := data(0) xor data(2) xor data(3) xor crc(4)
                  xor crc(28) xor crc(29) xor crc(31);
    newCrc(9)  := data(1) xor data(2) xor crc(5) xor crc(29) xor crc(30);
    newCrc(10) := data(0) xor data(1) xor data(3) xor crc(6)
                  xor crc(28) xor crc(30) xor crc(31);
    newCrc(11) := data(0) xor data(2) xor data(3) xor crc(7)
                  xor crc(28) xor crc(29) xor crc(31);
    newCrc(12) := data(1) xor data(2) xor data(3) xor crc(8)
                  xor crc(28) xor crc(29) xor crc(30);
    newCrc(13) := data(0) xor data(1) xor data(2) xor crc(9)
                  xor crc(29) xor crc(30) xor crc(31);
    newCrc(14) := data(0) xor data(1) xor crc(10) xor crc(30) xor crc(31);
    newCrc(15) := data(0) xor crc(11) xor crc(31);
    newCrc(16) := data(3) xor crc(12) xor crc(28);
    newCrc(17) := data(2) xor crc(13) xor crc(29);
    newCrc(18) := data(1) xor crc(14) xor crc(30);
    newCrc(19) := data(0) xor crc(15) xor crc(31);
    newCrc(20) := crc(16);
    newCrc(21) := crc(17);
    newCrc(22) := data(3) xor crc(18) xor crc(28);
    newCrc(23) := data(2) xor data(3) xor crc(19) xor crc(28) xor crc(29);
    newCrc(24) := data(1) xor data(2) xor crc(20) xor crc(29) xor crc(30);
    newCrc(25) := data(0) xor data(1) xor crc(21) xor crc(30) xor crc(31);
    newCrc(26) := data(0) xor data(3) xor crc(22) xor crc(28) xor crc(31);
    newCrc(27) := data(2) xor crc(23) xor crc(29);
    newCrc(28) := data(1) xor crc(24) xor crc(30);
    newCrc(29) := data(0) xor crc(25) xor crc(31);
    newCrc(30) := crc(26);
    newCrc(31) := crc(27);
        
    return newCrc;
  end nextCRC32_4;

end Eth_CRC32_4;  -- End of package body
