/////////////////////////////////////////////////////////////////////
////                                                             ////
////  F2I                                                        ////
////  Floating Point to Integer (single precision)               ////
////                                                             ////
////                                                             ////
////  Author: Rudolf Usselmann                                   ////
////          russelmann@hotmail.com                             ////
////                                                             ////
/////////////////////////////////////////////////////////////////////
////                                                             ////
//// Copyright (C) 2000 Rudolf Usselmann                         ////
////                    russelmann@hotmail.com                   ////
////                                                             ////
//// This source file may be used and distributed without        ////
//// restriction provided that this copyright statement is not   ////
//// removed from the file and that any derivative work contains ////
//// the original copyright notice and the associated disclaimer.////
////                                                             ////
//// THIS SOURCE FILE IS PROVIDED "AS IS" AND WITHOUT ANY        ////
//// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT           ////
//// LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND   ////
//// FITNESS FOR A PARTICULAR PURPOSE.                           ////
////                                                             ////
/////////////////////////////////////////////////////////////////////


`timescale 1ns / 10ps

module f2i( fp, int);
input	[31:0]	fp;
output	[31:0]	int;

////////////////////////////////////////////////////////////////////////
//
// Local Wires and registers
//

wire		sign;
wire	[7:0]	exp, exp_tmp;
wire	[22:0]	fract;
wire	[31:0]	int_tmp, int_twos_compl;

////////////////////////////////////////////////////////////////////////
//
// Convert Floating Point to Integer
//

assign  sign = fp[31];
assign   exp = fp[30:23];
assign fract = fp[22:0];

assign exp_tmp = 23 - (exp - 127);

assign int_tmp = {1'b1,fract} >> (exp_tmp);
assign int_twos_compl = ~int_tmp + 1;

assign int = sign ? int_twos_compl : int_tmp;

endmodule

